/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.spitter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitter;

public class DoubleIntervalSplitter
implements IntervalSplitter {
    @Override
    public List<MutablePair<String, String>> getIntervals(String lowerBound, String upperBound, int numPartitions, TypeInfo typeInfo) {
        ArrayList<MutablePair<String, String>> intervals = new ArrayList<MutablePair<String, String>>();
        double doubleLower = Double.parseDouble(lowerBound);
        double doubleUpper = Double.parseDouble(upperBound);
        double doubleInterval = (doubleUpper - doubleLower) / (double)numPartitions;
        for (int i = 0; i < numPartitions; ++i) {
            double splitDoubleUpper = doubleLower + doubleInterval * (double)(i + 1);
            double splitDoubleLower = doubleLower + doubleInterval * (double)i;
            if (!(splitDoubleUpper > splitDoubleLower)) continue;
            intervals.add((MutablePair<String, String>)new MutablePair((Object)Double.toString(splitDoubleLower), (Object)Double.toString(splitDoubleUpper)));
        }
        return intervals;
    }
}

