/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.dao;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hive.storage.jdbc.exception.HiveJdbcDatabaseAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordIterator
implements Iterator<Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcRecordIterator.class);
    private Connection conn;
    private PreparedStatement ps;
    private ResultSet rs;
    private String[] hiveColumnNames;
    List<TypeInfo> hiveColumnTypesList;

    public JdbcRecordIterator(Connection conn, PreparedStatement ps, ResultSet rs, Configuration conf) throws HiveJdbcDatabaseAccessException {
        String fieldTypesProperty;
        String fieldNamesProperty;
        this.conn = conn;
        this.ps = ps;
        this.rs = rs;
        if (conf.get("hive.sql.table") != null && conf.get("hive.sql.query") != null) {
            fieldNamesProperty = (String)Preconditions.checkNotNull((Object)conf.get("hive.sql.query.fieldNames"));
            fieldTypesProperty = (String)Preconditions.checkNotNull((Object)conf.get("hive.sql.query.fieldTypes"));
        } else {
            try {
                if (conf.get("hive.sql.query") == null) {
                    ResultSetMetaData metadata = rs.getMetaData();
                    int numColumns = metadata.getColumnCount();
                    ArrayList<String> columnNames = new ArrayList<String>(numColumns);
                    for (int i = 0; i < numColumns; ++i) {
                        columnNames.add(metadata.getColumnName(i + 1));
                    }
                    fieldNamesProperty = String.join((CharSequence)",", columnNames);
                } else {
                    fieldNamesProperty = (String)Preconditions.checkNotNull((Object)conf.get("columns"));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while trying to get column names.", (Throwable)e);
                throw new HiveJdbcDatabaseAccessException("Error while trying to get column names: " + e.getMessage(), e);
            }
            fieldTypesProperty = (String)Preconditions.checkNotNull((Object)conf.get("columns.types"));
        }
        LOGGER.debug("Iterator ColumnNames = {}", (Object)fieldNamesProperty);
        this.hiveColumnNames = fieldNamesProperty.trim().split(",");
        this.hiveColumnTypesList = TypeInfoUtils.getTypeInfosFromTypeString((String)fieldTypesProperty);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.rs.next();
        }
        catch (Exception se) {
            LOGGER.warn("hasNext() threw exception", (Throwable)se);
            return false;
        }
    }

    @Override
    public Map<String, Object> next() {
        try {
            HashMap<String, Object> record = new HashMap<String, Object>(this.hiveColumnNames.length);
            for (int i = 0; i < this.hiveColumnNames.length; ++i) {
                String key = this.hiveColumnNames[i];
                Object value = null;
                if (!(this.hiveColumnTypesList.get(i) instanceof PrimitiveTypeInfo)) {
                    throw new RuntimeException("date type of column " + this.hiveColumnNames[i] + ":" + this.hiveColumnTypesList.get(i).getTypeName() + " is not supported");
                }
                try {
                    switch (((PrimitiveTypeInfo)this.hiveColumnTypesList.get(i)).getPrimitiveCategory()) {
                        case INT: 
                        case SHORT: 
                        case BYTE: {
                            value = this.rs.getInt(i + 1);
                            break;
                        }
                        case LONG: {
                            value = this.rs.getLong(i + 1);
                            break;
                        }
                        case FLOAT: {
                            value = Float.valueOf(this.rs.getFloat(i + 1));
                            break;
                        }
                        case DOUBLE: {
                            value = this.rs.getDouble(i + 1);
                            break;
                        }
                        case DECIMAL: {
                            value = this.rs.getBigDecimal(i + 1);
                            break;
                        }
                        case BOOLEAN: {
                            boolean b = this.rs.getBoolean(i + 1);
                            if (b && this.rs.getMetaData().getColumnType(i + 1) == 1) {
                                b = !"N".equals(this.rs.getString(i + 1));
                            }
                            value = b;
                            break;
                        }
                        case CHAR: 
                        case VARCHAR: 
                        case STRING: {
                            value = this.rs.getString(i + 1);
                            break;
                        }
                        case DATE: {
                            value = this.rs.getDate(i + 1);
                            break;
                        }
                        case TIMESTAMP: {
                            value = this.rs.getTimestamp(i + 1);
                            break;
                        }
                        default: {
                            LOGGER.error("date type of column " + this.hiveColumnNames[i] + ":" + ((PrimitiveTypeInfo)this.hiveColumnTypesList.get(i)).getPrimitiveCategory() + " is not supported");
                            value = null;
                        }
                    }
                    if (value != null && !this.rs.wasNull()) {
                        record.put(key, value);
                        continue;
                    }
                    record.put(key, null);
                    continue;
                }
                catch (SQLDataException e) {
                    record.put(key, null);
                }
            }
            return record;
        }
        catch (Exception e) {
            LOGGER.warn("next() threw exception", (Throwable)e);
            if (e instanceof SQLException) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public void close() {
        try {
            this.rs.close();
            this.ps.close();
            this.conn.close();
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while trying to close database objects", (Throwable)e);
        }
    }
}

