/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.storage.jdbc.JdbcInputSplit;
import org.apache.hive.storage.jdbc.JdbcRecordReader;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessorFactory;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitter;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcInputFormat
extends HiveInputFormat<LongWritable, MapWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcInputFormat.class);
    private DatabaseAccessor dbAccessor = null;

    public RecordReader<LongWritable, MapWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (!(split instanceof JdbcInputSplit)) {
            throw new RuntimeException("Incompatible split type " + split.getClass().getName() + ".");
        }
        return new JdbcRecordReader(job, (JdbcInputSplit)split);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        try {
            InputSplit[] splits;
            String partitionColumn = job.get("hive.sql.partitionColumn");
            int numPartitions = job.getInt("hive.sql.numPartitions", -1);
            String lowerBound = job.get("hive.sql.lowerBound");
            String upperBound = job.get("hive.sql.upperBound");
            if (!job.getBoolean("hive.sql.query.split", true) || numPartitions <= 1) {
                InputSplit[] splits2 = new InputSplit[]{new JdbcInputSplit(FileInputFormat.getInputPaths((JobConf)job)[0])};
                LOGGER.info("Creating 1 input split " + splits2[0]);
                return splits2;
            }
            this.dbAccessor = DatabaseAccessorFactory.getAccessor((Configuration)job);
            Path[] tablePaths = FileInputFormat.getInputPaths((JobConf)job);
            LOGGER.debug("Creating {} input splits", (Object)numPartitions);
            if (partitionColumn != null) {
                List<String> columnNames = this.dbAccessor.getColumnNames((Configuration)job);
                if (!columnNames.contains(partitionColumn)) {
                    throw new IOException("Cannot find partitionColumn:" + partitionColumn + " in " + columnNames);
                }
                List<TypeInfo> hiveColumnTypesList = this.dbAccessor.getColumnTypes((Configuration)job);
                TypeInfo typeInfo = hiveColumnTypesList.get(columnNames.indexOf(partitionColumn));
                if (!(typeInfo instanceof PrimitiveTypeInfo)) {
                    throw new IOException(partitionColumn + " is a complex type, only primitive type can be a partition column");
                }
                if (lowerBound == null || upperBound == null) {
                    Pair<String, String> boundary = this.dbAccessor.getBounds((Configuration)job, partitionColumn, lowerBound == null, upperBound == null);
                    if (lowerBound == null) {
                        lowerBound = (String)boundary.getLeft();
                    }
                    if (upperBound == null) {
                        upperBound = (String)boundary.getRight();
                    }
                }
                if (lowerBound == null) {
                    throw new IOException("lowerBound of " + partitionColumn + " cannot be null");
                }
                if (upperBound == null) {
                    throw new IOException("upperBound of " + partitionColumn + " cannot be null");
                }
                IntervalSplitter intervalSplitter = IntervalSplitterFactory.newIntervalSpitter(typeInfo);
                List<MutablePair<String, String>> intervals = intervalSplitter.getIntervals(lowerBound, upperBound, numPartitions, typeInfo);
                if (intervals.size() <= 1) {
                    LOGGER.debug("Creating 1 input splits");
                    InputSplit[] splits3 = new InputSplit[]{new JdbcInputSplit(FileInputFormat.getInputPaths((JobConf)job)[0])};
                    return splits3;
                }
                intervals.get(0).setLeft(null);
                intervals.get(intervals.size() - 1).setRight(null);
                splits = new InputSplit[intervals.size()];
                for (int i = 0; i < intervals.size(); ++i) {
                    splits[i] = new JdbcInputSplit(partitionColumn, (String)intervals.get(i).getLeft(), (String)intervals.get(i).getRight(), tablePaths[0]);
                }
            } else {
                int numRecords = this.dbAccessor.getTotalNumberOfRecords((Configuration)job);
                if (numRecords < numPartitions) {
                    numPartitions = numRecords;
                }
                int numRecordsPerSplit = numRecords / numPartitions;
                int numSplitsWithExtraRecords = numRecords % numPartitions;
                LOGGER.debug("Num records = {}", (Object)numRecords);
                splits = new InputSplit[numPartitions];
                int offset = 0;
                for (int i = 0; i < numPartitions; ++i) {
                    int numRecordsInThisSplit = numRecordsPerSplit;
                    if (i < numSplitsWithExtraRecords) {
                        ++numRecordsInThisSplit;
                    }
                    splits[i] = new JdbcInputSplit(numRecordsInThisSplit, offset, tablePaths[0]);
                    offset += numRecordsInThisSplit;
                }
            }
            this.dbAccessor = null;
            LOGGER.info("Num input splits created {}", (Object)splits.length);
            for (InputSplit split : splits) {
                LOGGER.info("split:" + split.toString());
            }
            return splits;
        }
        catch (Exception e) {
            LOGGER.error("Error while splitting input data.", (Throwable)e);
            throw new IOException(e);
        }
    }

    public void setDbAccessor(DatabaseAccessor dbAccessor) {
        this.dbAccessor = dbAccessor;
    }
}

