/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.dao;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBOutputFormat;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfigManager;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.JdbcRecordIterator;
import org.apache.hive.storage.jdbc.exception.HiveJdbcDatabaseAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJdbcDatabaseAccessor
implements DatabaseAccessor {
    protected static final String DBCP_CONFIG_PREFIX = "hive.sql.dbcp";
    protected static final int DEFAULT_FETCH_SIZE = 1000;
    protected static final Logger LOGGER = LoggerFactory.getLogger(GenericJdbcDatabaseAccessor.class);
    protected DataSource dbcpDataSource = null;
    static final Pattern fromPattern = Pattern.compile("(.*?\\sfrom\\s)(.*+)", 34);

    @Override
    public List<String> getColumnNames(Configuration conf) throws HiveJdbcDatabaseAccessException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.initializeDatabaseConnection(conf);
            String tableName = GenericJdbcDatabaseAccessor.getQualifiedTableName(conf);
            String query = (String)MoreObjects.firstNonNull((Object)GenericJdbcDatabaseAccessor.selectAllFromTable(tableName), (Object)conf.get("hive.sql.query"));
            String metadataQuery = this.getMetaDataQuery(query);
            LOGGER.debug("Query to execute is [{}]", (Object)metadataQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(metadataQuery);
            rs = ps.executeQuery();
            ResultSetMetaData metadata = rs.getMetaData();
            int numColumns = metadata.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                columnNames.add(metadata.getColumnName(i + 1));
            }
            ArrayList<String> arrayList = columnNames;
            this.cleanupResources(conn, ps, rs);
            return arrayList;
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error while trying to get column names.", (Throwable)e);
                throw new HiveJdbcDatabaseAccessException("Error while trying to get column names: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanupResources(conn, ps, rs);
                throw throwable;
            }
        }
    }

    protected String getMetaDataQuery(String sql) {
        return this.addLimitToQuery(sql, 1);
    }

    @Override
    public int getTotalNumberOfRecords(Configuration conf) throws HiveJdbcDatabaseAccessException {
        String countQuery;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            this.initializeDatabaseConnection(conf);
            String tableName = GenericJdbcDatabaseAccessor.getQualifiedTableName(conf);
            String sql = (String)MoreObjects.firstNonNull((Object)conf.get("hive.sql.query"), (Object)GenericJdbcDatabaseAccessor.selectAllFromTable(tableName));
            countQuery = "SELECT COUNT(*) FROM (" + sql + ") tmptable";
            LOGGER.info("Query to execute is [{}]", (Object)countQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(countQuery);
            rs = ps.executeQuery();
            if (!rs.next()) break block6;
            int n = rs.getInt(1);
            this.cleanupResources(conn, ps, rs);
            return n;
        }
        try {
            try {
                LOGGER.warn("The count query did not return any results.", (Object)countQuery);
                throw new HiveJdbcDatabaseAccessException("Count query did not return any results.");
            }
            catch (HiveJdbcDatabaseAccessException he) {
                throw he;
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while trying to get the number of records", (Throwable)e);
                throw new HiveJdbcDatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            this.cleanupResources(conn, ps, rs);
            throw throwable;
        }
    }

    @Override
    public JdbcRecordIterator getRecordIterator(Configuration conf, String partitionColumn, String lowerBound, String upperBound, int limit, int offset) throws HiveJdbcDatabaseAccessException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.initializeDatabaseConnection(conf);
            String tableName = GenericJdbcDatabaseAccessor.getQualifiedTableName(conf);
            String sql = (String)MoreObjects.firstNonNull((Object)conf.get("hive.sql.query"), (Object)GenericJdbcDatabaseAccessor.selectAllFromTable(tableName));
            String partitionQuery = partitionColumn != null ? this.addBoundaryToQuery(tableName, sql, partitionColumn, lowerBound, upperBound) : this.addLimitAndOffsetToQuery(sql, limit, offset);
            LOGGER.info("Query to execute is [{}]", (Object)partitionQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(partitionQuery, 1003, 1007);
            ps.setFetchSize(this.getFetchSize(conf));
            rs = ps.executeQuery();
            return new JdbcRecordIterator(conn, ps, rs, conf);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while trying to execute query", (Throwable)e);
            this.cleanupResources(conn, ps, rs);
            throw new HiveJdbcDatabaseAccessException("Caught exception while trying to execute query:" + e.getMessage(), e);
        }
    }

    @Override
    public RecordWriter getRecordWriter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        String tableName = GenericJdbcDatabaseAccessor.getQualifiedTableName(conf);
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("Table name should be defined");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        String[] columnNames = conf.get("columns").split(",");
        try {
            this.initializeDatabaseConnection(conf);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(this.constructQuery(tableName, columnNames));
            DBOutputFormat dBOutputFormat = new DBOutputFormat();
            dBOutputFormat.getClass();
            return new DBOutputFormat.DBRecordWriter(dBOutputFormat, conn, ps);
        }
        catch (Exception e) {
            this.cleanupResources(conn, ps, null);
            throw new IOException(e.getMessage());
        }
    }

    protected String constructQuery(String table, String[] columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException("Column names may not be null");
        }
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ").append(table).append(" VALUES (");
        for (int i = 0; i < columnNames.length; ++i) {
            query.append("?");
            if (i == columnNames.length - 1) continue;
            query.append(",");
        }
        query.append(");");
        return query.toString();
    }

    protected String addLimitAndOffsetToQuery(String sql, int limit, int offset) {
        if (offset == 0) {
            return this.addLimitToQuery(sql, limit);
        }
        if (limit != -1) {
            return sql + " {LIMIT " + limit + " OFFSET " + offset + "}";
        }
        return sql + " {OFFSET " + offset + "}";
    }

    protected String addLimitToQuery(String sql, int limit) {
        if (limit == -1) {
            return sql;
        }
        return sql + " {LIMIT " + limit + "}";
    }

    protected String addBoundaryToQuery(String tableName, String sql, String partitionColumn, String lowerBound, String upperBound) {
        String result;
        String boundaryQuery = tableName != null ? "SELECT * FROM " + tableName + " WHERE " : "SELECT * FROM (" + sql + ") tmptable WHERE ";
        if (lowerBound != null) {
            boundaryQuery = boundaryQuery + this.quote() + partitionColumn + this.quote() + " >= " + lowerBound;
        }
        if (upperBound != null) {
            if (lowerBound != null) {
                boundaryQuery = boundaryQuery + " AND ";
            }
            boundaryQuery = boundaryQuery + this.quote() + partitionColumn + this.quote() + " < " + upperBound;
        }
        if (lowerBound == null && upperBound != null) {
            boundaryQuery = boundaryQuery + " OR " + this.quote() + partitionColumn + this.quote() + " IS NULL";
        }
        if (tableName != null) {
            Character[] possibleDelimits;
            String tableString = null;
            Matcher m = fromPattern.matcher(sql);
            Preconditions.checkArgument((boolean)m.matches());
            String queryBeforeFrom = m.group(1);
            String queryAfterFrom = " " + m.group(2) + " ";
            for (Character possibleDelimit : possibleDelimits = new Character[]{Character.valueOf('`'), Character.valueOf('\"'), Character.valueOf(' ')}) {
                if (!queryAfterFrom.contains(possibleDelimit + tableName + possibleDelimit)) continue;
                tableString = possibleDelimit + tableName + possibleDelimit;
                break;
            }
            if (tableString == null) {
                throw new RuntimeException("Cannot find " + tableName + " in sql query " + sql);
            }
            result = queryBeforeFrom + queryAfterFrom.replace(tableString, " (" + boundaryQuery + ") " + tableName + " ");
        } else {
            result = boundaryQuery;
        }
        return result;
    }

    protected void cleanupResources(Connection conn, PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Caught exception during resultset cleanup.", (Throwable)e);
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Caught exception during statement cleanup.", (Throwable)e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Caught exception during connection cleanup.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDatabaseConnection(Configuration conf) throws Exception {
        if (this.dbcpDataSource == null) {
            GenericJdbcDatabaseAccessor genericJdbcDatabaseAccessor = this;
            synchronized (genericJdbcDatabaseAccessor) {
                if (this.dbcpDataSource == null) {
                    Properties props = this.getConnectionPoolProperties(conf);
                    this.dbcpDataSource = BasicDataSourceFactory.createDataSource((Properties)props);
                }
            }
        }
    }

    private static String removeDbcpPrefix(String key) {
        if (key.startsWith("hive.sql.dbcp.")) {
            return key.substring(DBCP_CONFIG_PREFIX.length() + 1);
        }
        return key;
    }

    private String getFromProperties(Properties dbProperties, String key) {
        return dbProperties.getProperty(GenericJdbcDatabaseAccessor.removeDbcpPrefix(key));
    }

    protected Properties getConnectionPoolProperties(Configuration conf) throws Exception {
        String passwd;
        Properties dbProperties = this.getDefaultDBCPProperties();
        Map userProperties = conf.getValByRegex("hive.sql.dbcp\\.*");
        if (userProperties != null && !userProperties.isEmpty()) {
            for (Map.Entry entry : userProperties.entrySet()) {
                dbProperties.put(GenericJdbcDatabaseAccessor.removeDbcpPrefix((String)entry.getKey()), entry.getValue());
            }
        }
        if ((passwd = JdbcStorageConfigManager.getPasswordFromProperties(dbProperties, GenericJdbcDatabaseAccessor::removeDbcpPrefix)) != null) {
            dbProperties.put(GenericJdbcDatabaseAccessor.removeDbcpPrefix("hive.sql.dbcp.password"), passwd);
        }
        dbProperties.put("url", conf.get(JdbcStorageConfig.JDBC_URL.getPropertyName()));
        dbProperties.put("driverClassName", conf.get(JdbcStorageConfig.JDBC_DRIVER_CLASS.getPropertyName()));
        dbProperties.put("type", "javax.sql.DataSource");
        return dbProperties;
    }

    protected Properties getDefaultDBCPProperties() {
        Properties props = new Properties();
        props.put("initialSize", "1");
        props.put("maxActive", "3");
        props.put("maxIdle", "0");
        props.put("maxWait", "10000");
        props.put("timeBetweenEvictionRunsMillis", "30000");
        return props;
    }

    protected int getFetchSize(Configuration conf) {
        return conf.getInt(JdbcStorageConfig.JDBC_FETCH_SIZE.getPropertyName(), 1000);
    }

    @Override
    public Pair<String, String> getBounds(Configuration conf, String partitionColumn, boolean retrieveMin, boolean retrieveMax) throws HiveJdbcDatabaseAccessException {
        String countQuery;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block11: {
            conn = null;
            ps = null;
            rs = null;
            Preconditions.checkArgument((retrieveMin || retrieveMax ? 1 : 0) != 0);
            this.initializeDatabaseConnection(conf);
            String tableName = GenericJdbcDatabaseAccessor.getQualifiedTableName(conf);
            String sql = (String)MoreObjects.firstNonNull((Object)GenericJdbcDatabaseAccessor.selectAllFromTable(tableName), (Object)conf.get("hive.sql.query"));
            String minClause = "MIN(" + this.quote() + partitionColumn + this.quote() + ")";
            String maxClause = "MAX(" + this.quote() + partitionColumn + this.quote() + ")";
            countQuery = "SELECT ";
            if (retrieveMin) {
                countQuery = countQuery + minClause;
            }
            if (retrieveMax) {
                if (retrieveMin) {
                    countQuery = countQuery + ",";
                }
                countQuery = countQuery + maxClause;
            }
            countQuery = countQuery + " FROM (" + sql + ") tmptable WHERE " + this.quote() + partitionColumn + this.quote() + " IS NOT NULL";
            LOGGER.debug("MIN/MAX Query to execute is [{}]", (Object)countQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(countQuery);
            rs = ps.executeQuery();
            String lower = null;
            String upper = null;
            int pos = 1;
            if (!rs.next()) break block11;
            if (retrieveMin) {
                lower = rs.getString(pos);
                ++pos;
            }
            if (retrieveMax) {
                upper = rs.getString(pos);
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)lower, (Object)upper);
            this.cleanupResources(conn, ps, rs);
            return immutablePair;
        }
        try {
            try {
                LOGGER.warn("The count query did not return any results.", (Object)countQuery);
                throw new HiveJdbcDatabaseAccessException("MIN/MAX query did not return any results.");
            }
            catch (HiveJdbcDatabaseAccessException he) {
                throw he;
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while trying to get MIN/MAX of " + partitionColumn, (Throwable)e);
                throw new HiveJdbcDatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            this.cleanupResources(conn, ps, rs);
            throw throwable;
        }
    }

    private String quote() {
        if (this.needColumnQuote()) {
            return "\"";
        }
        return "";
    }

    @Override
    public boolean needColumnQuote() {
        return true;
    }

    private static String getQualifiedTableName(Configuration conf) {
        String tableName = conf.get("hive.sql.table");
        if (tableName == null) {
            return null;
        }
        String schemaName = conf.get("hive.sql.schema");
        return schemaName == null ? tableName : schemaName + "." + tableName;
    }

    private static String selectAllFromTable(String tableName) {
        return tableName == null ? null : "select * from " + tableName;
    }
}

