/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.conf;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.storage.jdbc.conf.CustomConfigManager;
import org.apache.hive.storage.jdbc.conf.CustomConfigManagerFactory;
import org.apache.hive.storage.jdbc.conf.DatabaseType;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcStorageConfigManager.class);
    public static final String CONFIG_USERNAME = "hive.sql.dbcp.username";
    public static final String CONFIG_PWD = "hive.sql.dbcp.password";
    public static final String CONFIG_PWD_KEYSTORE = "hive.sql.dbcp.password.keystore";
    public static final String CONFIG_PWD_KEY = "hive.sql.dbcp.password.key";
    public static final String CONFIG_PWD_URI = "hive.sql.dbcp.password.uri";
    private static final EnumSet<JdbcStorageConfig> DEFAULT_REQUIRED_PROPERTIES = EnumSet.of(JdbcStorageConfig.DATABASE_TYPE, JdbcStorageConfig.JDBC_URL, JdbcStorageConfig.JDBC_DRIVER_CLASS);
    private static final EnumSet<JdbcStorageConfig> METASTORE_REQUIRED_PROPERTIES = EnumSet.of(JdbcStorageConfig.DATABASE_TYPE, JdbcStorageConfig.QUERY);

    private JdbcStorageConfigManager() {
    }

    public static void copyConfigurationToJob(Properties props, Map<String, String> jobProps) throws HiveException, IOException {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        JdbcStorageConfigManager.resolveMetadata(props);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (key.equals(CONFIG_PWD) || key.equals(CONFIG_PWD_KEYSTORE) || key.equals(CONFIG_PWD_KEY) || key.equals(CONFIG_PWD_URI)) continue;
            jobProps.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
    }

    private static int countNonNull(String ... values) {
        int count = 0;
        for (String str : values) {
            if (str == null) continue;
            ++count;
        }
        return count;
    }

    public static String getPasswordFromProperties(Properties properties, Function<String, String> keyTransform) throws HiveException, IOException {
        String uri;
        String keystore;
        String passwd = properties.getProperty(keyTransform.apply(CONFIG_PWD));
        if (JdbcStorageConfigManager.countNonNull(passwd, keystore = properties.getProperty(keyTransform.apply(CONFIG_PWD_KEYSTORE)), uri = properties.getProperty(keyTransform.apply(CONFIG_PWD_URI))) > 1) {
            LOGGER.warn("Only one of hive.sql.dbcp.password, hive.sql.dbcp.password.keystore, hive.sql.dbcp.password.uri can be set");
        }
        if (passwd == null && keystore != null) {
            String key = properties.getProperty(keyTransform.apply(CONFIG_PWD_KEY));
            passwd = Utilities.getPasswdFromKeystore((String)keystore, (String)key);
        }
        if (passwd == null && uri != null) {
            try {
                passwd = Utilities.getPasswdFromUri((String)uri);
            }
            catch (URISyntaxException e) {
                throw new HiveException("Invalid password uri specified", (Throwable)e);
            }
        }
        return passwd;
    }

    public static void copySecretsToJob(Properties props, Map<String, String> jobSecrets) throws HiveException, IOException {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        JdbcStorageConfigManager.resolveMetadata(props);
        String passwd = JdbcStorageConfigManager.getPasswordFromProperties(props, Function.identity());
        if (passwd != null) {
            jobSecrets.put(CONFIG_PWD, passwd);
        }
    }

    public static Configuration convertPropertiesToConfiguration(Properties props) throws HiveException, IOException {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        JdbcStorageConfigManager.resolveMetadata(props);
        Configuration conf = new Configuration();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            conf.set(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return conf;
    }

    private static void checkRequiredPropertiesAreDefined(Properties props) {
        DatabaseType dbType = null;
        try {
            String dbTypeName = props.getProperty(JdbcStorageConfig.DATABASE_TYPE.getPropertyName());
            dbType = DatabaseType.valueOf(dbTypeName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown database type.", e);
        }
        for (JdbcStorageConfig configKey : DatabaseType.METASTORE.equals((Object)dbType) ? METASTORE_REQUIRED_PROPERTIES : DEFAULT_REQUIRED_PROPERTIES) {
            String propertyKey = configKey.getPropertyName();
            if (props != null && props.containsKey(propertyKey) && !JdbcStorageConfigManager.isEmptyString(props.getProperty(propertyKey))) continue;
            throw new IllegalArgumentException("Property " + propertyKey + " is required.");
        }
        CustomConfigManager configManager = CustomConfigManagerFactory.getCustomConfigManagerFor(dbType);
        configManager.checkRequiredProperties(props);
    }

    public static String getConfigValue(JdbcStorageConfig key, Configuration config) {
        return config.get(key.getPropertyName());
    }

    private static boolean isEmptyString(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static void resolveMetadata(Properties props) throws HiveException, IOException {
        DatabaseType dbType = DatabaseType.valueOf(props.getProperty(JdbcStorageConfig.DATABASE_TYPE.getPropertyName()));
        LOGGER.debug("Resolving db type: {}", (Object)dbType.toString());
        if (dbType == DatabaseType.METASTORE) {
            String pwd;
            HiveConf hconf = Hive.get().getConf();
            props.setProperty(JdbcStorageConfig.JDBC_URL.getPropertyName(), JdbcStorageConfigManager.getMetastoreConnectionURL(hconf));
            props.setProperty(JdbcStorageConfig.JDBC_DRIVER_CLASS.getPropertyName(), JdbcStorageConfigManager.getMetastoreDriver(hconf));
            String user = JdbcStorageConfigManager.getMetastoreJdbcUser(hconf);
            if (user != null) {
                props.setProperty(CONFIG_USERNAME, user);
            }
            if ((pwd = JdbcStorageConfigManager.getMetastoreJdbcPasswd(hconf)) != null) {
                props.setProperty(CONFIG_PWD, pwd);
            }
            props.setProperty(JdbcStorageConfig.DATABASE_TYPE.getPropertyName(), JdbcStorageConfigManager.getMetastoreDatabaseType(hconf));
        }
    }

    private static String getMetastoreDatabaseType(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTOREDBTYPE);
    }

    private static String getMetastoreConnectionURL(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTORECONNECTURLKEY);
    }

    private static String getMetastoreDriver(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER);
    }

    private static String getMetastoreJdbcUser(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME);
    }

    private static String getMetastoreJdbcPasswd(HiveConf conf) throws IOException {
        return ShimLoader.getHadoopShims().getPassword((Configuration)conf, HiveConf.ConfVars.METASTOREPWD.varname);
    }
}

