/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfigManager;
import org.apache.hive.storage.jdbc.dao.DatabaseAccessor;
import org.apache.hive.storage.jdbc.dao.JdbcRecordIterator;
import org.apache.hive.storage.jdbc.exception.HiveJdbcDatabaseAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericJdbcDatabaseAccessor
implements DatabaseAccessor {
    protected static final String DBCP_CONFIG_PREFIX = "hive.sql.dbcp";
    protected static final int DEFAULT_FETCH_SIZE = 1000;
    protected static final Logger LOGGER = LoggerFactory.getLogger(GenericJdbcDatabaseAccessor.class);
    protected DataSource dbcpDataSource = null;
    protected static final Text DBCP_PWD = new Text("hive.sql.dbcp.password");

    @Override
    public List<String> getColumnNames(Configuration conf) throws HiveJdbcDatabaseAccessException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.initializeDatabaseConnection(conf);
            String metadataQuery = this.getMetaDataQuery(conf);
            LOGGER.debug("Query to execute is [{}]", (Object)metadataQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(metadataQuery);
            rs = ps.executeQuery();
            ResultSetMetaData metadata = rs.getMetaData();
            int numColumns = metadata.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                columnNames.add(metadata.getColumnName(i + 1));
            }
            ArrayList<String> arrayList = columnNames;
            this.cleanupResources(conn, ps, rs);
            return arrayList;
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error while trying to get column names.", (Throwable)e);
                throw new HiveJdbcDatabaseAccessException("Error while trying to get column names: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.cleanupResources(conn, ps, rs);
                throw throwable;
            }
        }
    }

    protected String getMetaDataQuery(Configuration conf) {
        String sql = JdbcStorageConfigManager.getQueryToExecute(conf);
        String metadataQuery = this.addLimitToQuery(sql, 1);
        return metadataQuery;
    }

    @Override
    public int getTotalNumberOfRecords(Configuration conf) throws HiveJdbcDatabaseAccessException {
        String countQuery;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            this.initializeDatabaseConnection(conf);
            String sql = JdbcStorageConfigManager.getQueryToExecute(conf);
            countQuery = "SELECT COUNT(*) FROM (" + sql + ") tmptable";
            LOGGER.info("Query to execute is [{}]", (Object)countQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(countQuery);
            rs = ps.executeQuery();
            if (!rs.next()) break block6;
            int n = rs.getInt(1);
            this.cleanupResources(conn, ps, rs);
            return n;
        }
        try {
            try {
                LOGGER.warn("The count query did not return any results.", (Object)countQuery);
                throw new HiveJdbcDatabaseAccessException("Count query did not return any results.");
            }
            catch (HiveJdbcDatabaseAccessException he) {
                throw he;
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while trying to get the number of records", (Throwable)e);
                throw new HiveJdbcDatabaseAccessException(e);
            }
        }
        catch (Throwable throwable) {
            this.cleanupResources(conn, ps, rs);
            throw throwable;
        }
    }

    @Override
    public JdbcRecordIterator getRecordIterator(Configuration conf, int limit, int offset) throws HiveJdbcDatabaseAccessException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            this.initializeDatabaseConnection(conf);
            String sql = JdbcStorageConfigManager.getQueryToExecute(conf);
            String limitQuery = this.addLimitAndOffsetToQuery(sql, limit, offset);
            LOGGER.info("Query to execute is [{}]", (Object)limitQuery);
            conn = this.dbcpDataSource.getConnection();
            ps = conn.prepareStatement(limitQuery, 1003, 1007);
            ps.setFetchSize(this.getFetchSize(conf));
            rs = ps.executeQuery();
            return new JdbcRecordIterator(conn, ps, rs, conf.get("columns.types"));
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while trying to execute query", (Throwable)e);
            this.cleanupResources(conn, ps, rs);
            throw new HiveJdbcDatabaseAccessException("Caught exception while trying to execute query", e);
        }
    }

    protected String addLimitAndOffsetToQuery(String sql, int limit, int offset) {
        if (offset == 0) {
            return this.addLimitToQuery(sql, limit);
        }
        return sql + " {LIMIT " + limit + " OFFSET " + offset + "}";
    }

    protected String addLimitToQuery(String sql, int limit) {
        return sql + " {LIMIT " + limit + "}";
    }

    protected void cleanupResources(Connection conn, PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Caught exception during resultset cleanup.", (Throwable)e);
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Caught exception during statement cleanup.", (Throwable)e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Caught exception during connection cleanup.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDatabaseConnection(Configuration conf) throws Exception {
        if (this.dbcpDataSource == null) {
            GenericJdbcDatabaseAccessor genericJdbcDatabaseAccessor = this;
            synchronized (genericJdbcDatabaseAccessor) {
                if (this.dbcpDataSource == null) {
                    Properties props = this.getConnectionPoolProperties(conf);
                    this.dbcpDataSource = BasicDataSourceFactory.createDataSource((Properties)props);
                }
            }
        }
    }

    protected Properties getConnectionPoolProperties(Configuration conf) throws Exception {
        Credentials credentials;
        Properties dbProperties = this.getDefaultDBCPProperties();
        Map userProperties = conf.getValByRegex("hive.sql.dbcp\\.*");
        if (userProperties != null && !userProperties.isEmpty()) {
            for (Map.Entry entry : userProperties.entrySet()) {
                dbProperties.put(((String)entry.getKey()).replaceFirst("hive.sql.dbcp\\.", ""), entry.getValue());
            }
        }
        if ((credentials = UserGroupInformation.getCurrentUser().getCredentials()).getSecretKey(DBCP_PWD) != null) {
            LOGGER.info("found token in credentials");
            dbProperties.put(DBCP_PWD, new String(credentials.getSecretKey(DBCP_PWD)));
        }
        dbProperties.put("url", conf.get(JdbcStorageConfig.JDBC_URL.getPropertyName()));
        dbProperties.put("driverClassName", conf.get(JdbcStorageConfig.JDBC_DRIVER_CLASS.getPropertyName()));
        dbProperties.put("type", "javax.sql.DataSource");
        return dbProperties;
    }

    protected Properties getDefaultDBCPProperties() {
        Properties props = new Properties();
        props.put("initialSize", "1");
        props.put("maxActive", "3");
        props.put("maxIdle", "0");
        props.put("maxWait", "10000");
        props.put("timeBetweenEvictionRunsMillis", "30000");
        return props;
    }

    protected int getFetchSize(Configuration conf) {
        return conf.getInt(JdbcStorageConfig.JDBC_FETCH_SIZE.getPropertyName(), 1000);
    }
}

