/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.JarUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.storage.jdbc.JdbcInputFormat;
import org.apache.hive.storage.jdbc.JdbcInputSplit;
import org.apache.hive.storage.jdbc.JdbcOutputFormat;
import org.apache.hive.storage.jdbc.JdbcSerDe;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageHandler
implements HiveStorageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcStorageHandler.class);
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return JdbcInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return JdbcOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return JdbcSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            LOGGER.debug("Adding properties to input job conf");
            Properties properties = tableDesc.getProperties();
            JdbcStorageConfigManager.copyConfigurationToJob(properties, jobProperties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> jobSecrets) {
        try {
            LOGGER.debug("Adding secrets to input job conf");
            Properties properties = tableDesc.getProperties();
            JdbcStorageConfigManager.copySecretsToJob(properties, jobSecrets);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            LOGGER.debug("Adding properties to input job conf");
            Properties properties = tableDesc.getProperties();
            JdbcStorageConfigManager.copyConfigurationToJob(properties, jobProperties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        ArrayList classesToLoad = new ArrayList();
        classesToLoad.add(JdbcInputSplit.class);
        classesToLoad.add(BasicDataSourceFactory.class);
        classesToLoad.add(GenericObjectPool.class);
        try {
            classesToLoad.add(Class.forName("com.mysql.jdbc.Driver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            classesToLoad.add(Class.forName("org.postgresql.Driver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            classesToLoad.add(Class.forName("oracle.jdbc.OracleDriver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            classesToLoad.add(Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JarUtils.addDependencyJars((Configuration)this.conf, classesToLoad);
        }
        catch (IOException e) {
            LOGGER.error("Could not add necessary JDBC storage handler dependencies to classpath", (Throwable)e);
        }
    }

    public String toString() {
        return "org.apache.hive.storage.jdbc.JdbcStorageHandler";
    }
}

