/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.dao;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRecordIterator
implements Iterator<Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcRecordIterator.class);
    private Connection conn;
    private PreparedStatement ps;
    private ResultSet rs;
    private ArrayList<TypeInfo> columnTypes = null;

    public JdbcRecordIterator(Connection conn, PreparedStatement ps, ResultSet rs, String typeString) {
        this.conn = conn;
        this.ps = ps;
        this.rs = rs;
        if (typeString != null) {
            this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)typeString);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.rs.next();
        }
        catch (Exception se) {
            LOGGER.warn("hasNext() threw exception", (Throwable)se);
            return false;
        }
    }

    @Override
    public Map<String, Object> next() {
        try {
            ResultSetMetaData metadata = this.rs.getMetaData();
            int numColumns = metadata.getColumnCount();
            HashMap<String, Object> record = new HashMap<String, Object>(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                Object value;
                String key = metadata.getColumnName(i + 1);
                if (this.columnTypes != null && this.columnTypes.get(i) instanceof PrimitiveTypeInfo) {
                    switch (((PrimitiveTypeInfo)this.columnTypes.get(i)).getTypeName()) {
                        case "int": 
                        case "smallint": 
                        case "tinyint": {
                            value = this.rs.getInt(i + 1);
                            break;
                        }
                        case "bigint": {
                            value = this.rs.getLong(i + 1);
                            break;
                        }
                        case "float": {
                            value = Float.valueOf(this.rs.getFloat(i + 1));
                            break;
                        }
                        case "double": {
                            value = this.rs.getDouble(i + 1);
                            break;
                        }
                        case "bigdecimal": {
                            value = HiveDecimal.create((BigDecimal)this.rs.getBigDecimal(i + 1));
                            break;
                        }
                        case "boolean": {
                            value = this.rs.getBoolean(i + 1);
                            break;
                        }
                        case "string": 
                        case "char": 
                        case "varchar": {
                            value = this.rs.getString(i + 1);
                            break;
                        }
                        case "datetime": {
                            value = this.rs.getDate(i + 1);
                            break;
                        }
                        case "timestamp": {
                            value = this.rs.getTimestamp(i + 1);
                            break;
                        }
                        default: {
                            value = this.rs.getObject(i + 1);
                            break;
                        }
                    }
                } else {
                    value = this.rs.getObject(i + 1);
                }
                record.put(key, value);
            }
            return record;
        }
        catch (Exception e) {
            LOGGER.warn("next() threw exception", (Throwable)e);
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public void close() {
        try {
            this.rs.close();
            this.ps.close();
            this.conn.close();
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while trying to close database objects", (Throwable)e);
        }
    }
}

