/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class JdbcInputSplit
extends FileSplit
implements InputSplit {
    private static final String[] EMPTY_ARRAY = new String[0];
    private int limit = 0;
    private int offset = 0;

    public JdbcInputSplit() {
        super((Path)null, 0L, 0L, EMPTY_ARRAY);
    }

    public JdbcInputSplit(long start, long end, Path dummyPath) {
        super(dummyPath, 0L, 0L, EMPTY_ARRAY);
        this.setLimit((int)start);
        this.setOffset((int)end);
    }

    public JdbcInputSplit(int limit, int offset) {
        super((Path)null, 0L, 0L, EMPTY_ARRAY);
        this.limit = limit;
        this.offset = offset;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.limit);
        out.writeInt(this.offset);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.limit = in.readInt();
        this.offset = in.readInt();
    }

    public long getLength() {
        return this.limit;
    }

    public String[] getLocations() throws IOException {
        return EMPTY_ARRAY;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

