/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.udaf.example;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;

public final class UDAFExampleMaxMinNUtil {
    static <T extends Comparable<T>> Comparator<T> getComparator(boolean ascending, T dummy) {
        Comparator comp = ascending ? new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        } : new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o2.compareTo(o1);
            }
        };
        return comp;
    }

    static <T extends Comparable<T>> void binaryInsert(List<T> list, T value, boolean ascending) {
        int position = Collections.binarySearch(list, value, UDAFExampleMaxMinNUtil.getComparator(ascending, null));
        if (position < 0) {
            position = -position - 1;
        }
        list.add(position, value);
    }

    static <T extends Comparable<T>> ArrayList<T> sortedMerge(List<T> a1, List<T> a2, boolean ascending, int n) {
        Comparator<Comparable> comparator = UDAFExampleMaxMinNUtil.getComparator(ascending, null);
        int n1 = a1.size();
        int n2 = a2.size();
        int p1 = 0;
        int p2 = 0;
        ArrayList<T> output = new ArrayList<T>(n);
        while (output.size() < n && (p1 < n1 || p2 < n2)) {
            if (p1 < n1 && (p2 == n2 || comparator.compare((Comparable)a1.get(p1), (Comparable)a2.get(p2)) < 0)) {
                output.add(a1.get(p1++));
            }
            if (output.size() == n) break;
            if (p2 >= n2 || p1 != n1 && comparator.compare((Comparable)a2.get(p2), (Comparable)a1.get(p1)) > 0) continue;
            output.add(a2.get(p2++));
        }
        return output;
    }

    private UDAFExampleMaxMinNUtil() {
    }

    public static abstract class Evaluator
    implements UDAFEvaluator {
        private State state = new State();

        public Evaluator() {
            this.init();
        }

        public void init() {
            this.state.a = new ArrayList();
            this.state.n = 0;
        }

        protected abstract boolean getAscending();

        public boolean iterate(Double o, int n) {
            boolean ascending = this.getAscending();
            this.state.n = n;
            if (o != null) {
                boolean doInsert;
                boolean bl = doInsert = this.state.a.size() < n;
                if (!doInsert) {
                    Double last = this.state.a.get(this.state.a.size() - 1);
                    if (ascending) {
                        doInsert = o < last;
                    } else {
                        boolean bl2 = doInsert = o > last;
                    }
                }
                if (doInsert) {
                    UDAFExampleMaxMinNUtil.binaryInsert(this.state.a, o, ascending);
                    if (this.state.a.size() > n) {
                        this.state.a.remove(this.state.a.size() - 1);
                    }
                }
            }
            return true;
        }

        public State terminatePartial() {
            return this.state.a.size() == 0 ? null : this.state;
        }

        public boolean merge(State o) {
            if (o != null) {
                this.state.n = o.n;
                this.state.a = UDAFExampleMaxMinNUtil.sortedMerge(o.a, this.state.a, this.getAscending(), o.n);
            }
            return true;
        }

        public ArrayList<Double> terminate() {
            return this.state.a.size() == 0 ? null : this.state.a;
        }
    }

    public static class State {
        ArrayList<Double> a;
        int n;
    }
}

