/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.inject.Inject;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.util.Log4jWarningErrorMetricsAppender;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class ErrorsAndWarningsBlock
extends HtmlBlock {
    long cutoffPeriodSeconds = Time.now() / 1000L;
    private final AdminACLsManager adminAclsManager;

    @Inject
    ErrorsAndWarningsBlock(View.ViewContext ctx, Configuration conf) {
        super(ctx);
        String value = ctx.requestContext().get("cutoff", "");
        try {
            this.cutoffPeriodSeconds = Integer.parseInt(value);
            if (this.cutoffPeriodSeconds <= 0L) {
                this.cutoffPeriodSeconds = Time.now() / 1000L;
            }
        }
        catch (NumberFormatException ne) {
            this.cutoffPeriodSeconds = Time.now() / 1000L;
        }
        this.adminAclsManager = new AdminACLsManager(conf);
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        Log log = LogFactory.getLog(ErrorsAndWarningsBlock.class);
        boolean isAdmin = false;
        UserGroupInformation callerUGI = this.getCallerUGI();
        if (this.adminAclsManager.areACLsEnabled()) {
            if (callerUGI != null && this.adminAclsManager.isAdmin(callerUGI)) {
                isAdmin = true;
            }
        } else {
            isAdmin = true;
        }
        if (!isAdmin) {
            ((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.P)((Hamlet.DIV)html.div()).p())._(new Object[]{"This page is for admins only."})))._())._();
            return;
        }
        if (log instanceof Log4JLogger) {
            html._(ErrorMetrics.class);
            html._(WarningMetrics.class);
            ((Hamlet.DIV)((Hamlet.SELECT)((HamletImpl.EImp)((Object)((Hamlet.OPTION)((Hamlet.OPTION)((Hamlet.SELECT)((HamletImpl.EImp)((Object)((Hamlet.OPTION)((Hamlet.OPTION)((Hamlet.SELECT)((HamletImpl.EImp)((Object)((Hamlet.OPTION)((Hamlet.OPTION)((Hamlet.SELECT)((HamletImpl.EImp)((Object)((Hamlet.OPTION)((Hamlet.OPTION)((Hamlet.SELECT)((HamletImpl.EImp)((Object)((Hamlet.OPTION)((Hamlet.OPTION)((Hamlet.SELECT)((HamletImpl.EImp)((Object)((Hamlet.OPTION)((Hamlet.OPTION)((Hamlet.SELECT)((HamletImpl.EImp)((Object)((Hamlet.OPTION)((Hamlet.OPTION)((Hamlet.SELECT)((Hamlet.SELECT)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.BUTTON)((Hamlet.BUTTON)((Hamlet.DIV)html.div()).button()).$onclick("reloadPage()")).b("View data for the last ")))._()).select()).$id("cutoff")).option()).$value("60"))._(new Object[]{"1 min"})))._()).option()).$value("300"))._(new Object[]{"5 min"})))._()).option()).$value("900"))._(new Object[]{"15 min"})))._()).option()).$value("3600"))._(new Object[]{"1 hour"})))._()).option()).$value("21600"))._(new Object[]{"6 hours"})))._()).option()).$value("43200"))._(new Object[]{"12 hours"})))._()).option()).$value("86400"))._(new Object[]{"24 hours"})))._())._())._();
            String script = "function reloadPage() { var timePeriod = $(\"#cutoff\").val(); document.location.href = '/cluster/errors-and-warnings?cutoff=' + timePeriod}";
            script = script + "; function toggleContent(element) {" + "  $(element).parent().siblings('.toggle-content').fadeToggle();" + "}";
            ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{script})))._();
            html.style(".toggle-content { display: none; }");
            Log4jWarningErrorMetricsAppender appender = Log4jWarningErrorMetricsAppender.findAppender();
            if (appender == null) {
                return;
            }
            ArrayList<Long> cutoff = new ArrayList<Long>();
            HamletSpec.TBODY errorsTable = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)html.table("#messages")).thead()).tr()).th(".message", "Message")).th(".type", "Type")).th(".count", "Count")).th(".lasttime", "Latest Message Time")))._())._()).tbody();
            cutoff.add((Time.now() - this.cutoffPeriodSeconds * 1000L) / 1000L);
            List<Map<String, Log4jWarningErrorMetricsAppender.Element>> errorsData = appender.getErrorMessagesAndCounts(cutoff);
            List<Map<String, Log4jWarningErrorMetricsAppender.Element>> warningsData = appender.getWarningMessagesAndCounts(cutoff);
            HashMap<String, List<Map<String, Log4jWarningErrorMetricsAppender.Element>>> sources = new HashMap<String, List<Map<String, Log4jWarningErrorMetricsAppender.Element>>>();
            sources.put("Error", errorsData);
            sources.put("Warning", warningsData);
            int maxDisplayLength = 80;
            for (Map.Entry source : sources.entrySet()) {
                String type = (String)source.getKey();
                List data = (List)source.getValue();
                if (data.size() <= 0) continue;
                Map map = (Map)data.get(0);
                for (Map.Entry entry : map.entrySet()) {
                    String message = (String)entry.getKey();
                    HamletSpec.TR row = ((Hamlet.TBODY)errorsTable).tr();
                    HamletSpec.TD cell = ((Hamlet.TR)row).td();
                    if (message.length() > maxDisplayLength || message.contains("\n")) {
                        String displayMessage = ((String)entry.getKey()).split("\n")[0];
                        if (displayMessage.length() > maxDisplayLength) {
                            displayMessage = displayMessage.substring(0, maxDisplayLength);
                        }
                        ((Hamlet.TD)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.PRE)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.TD)((Hamlet.PRE)((HamletImpl.EImp)((Object)((Hamlet.A)((Hamlet.A)((Hamlet.A)((Hamlet.A)((Hamlet.PRE)((Hamlet.TD)cell).pre()).a()).$href("#")).$onclick("toggleContent(this);")).$style("white-space: pre"))._(new Object[]{displayMessage})))._())._()).div()).$class("toggle-content")).pre())._(new Object[]{message})))._())._())._();
                    } else {
                        ((Hamlet.TD)((HamletImpl.EImp)((Object)((Hamlet.PRE)((Hamlet.TD)cell).pre())._(new Object[]{message})))._())._();
                    }
                    Log4jWarningErrorMetricsAppender.Element ele = (Log4jWarningErrorMetricsAppender.Element)entry.getValue();
                    ((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)row).td(type)).td(String.valueOf(ele.count))).td(Times.format(ele.timestampSeconds * 1000L))))._();
                }
            }
            ((Hamlet.TABLE)((HamletImpl.EImp)((Object)errorsTable))._())._();
        }
    }

    public static class WarningMetrics
    extends MetricsBase {
        @Inject
        WarningMetrics(View.ViewContext ctx) {
            super(ctx);
            this.tableHeading = "Warning Metrics";
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            if (this.appender == null) {
                return;
            }
            this.values = this.appender.getWarningCounts(this.getCutoffs());
            super.render(html);
        }
    }

    public static class ErrorMetrics
    extends MetricsBase {
        @Inject
        ErrorMetrics(View.ViewContext ctx) {
            super(ctx);
            this.tableHeading = "Error Metrics";
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            if (this.appender == null) {
                return;
            }
            this.values = this.appender.getErrorCounts(this.getCutoffs());
            super.render(html);
        }
    }

    public static class MetricsBase
    extends HtmlBlock {
        List<Long> cutoffs = new ArrayList<Long>();
        List<Integer> values;
        String tableHeading;
        Log4jWarningErrorMetricsAppender appender;

        MetricsBase(View.ViewContext ctx) {
            super(ctx);
            long now = Time.now();
            this.cutoffs.add((now - 60000L) / 1000L);
            this.cutoffs.add((now - 300000L) / 1000L);
            this.cutoffs.add((now - 900000L) / 1000L);
            this.cutoffs.add((now - 3600000L) / 1000L);
            this.cutoffs.add((now - 21600000L) / 1000L);
            this.cutoffs.add((now - 43200000L) / 1000L);
            this.cutoffs.add((now - 84600000L) / 1000L);
            Log log = LogFactory.getLog(ErrorsAndWarningsBlock.class);
            if (log instanceof Log4JLogger) {
                this.appender = Log4jWarningErrorMetricsAppender.findAppender();
            }
        }

        List<Long> getCutoffs() {
            return this.cutoffs;
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            Log log = LogFactory.getLog(ErrorsAndWarningsBlock.class);
            if (log instanceof Log4JLogger) {
                HamletSpec.CoreAttrs div = ((Hamlet.DIV)((Hamlet.DIV)html.div()).$class("metrics")).$style("padding-bottom: 20px");
                ((Hamlet.TABLE)((Hamlet.TBODY)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TBODY)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TH)((Hamlet.TH)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.THEAD)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.DIV)div).h3(this.tableHeading)).table("#metricsoverview")).thead()).$class("ui-widget-header")).tr()).th()).$class("ui-state-default"))._(new Object[]{"Last 1 minute"})))._()).th()).$class("ui-state-default"))._(new Object[]{"Last 5 minutes"})))._()).th()).$class("ui-state-default"))._(new Object[]{"Last 15 minutes"})))._()).th()).$class("ui-state-default"))._(new Object[]{"Last 1 hour"})))._()).th()).$class("ui-state-default"))._(new Object[]{"Last 6 hours"})))._()).th()).$class("ui-state-default"))._(new Object[]{"Last 12 hours"})))._()).th()).$class("ui-state-default"))._(new Object[]{"Last 24 hours"})))._())._())._()).tbody()).$class("ui-widget-content")).tr()).td(String.valueOf(this.values.get(0)))).td(String.valueOf(this.values.get(1)))).td(String.valueOf(this.values.get(2)))).td(String.valueOf(this.values.get(3)))).td(String.valueOf(this.values.get(4)))).td(String.valueOf(this.values.get(5)))).td(String.valueOf(this.values.get(6)))))._())._())._();
                ((HamletImpl.EImp)((Object)div))._();
            }
        }
    }
}

