/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.records;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.util.Records;

public abstract class NodeStatus {
    public static NodeStatus newInstance(NodeId nodeId, int responseId, List<ContainerStatus> containerStatuses, List<ApplicationId> keepAliveApplications, NodeHealthStatus nodeHealthStatus, ResourceUtilization containersUtilization, ResourceUtilization nodeUtilization, List<Container> increasedContainers) {
        NodeStatus nodeStatus = Records.newRecord(NodeStatus.class);
        nodeStatus.setResponseId(responseId);
        nodeStatus.setNodeId(nodeId);
        nodeStatus.setContainersStatuses(containerStatuses);
        nodeStatus.setKeepAliveApplications(keepAliveApplications);
        nodeStatus.setNodeHealthStatus(nodeHealthStatus);
        nodeStatus.setContainersUtilization(containersUtilization);
        nodeStatus.setNodeUtilization(nodeUtilization);
        nodeStatus.setIncreasedContainers(increasedContainers);
        return nodeStatus;
    }

    public abstract NodeId getNodeId();

    public abstract int getResponseId();

    public abstract List<ContainerStatus> getContainersStatuses();

    public abstract void setContainersStatuses(List<ContainerStatus> var1);

    public abstract List<ApplicationId> getKeepAliveApplications();

    public abstract void setKeepAliveApplications(List<ApplicationId> var1);

    public abstract NodeHealthStatus getNodeHealthStatus();

    public abstract void setNodeHealthStatus(NodeHealthStatus var1);

    public abstract void setNodeId(NodeId var1);

    public abstract void setResponseId(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ResourceUtilization getContainersUtilization();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setContainersUtilization(ResourceUtilization var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ResourceUtilization getNodeUtilization();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNodeUtilization(ResourceUtilization var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<Container> getIncreasedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setIncreasedContainers(List<Container> var1);
}

