/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.impl.pb.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.SCMUploaderProtocol;
import org.apache.hadoop.yarn.server.api.SCMUploaderProtocolPB;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderCanUploadRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderCanUploadResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderNotifyRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderNotifyResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.SCMUploaderCanUploadRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.SCMUploaderCanUploadResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.SCMUploaderNotifyRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.SCMUploaderNotifyResponsePBImpl;

public class SCMUploaderProtocolPBClientImpl
implements SCMUploaderProtocol,
Closeable {
    private SCMUploaderProtocolPB proxy;

    public SCMUploaderProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine(conf, SCMUploaderProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = RPC.getProxy(SCMUploaderProtocolPB.class, clientVersion, addr, conf);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy(this.proxy);
            this.proxy = null;
        }
    }

    @Override
    public SCMUploaderNotifyResponse notify(SCMUploaderNotifyRequest request) throws YarnException, IOException {
        YarnServerCommonServiceProtos.SCMUploaderNotifyRequestProto requestProto = ((SCMUploaderNotifyRequestPBImpl)request).getProto();
        try {
            return new SCMUploaderNotifyResponsePBImpl(this.proxy.notify(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    @Override
    public SCMUploaderCanUploadResponse canUpload(SCMUploaderCanUploadRequest request) throws YarnException, IOException {
        YarnServerCommonServiceProtos.SCMUploaderCanUploadRequestProto requestProto = ((SCMUploaderCanUploadRequestPBImpl)request).getProto();
        try {
            return new SCMUploaderCanUploadResponsePBImpl(this.proxy.canUpload(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }
}

