/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.async;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.NMClientImpl;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class NMClientAsync
extends AbstractService {
    protected NMClient client;
    protected CallbackHandler callbackHandler;

    public static NMClientAsync createNMClientAsync(AbstractCallbackHandler callbackHandler) {
        return new NMClientAsyncImpl(callbackHandler);
    }

    protected NMClientAsync(AbstractCallbackHandler callbackHandler) {
        this(NMClientAsync.class.getName(), callbackHandler);
    }

    protected NMClientAsync(String name, AbstractCallbackHandler callbackHandler) {
        this(name, (NMClient)new NMClientImpl(), callbackHandler);
    }

    protected NMClientAsync(String name, NMClient client, AbstractCallbackHandler callbackHandler) {
        super(name);
        this.setClient(client);
        this.setCallbackHandler(callbackHandler);
    }

    @Deprecated
    public static NMClientAsync createNMClientAsync(CallbackHandler callbackHandler) {
        return new NMClientAsyncImpl(callbackHandler);
    }

    @Deprecated
    protected NMClientAsync(CallbackHandler callbackHandler) {
        this(NMClientAsync.class.getName(), callbackHandler);
    }

    @Deprecated
    protected NMClientAsync(String name, CallbackHandler callbackHandler) {
        this(name, (NMClient)new NMClientImpl(), callbackHandler);
    }

    @InterfaceAudience.Private
    @Deprecated
    @VisibleForTesting
    protected NMClientAsync(String name, NMClient client, CallbackHandler callbackHandler) {
        super(name);
        this.setClient(client);
        this.setCallbackHandler(callbackHandler);
    }

    public abstract void startContainerAsync(Container var1, ContainerLaunchContext var2);

    public abstract void increaseContainerResourceAsync(Container var1);

    public abstract void stopContainerAsync(ContainerId var1, NodeId var2);

    public abstract void getContainerStatusAsync(ContainerId var1, NodeId var2);

    public NMClient getClient() {
        return this.client;
    }

    public void setClient(NMClient client) {
        this.client = client;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Deprecated
    public static interface CallbackHandler {
        public void onContainerStarted(ContainerId var1, Map<String, ByteBuffer> var2);

        public void onContainerStatusReceived(ContainerId var1, ContainerStatus var2);

        public void onContainerStopped(ContainerId var1);

        public void onStartContainerError(ContainerId var1, Throwable var2);

        public void onGetContainerStatusError(ContainerId var1, Throwable var2);

        public void onStopContainerError(ContainerId var1, Throwable var2);
    }

    public static abstract class AbstractCallbackHandler
    implements CallbackHandler {
        @Override
        public abstract void onContainerStarted(ContainerId var1, Map<String, ByteBuffer> var2);

        @Override
        public abstract void onContainerStatusReceived(ContainerId var1, ContainerStatus var2);

        @Override
        public abstract void onContainerStopped(ContainerId var1);

        @Override
        public abstract void onStartContainerError(ContainerId var1, Throwable var2);

        public abstract void onContainerResourceIncreased(ContainerId var1, Resource var2);

        @Override
        public abstract void onGetContainerStatusError(ContainerId var1, Throwable var2);

        public abstract void onIncreaseContainerResourceError(ContainerId var1, Throwable var2);

        @Override
        public abstract void onStopContainerError(ContainerId var1, Throwable var2);
    }
}

