/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.inject.Inject;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppView;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class TaskPage
extends AppView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.set(JQueryUI.initID("ui.accordion", "nav"), "{autoHeight:false, active:3}");
        this.set("ui.dataTables.id", "attempts");
        this.set(JQueryUI.initID("ui.dataTables", "attempts"), this.attemptsTableInit());
        this.setTableStyles(html, "attempts", new String[0]);
    }

    @Override
    protected Class<? extends SubView> content() {
        return AttemptsBlock.class;
    }

    private String attemptsTableInit() {
        return JQueryUI.tableInit().append(", 'aaData': attemptsTableData").append(", bDeferRender: true").append(", bProcessing: true").append("\n,aoColumnDefs:[\n").append("\n{'aTargets': [ 5 ]").append(", 'bSearchable': false }").append("\n, {'sType':'natural', 'aTargets': [ 0 ]").append(", 'mRender': parseHadoopID }").append("\n, {'sType':'numeric', 'aTargets': [ 6, 7").append(" ], 'mRender': renderHadoopDate }").append("\n, {'sType':'numeric', 'aTargets': [ 8").append(" ], 'mRender': renderHadoopElapsedTime }]").append("\n, aaSorting: [[0, 'asc']]").append("}").toString();
    }

    static class AttemptsBlock
    extends HtmlBlock {
        final App app;
        final boolean enableUIActions;

        @Inject
        AttemptsBlock(App ctx, Configuration conf) {
            this.app = ctx;
            this.enableUIActions = conf.getBoolean("mapreduce.webapp.ui-actions.enabled", true);
        }

        @Override
        protected void render(HtmlBlock.Block html) {
            if (!this.isValidRequest()) {
                html.h2(this.$("title"));
                return;
            }
            JobId jobId = this.app.getJob().getID();
            if (this.enableUIActions) {
                StringBuilder script = new StringBuilder();
                script.append("function confirmAction(appID, jobID, taskID, attID) {\n").append("  var b = confirm(\"Are you sure?\");\n").append("  if (b == true) {\n").append("    var current = '/proxy/' + appID").append("      + '/mapreduce/task/' + taskID;\n").append("    var stateURL = '/proxy/' + appID").append("      + '/ws/v1/mapreduce/jobs/' + jobID").append("      + '/tasks/' + taskID").append("      + '/attempts/' + attID + '/state';\n").append("    $.ajax({\n").append("      type: 'PUT',\n").append("      url: stateURL,\n").append("      contentType: 'application/json',\n").append("      data: '{\"state\":\"KILLED\"}',\n").append("      dataType: 'json'\n").append("    }).done(function(data) {\n").append("         setTimeout(function() {\n").append("           location.href = current;\n").append("         }, 1000);\n").append("    }).fail(function(data) {\n").append("         console.log(data);\n").append("    });\n").append("  }\n").append("}\n");
                ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{script.toString()})))._();
            }
            HamletSpec.TR tr = ((Hamlet.THEAD)((Hamlet.TABLE)html.table("#attempts")).thead()).tr();
            ((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)tr).th(".id", "Attempt")).th(".progress", "Progress")).th(".state", "State")).th(".status", "Status")).th(".node", "Node")).th(".logs", "Logs")).th(".tsh", "Started")).th(".tsh", "Finished")).th(".tsh", "Elapsed")).th(".note", "Note");
            if (this.enableUIActions) {
                ((Hamlet.TR)tr).th(".actions", "Actions");
            }
            HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)tr))._())._()).tbody();
            StringBuilder attemptsTableData = new StringBuilder("[\n");
            for (TaskAttempt attempt : this.getTaskAttempts()) {
                TaskAttemptInfo ta = new TaskAttemptInfo(attempt, true);
                String progress = StringUtils.format("%.2f", Float.valueOf(ta.getProgress()));
                String nodeHttpAddr = ta.getNode();
                String diag = ta.getNote() == null ? "" : ta.getNote();
                TaskId taskId = attempt.getID().getTaskId();
                attemptsTableData.append("[\"").append(this.getAttemptId(taskId, ta)).append("\",\"").append(progress).append("\",\"").append(ta.getState().toString()).append("\",\"").append(StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(ta.getStatus()))).append("\",\"").append(nodeHttpAddr == null ? "N/A" : "<a class='nodelink' href='" + MRWebAppUtil.getYARNWebappScheme() + nodeHttpAddr + "'>" + nodeHttpAddr + "</a>").append("\",\"").append(ta.getAssignedContainerId() == null ? "N/A" : "<a class='logslink' href='" + this.url(MRWebAppUtil.getYARNWebappScheme(), nodeHttpAddr, "node", "containerlogs", ta.getAssignedContainerIdStr(), this.app.getJob().getUserName()) + "'>logs</a>").append("\",\"").append(ta.getStartTime()).append("\",\"").append(ta.getFinishTime()).append("\",\"").append(ta.getElapsedTime()).append("\",\"").append(StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(diag)));
                if (!this.enableUIActions) continue;
                attemptsTableData.append("\",\"");
                if (EnumSet.of(TaskAttemptState.SUCCEEDED, TaskAttemptState.FAILED, TaskAttemptState.KILLED).contains((Object)attempt.getState())) {
                    attemptsTableData.append("N/A");
                } else {
                    attemptsTableData.append("<a href=javascript:void(0) onclick=confirmAction('").append(jobId.getAppId()).append("','").append(jobId).append("','").append(attempt.getID().getTaskId()).append("','").append(ta.getId()).append("');>Kill</a>");
                }
                attemptsTableData.append("\"],\n");
            }
            if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
                attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
            }
            attemptsTableData.append("]");
            ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{"var attemptsTableData=" + attemptsTableData})))._();
            ((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._();
        }

        protected String getAttemptId(TaskId taskId, TaskAttemptInfo ta) {
            return ta.getId();
        }

        protected boolean isValidRequest() {
            return this.app.getTask() != null;
        }

        protected Collection<TaskAttempt> getTaskAttempts() {
            return this.app.getTask().getAttempts().values();
        }
    }
}

