/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authorize.ProxyServers;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class JspHelper {
    public static final String CURRENT_CONF = "current.conf";
    public static final String NAMENODE_ADDRESS = "nnaddr";
    private static final Log LOG = LogFactory.getLog(JspHelper.class);

    private JspHelper() {
    }

    public static DatanodeInfo bestNode(LocatedBlocks blks, Configuration conf) throws IOException {
        HashMap<DatanodeInfo, NodeRecord> map = new HashMap<DatanodeInfo, NodeRecord>();
        for (LocatedBlock block : blks.getLocatedBlocks()) {
            DatanodeInfo[] nodes;
            for (DatanodeInfo node : nodes = block.getLocations()) {
                NodeRecord record = (NodeRecord)map.get(node);
                if (record == null) {
                    map.put(node, new NodeRecord(node, 1));
                    continue;
                }
                ++record.frequency;
            }
        }
        DatanodeInfo[] nodes = map.values().toArray(new NodeRecord[map.size()]);
        Arrays.sort(nodes, new NodeRecordComparator());
        return JspHelper.bestNode(nodes, false);
    }

    private static DatanodeInfo bestNode(DatanodeInfo[] nodes, boolean doRandom) throws IOException {
        int l;
        if (nodes == null || nodes.length == 0) {
            throw new IOException("No nodes contain this block");
        }
        for (l = 0; l < nodes.length && !nodes[l].isDecommissioned(); ++l) {
        }
        if (l == 0) {
            throw new IOException("No active nodes contain this block");
        }
        int index = doRandom ? ThreadLocalRandom.current().nextInt(l) : 0;
        return nodes[index];
    }

    public static String validatePath(String p) {
        return p == null || p.length() == 0 ? null : new Path(p).toUri().getPath();
    }

    public static Long validateLong(String value) {
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public static String getDefaultWebUserName(Configuration conf) throws IOException {
        String user = conf.get("hadoop.http.staticuser.user", "dr.who");
        if (user == null || user.length() == 0) {
            throw new IOException("Cannot determine UGI from request or conf");
        }
        return user;
    }

    private static InetSocketAddress getNNServiceAddress(ServletContext context, HttpServletRequest request) {
        String namenodeAddressInUrl = request.getParameter(NAMENODE_ADDRESS);
        InetSocketAddress namenodeAddress = null;
        if (namenodeAddressInUrl != null) {
            namenodeAddress = NetUtils.createSocketAddr(namenodeAddressInUrl);
        } else if (context != null) {
            namenodeAddress = NameNodeHttpServer.getNameNodeAddressFromContext(context);
        }
        if (namenodeAddress != null) {
            return namenodeAddress;
        }
        return null;
    }

    public static UserGroupInformation getUGI(HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(null, request, conf);
    }

    public static UserGroupInformation getUGI(ServletContext context, HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(context, request, conf, UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, true);
    }

    public static UserGroupInformation getUGI(ServletContext context, HttpServletRequest request, Configuration conf, UserGroupInformation.AuthenticationMethod secureAuthMethod, boolean tryUgiParameter) throws IOException {
        String remoteUser;
        UserGroupInformation ugi = null;
        String usernameFromQuery = JspHelper.getUsernameFromQuery(request, tryUgiParameter);
        String doAsUserFromQuery = request.getParameter("doas");
        if (UserGroupInformation.isSecurityEnabled()) {
            remoteUser = request.getRemoteUser();
            String tokenString = request.getParameter("delegation");
            if (tokenString != null) {
                ugi = JspHelper.getTokenUGI(context, request, tokenString, conf);
                JspHelper.checkUsername(ugi.getShortUserName(), usernameFromQuery);
                JspHelper.checkUsername(ugi.getShortUserName(), doAsUserFromQuery);
            } else if (remoteUser == null) {
                throw new IOException("Security enabled but user not authenticated by filter");
            }
        } else {
            String string = remoteUser = usernameFromQuery == null ? JspHelper.getDefaultWebUserName(conf) : usernameFromQuery;
        }
        if (ugi == null) {
            ugi = UserGroupInformation.createRemoteUser(remoteUser);
            JspHelper.checkUsername(ugi.getShortUserName(), usernameFromQuery);
            if (UserGroupInformation.isSecurityEnabled()) {
                ugi.setAuthenticationMethod(secureAuthMethod);
            }
            if (doAsUserFromQuery != null) {
                ugi = UserGroupInformation.createProxyUser(doAsUserFromQuery, ugi);
                ProxyUsers.authorize(ugi, JspHelper.getRemoteAddr(request));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getUGI is returning: " + ugi.getShortUserName()));
        }
        return ugi;
    }

    private static UserGroupInformation getTokenUGI(ServletContext context, HttpServletRequest request, String tokenString, Configuration conf) throws IOException {
        NameNode nn;
        Token token = new Token();
        token.decodeFromUrlString(tokenString);
        InetSocketAddress serviceAddress = JspHelper.getNNServiceAddress(context, request);
        if (serviceAddress != null) {
            SecurityUtil.setTokenService(token, serviceAddress);
            token.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        id.readFields(in);
        if (context != null && (nn = NameNodeHttpServer.getNameNodeFromContext(context)) != null) {
            nn.getNamesystem().verifyToken(id, token.getPassword());
        }
        UserGroupInformation ugi = id.getUser();
        ugi.addToken(token);
        return ugi;
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String clientAddr;
        String remoteAddr = request.getRemoteAddr();
        String proxyHeader = request.getHeader("X-Forwarded-For");
        if (proxyHeader != null && ProxyServers.isProxyServer(remoteAddr) && !(clientAddr = proxyHeader.split(",")[0].trim()).isEmpty()) {
            remoteAddr = clientAddr;
        }
        return remoteAddr;
    }

    public static void checkUsername(String expected, String name) throws IOException {
        if (expected == null && name != null) {
            throw new IOException("Usernames not matched: expecting null but name=" + name);
        }
        if (name == null) {
            return;
        }
        KerberosName u = new KerberosName(name);
        String shortName = u.getShortName();
        if (!shortName.equals(expected)) {
            throw new IOException("Usernames not matched: name=" + shortName + " != expected=" + expected);
        }
    }

    private static String getUsernameFromQuery(HttpServletRequest request, boolean tryUgiParameter) {
        String ugiStr;
        String username = request.getParameter("user.name");
        if (username == null && tryUgiParameter && (ugiStr = request.getParameter("ugi")) != null) {
            username = ugiStr.split(",")[0];
        }
        return username;
    }

    public static String getUrlParam(String name, String val, String paramSeparator) {
        return val == null ? "" : paramSeparator + name + "=" + val;
    }

    public static String getUrlParam(String name, String val, boolean firstParam) {
        return JspHelper.getUrlParam(name, val, firstParam ? "?" : "&");
    }

    public static String getUrlParam(String name, String val) {
        return JspHelper.getUrlParam(name, val, false);
    }

    private static class NodeRecordComparator
    implements Comparator<NodeRecord> {
        private NodeRecordComparator() {
        }

        @Override
        public int compare(NodeRecord o1, NodeRecord o2) {
            if (o1.frequency < o2.frequency) {
                return -1;
            }
            if (o1.frequency > o2.frequency) {
                return 1;
            }
            return 0;
        }
    }

    private static class NodeRecord
    extends DatanodeInfo {
        int frequency;

        public NodeRecord(DatanodeInfo info, int count) {
            super(info);
            this.frequency = count;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

