/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Optional;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionRequest;

@InterfaceAudience.Private
class ClusterCompactionQueues {
    private final Map<ServerName, List<MajorCompactionRequest>> compactionQueues;
    private final Set<ServerName> compactingServers;
    private final ReadWriteLock lock;
    private final int concurrentServers;

    ClusterCompactionQueues(int concurrentServers) {
        this.concurrentServers = concurrentServers;
        this.compactionQueues = Maps.newHashMap();
        this.lock = new ReentrantReadWriteLock();
        this.compactingServers = Sets.newHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCompactionQueue(ServerName serverName, MajorCompactionRequest info) {
        this.lock.writeLock().lock();
        try {
            List<MajorCompactionRequest> result = this.compactionQueues.get(serverName);
            if (result == null) {
                result = Lists.newArrayList();
                this.compactionQueues.put(serverName, result);
            }
            result.add(info);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasWorkItems() {
        this.lock.readLock().lock();
        try {
            for (List<MajorCompactionRequest> majorCompactionRequests : this.compactionQueues.values()) {
                if (majorCompactionRequests.isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCompactionRequestsLeftToFinish() {
        this.lock.readLock().lock();
        try {
            int size = 0;
            for (List<MajorCompactionRequest> queue : this.compactionQueues.values()) {
                size += queue.size();
            }
            int n = size;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MajorCompactionRequest> getQueue(ServerName serverName) {
        this.lock.readLock().lock();
        try {
            List<MajorCompactionRequest> list = this.compactionQueues.get(serverName);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MajorCompactionRequest reserveForCompaction(ServerName serverName) {
        this.lock.writeLock().lock();
        try {
            if (!this.compactionQueues.get(serverName).isEmpty()) {
                this.compactingServers.add(serverName);
                MajorCompactionRequest majorCompactionRequest = this.compactionQueues.get(serverName).remove(0);
                return majorCompactionRequest;
            }
            MajorCompactionRequest majorCompactionRequest = null;
            return majorCompactionRequest;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCompaction(ServerName serverName) {
        this.lock.writeLock().lock();
        try {
            this.compactingServers.remove(serverName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean atCapacity() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.compactingServers.size() >= this.concurrentServers;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<ServerName> getLargestQueueFromServersNotCompacting() {
        this.lock.readLock().lock();
        try {
            Sets.SetView<ServerName> difference = Sets.difference(this.compactionQueues.keySet(), this.compactingServers);
            ServerName serverName = null;
            int maxItems = 0;
            for (ServerName server : difference) {
                if (this.compactionQueues.get(server).size() <= maxItems) continue;
                maxItems = this.compactionQueues.get(server).size();
                serverName = server;
            }
            Optional<Object> optional = Optional.fromNullable(serverName);
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

