/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MetaUtils;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class Merge
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(Merge.class);
    private Path rootdir;
    private volatile MetaUtils utils;
    private TableName tableName;
    private volatile byte[] region1;
    private volatile byte[] region2;
    private volatile HRegionInfo mergeInfo;

    public Merge() {
    }

    public Merge(Configuration conf) {
        this.mergeInfo = null;
        this.setConf(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws Exception {
        if (this.parseArgs(args) != 0) {
            return -1;
        }
        FileSystem fs = FileSystem.get(this.getConf());
        LOG.info((Object)"Verifying that file system is available...");
        try {
            FSUtils.checkFileSystemAvailable(fs);
        }
        catch (IOException e) {
            LOG.fatal((Object)"File system is not available", (Throwable)e);
            return -1;
        }
        LOG.info((Object)"Verifying that HBase is not running...");
        try {
            HBaseAdmin.checkHBaseAvailable(this.getConf());
            LOG.fatal((Object)"HBase cluster must be off-line, and is not. Aborting.");
            return -1;
        }
        catch (ZooKeeperConnectionException e) {
        }
        catch (MasterNotRunningException e) {
            // empty catch block
        }
        this.utils = new MetaUtils(this.getConf());
        this.rootdir = FSUtils.getRootDir(this.getConf());
        try {
            this.mergeTwoRegions();
            int e = 0;
            return e;
        }
        catch (IOException e) {
            LOG.fatal((Object)"Merge failed", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            if (this.utils != null) {
                this.utils.shutdown();
            }
        }
    }

    HRegionInfo getMergedHRegionInfo() {
        return this.mergeInfo;
    }

    private void mergeTwoRegions() throws IOException {
        LOG.info((Object)("Merging regions " + Bytes.toStringBinary(this.region1) + " and " + Bytes.toStringBinary(this.region2) + " in table " + this.tableName));
        HRegion meta = this.utils.getMetaRegion();
        Get get = new Get(this.region1);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        Result result1 = meta.get(get);
        Preconditions.checkState(!result1.isEmpty(), "First region cells can not be null");
        HRegionInfo info1 = HRegionInfo.getHRegionInfo(result1);
        if (info1 == null) {
            throw new NullPointerException("info1 is null using key " + Bytes.toStringBinary(this.region1) + " in " + meta);
        }
        get = new Get(this.region2);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        Result result2 = meta.get(get);
        Preconditions.checkState(!result2.isEmpty(), "Second region cells can not be null");
        HRegionInfo info2 = HRegionInfo.getHRegionInfo(result2);
        if (info2 == null) {
            throw new NullPointerException("info2 is null using key " + meta);
        }
        HTableDescriptor htd = FSTableDescriptors.getTableDescriptorFromFs(FileSystem.get(this.getConf()), this.rootdir, this.tableName);
        HRegion merged = this.merge(htd, meta, info1, info2);
        LOG.info((Object)("Adding " + merged.getRegionInfo() + " to " + meta.getRegionInfo()));
        HRegion.addRegionToMETA(meta, merged);
        merged.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRegion merge(HTableDescriptor htd, HRegion meta, HRegionInfo info1, HRegionInfo info2) throws IOException {
        if (info1 == null) {
            throw new IOException("Could not find " + Bytes.toStringBinary(this.region1) + " in " + Bytes.toStringBinary(meta.getRegionInfo().getRegionName()));
        }
        if (info2 == null) {
            throw new IOException("Could not find " + Bytes.toStringBinary(this.region2) + " in " + Bytes.toStringBinary(meta.getRegionInfo().getRegionName()));
        }
        HRegion merged = null;
        HRegion r1 = HRegion.openHRegion(info1, htd, this.utils.getLog(info1), this.getConf());
        try {
            HRegion r2 = HRegion.openHRegion(info2, htd, this.utils.getLog(info2), this.getConf());
            try {
                merged = HRegion.merge(r1, r2);
            }
            finally {
                if (!r2.isClosed()) {
                    r2.close();
                }
            }
        }
        finally {
            if (!r1.isClosed()) {
                r1.close();
            }
        }
        this.removeRegionFromMeta(meta, info1);
        this.removeRegionFromMeta(meta, info2);
        this.mergeInfo = merged.getRegionInfo();
        return merged;
    }

    private void removeRegionFromMeta(HRegion meta, HRegionInfo regioninfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing region: " + regioninfo + " from " + meta));
        }
        Delete delete = new Delete(regioninfo.getRegionName(), System.currentTimeMillis());
        meta.delete(delete);
    }

    private int parseArgs(String[] args) throws IOException {
        GenericOptionsParser parser = new GenericOptionsParser(this.getConf(), args);
        String[] remainingArgs = parser.getRemainingArgs();
        if (remainingArgs.length != 3) {
            this.usage();
            return -1;
        }
        this.tableName = TableName.valueOf(remainingArgs[0]);
        this.region1 = Bytes.toBytesBinary(remainingArgs[1]);
        this.region2 = Bytes.toBytesBinary(remainingArgs[2]);
        int status = 0;
        if (this.notInTable(this.tableName, this.region1) || this.notInTable(this.tableName, this.region2)) {
            status = -1;
        } else if (Bytes.equals(this.region1, this.region2)) {
            LOG.error((Object)"Can't merge a region with itself");
            status = -1;
        }
        return status;
    }

    private boolean notInTable(TableName tn, byte[] rn) {
        if (WritableComparator.compareBytes(tn.getName(), 0, tn.getName().length, rn, 0, tn.getName().length) != 0) {
            LOG.error((Object)("Region " + Bytes.toStringBinary(rn) + " does not belong to table " + tn));
            return true;
        }
        return false;
    }

    private void usage() {
        System.err.println("For hadoop 0.21+, Usage: bin/hbase org.apache.hadoop.hbase.util.Merge [-Dfs.defaultFS=hdfs://nn:port] <table-name> <region-1> <region-2>\n");
    }

    public static void main(String[] args) {
        int status;
        try {
            status = ToolRunner.run(HBaseConfiguration.create(), new Merge(), args);
        }
        catch (Exception e) {
            LOG.error((Object)"exiting due to error", (Throwable)e);
            status = -1;
        }
        System.exit(status);
    }
}

