/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;

public class HFileArchiveUtil {
    private HFileArchiveUtil() {
    }

    public static Path getStoreArchivePath(Configuration conf, TableName tableName, String regionName, String familyName) throws IOException {
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(conf, tableName);
        return HStore.getStoreHomedir(tableArchiveDir, regionName, Bytes.toBytes(familyName));
    }

    public static Path getStoreArchivePath(Configuration conf, HRegionInfo region, Path tabledir, byte[] family) throws IOException {
        TableName tableName = FSUtils.getTableName(tabledir);
        Path rootDir = FSUtils.getRootDir(conf);
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(rootDir, tableName);
        return HStore.getStoreHomedir(tableArchiveDir, region, family);
    }

    public static Path getRegionArchiveDir(Path rootDir, TableName tableName, Path regiondir) {
        Path archiveDir = HFileArchiveUtil.getTableArchivePath(rootDir, tableName);
        String encodedRegionName = regiondir.getName();
        return new Path(archiveDir, encodedRegionName);
    }

    public static Path getRegionArchiveDir(Path rootDir, TableName tableName, String encodedRegionName) {
        Path archiveDir = HFileArchiveUtil.getTableArchivePath(rootDir, tableName);
        return new Path(archiveDir, encodedRegionName);
    }

    public static Path getTableArchivePath(Path rootdir, TableName tableName) {
        return FSUtils.getTableDir(HFileArchiveUtil.getArchivePath(rootdir), tableName);
    }

    public static Path getTableArchivePath(Configuration conf, TableName tableName) throws IOException {
        return FSUtils.getTableDir(HFileArchiveUtil.getArchivePath(conf), tableName);
    }

    public static Path getArchivePath(Configuration conf) throws IOException {
        return HFileArchiveUtil.getArchivePath(FSUtils.getRootDir(conf));
    }

    private static Path getArchivePath(Path rootdir) {
        return new Path(rootdir, "archive");
    }
}

