/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.BloomFilterBase;

@InterfaceAudience.Private
public class CompoundBloomFilterBase
implements BloomFilterBase {
    protected int numChunks;
    public static final int VERSION = 3;
    protected float errorRate;
    protected long totalKeyCount;
    protected long totalByteSize;
    protected long totalMaxKeys;
    protected int hashType;
    protected KeyValue.KVComparator comparator;
    private static final byte[] DUMMY = new byte[0];

    @Override
    public long getMaxKeys() {
        return this.totalMaxKeys;
    }

    @Override
    public long getKeyCount() {
        return this.totalKeyCount;
    }

    @Override
    public long getByteSize() {
        return this.totalByteSize;
    }

    @Override
    public byte[] createBloomKey(byte[] row, int roffset, int rlength, byte[] qualifier, int qoffset, int qlength) {
        if (qualifier == null) {
            qualifier = DUMMY;
        }
        KeyValue kv = KeyValueUtil.createFirstOnRow(row, roffset, rlength, DUMMY, 0, 0, qualifier, qoffset, qlength);
        return kv.getKey();
    }

    @Override
    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }
}

