/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.lang.management.MemoryUsage;
import org.apache.hadoop.hbase.io.util.HeapMemorySizeUtil;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateImpl;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.emit.StandardEmitter;
import org.apache.hadoop.hbase.shaded.org.jamon.escaping.Escaping;
import org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl;
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
import org.apache.hadoop.util.StringUtils;

public class ServerMetricsTmplImpl
extends AbstractTemplateImpl
implements ServerMetricsTmpl.Intf {
    private final MetricsRegionServerWrapper mWrap;
    private final MetricsHBaseServerWrapper mServerWrap;

    protected static ServerMetricsTmpl.ImplData __jamon_setOptionalArguments(ServerMetricsTmpl.ImplData p_implData) {
        return p_implData;
    }

    public ServerMetricsTmplImpl(TemplateManager p_templateManager, ServerMetricsTmpl.ImplData p_implData) {
        super(p_templateManager, ServerMetricsTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.mWrap = p_implData.getMWrap();
        this.mServerWrap = p_implData.getMServerWrap();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_walStats\" data-toggle=\"tab\">WALs</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_queueStats\" data-toggle=\"tab\">Queues</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
        this.__jamon_innerUnit__baseStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
        this.__jamon_innerUnit__memoryStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
        this.__jamon_innerUnit__requestStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_walStats\">\n            ");
        this.__jamon_innerUnit__walStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
        this.__jamon_innerUnit__storeStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_queueStats\">\n            ");
        this.__jamon_innerUnit__queueStats(jamonWriter, this.mWrap, this.mServerWrap);
        jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getReadRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getWriteRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__queueStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap, MetricsHBaseServerWrapper mServerWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Compaction Queue Length</th>\n    <th>Flush Queue Length</th>\n    <th>Priority Call Queue Length</th>\n    <th>General Call Queue Length</th>\n    <th>Replication Call Queue Length</th>\n    <th>Total Call Queue Size (bytes)</th>\n\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getCompactionQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getFlushQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mServerWrap.getPriorityQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mServerWrap.getGeneralQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mServerWrap.getReplicationQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(mServerWrap.getTotalQueueSize(), "B", 1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__memoryStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        long usedHeap = -1L;
        long maxHeap = -1L;
        MemoryUsage usage = HeapMemorySizeUtil.safeGetHeapMemoryUsage();
        if (usage != null) {
            maxHeap = usage.getMax();
            usedHeap = usage.getUsed();
        }
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Used Heap</th>\n        <th>Max Heap</th>\n        <th>Direct Memory Used</th>\n        <th>Direct Memory Configured</th>\n        <th>Memstore Size</th>\n    </tr>\n</tr>\n<tr>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(usedHeap, "B", 1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(maxHeap, "B", 1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(DirectMemoryUtils.getDirectMemoryUsage(), "B", 1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(DirectMemoryUtils.getDirectMemorySize(), "B", 1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(mWrap.getMemstoreSize(), "B", 1)), jamonWriter);
        jamonWriter.write("\n    </td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__baseStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n\n        <th>Requests Per Second</th>\n        <th>Num. Regions</th>\n        <th>Block locality</th>\n        <th>Block locality (Secondary replicas)</th>\n        <th>Slow WAL Append Count</th>\n    </tr>\n    <tr>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumOnlineRegions()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getPercentFileLocal()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getPercentFileLocalSecondaryRegions()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(0), jamonWriter);
        jamonWriter.write("</td>\n    </tr>\n</table>\n");
    }

    private void __jamon_innerUnit__walStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Num. WAL Files</th>\n        <th>Size. WAL Files (bytes)</th>\n    </tr>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumWALFiles()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(mWrap.getWALFileSize(), "B", 1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Root Index Size (bytes)</th>\n    <th>Index Size (bytes)</th>\n    <th>Bloom Size (bytes)</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumStores()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumStoreFiles()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(mWrap.getStoreFileIndexSize(), "B", 1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(mWrap.getTotalStaticIndexSize(), "B", 1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String(mWrap.getTotalStaticBloomSize(), "B", 1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }
}

