/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.CodedInputStream;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV1;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV2;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public final class SnapshotManifest {
    private static final Log LOG = LogFactory.getLog(SnapshotManifest.class);
    public static final String SNAPSHOT_MANIFEST_SIZE_LIMIT_CONF_KEY = "snapshot.manifest.size.limit";
    public static final String DATA_MANIFEST_NAME = "data.manifest";
    private List<SnapshotProtos.SnapshotRegionManifest> regionManifests;
    private HBaseProtos.SnapshotDescription desc;
    private HTableDescriptor htd;
    private final ForeignExceptionSnare monitor;
    private final Configuration conf;
    private final Path workingDir;
    private final FileSystem rootFs;
    private final FileSystem workingDirFs;
    private int manifestSizeLimit;
    private final MonitoredTask statusTask;

    private SnapshotManifest(Configuration conf, FileSystem rootFs, Path workingDir, HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare monitor, MonitoredTask statusTask) throws IOException {
        this.monitor = monitor;
        this.desc = desc;
        this.workingDir = workingDir;
        this.conf = conf;
        this.rootFs = rootFs;
        this.statusTask = statusTask;
        this.workingDirFs = this.workingDir.getFileSystem(this.conf);
        this.manifestSizeLimit = conf.getInt(SNAPSHOT_MANIFEST_SIZE_LIMIT_CONF_KEY, 0x4000000);
    }

    public static SnapshotManifest create(Configuration conf, FileSystem fs, Path workingDir, HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare monitor) throws IOException {
        return SnapshotManifest.create(conf, fs, workingDir, desc, monitor, null);
    }

    public static SnapshotManifest create(Configuration conf, FileSystem fs, Path workingDir, HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare monitor, MonitoredTask statusTask) throws IOException {
        return new SnapshotManifest(conf, fs, workingDir, desc, monitor, statusTask);
    }

    public static SnapshotManifest open(Configuration conf, FileSystem fs, Path workingDir, HBaseProtos.SnapshotDescription desc) throws IOException {
        SnapshotManifest manifest = new SnapshotManifest(conf, fs, workingDir, desc, null, null);
        manifest.load();
        return manifest;
    }

    public void addTableDescriptor(HTableDescriptor htd) throws IOException {
        this.htd = htd;
    }

    private RegionVisitor createRegionVisitor(HBaseProtos.SnapshotDescription desc) throws IOException {
        switch (SnapshotManifest.getSnapshotFormat(desc)) {
            case 0: {
                return new SnapshotManifestV1.ManifestBuilder(this.conf, this.rootFs, this.workingDir);
            }
            case 2: {
                return new SnapshotManifestV2.ManifestBuilder(this.conf, this.rootFs, this.workingDir);
            }
        }
        throw new CorruptedSnapshotException("Invalid Snapshot version: " + desc.getVersion(), desc);
    }

    public void addRegion(HRegion region) throws IOException {
        RegionVisitor visitor = this.createRegionVisitor(this.desc);
        this.addRegion(region, visitor);
    }

    protected void addRegion(HRegion region, RegionVisitor visitor) throws IOException {
        LOG.debug((Object)("Storing '" + region + "' region-info for snapshot."));
        Object regionData = visitor.regionOpen(region.getRegionInfo());
        this.monitor.rethrowException();
        LOG.debug((Object)"Creating references for hfiles");
        for (Store store : region.getStores()) {
            Object familyData = visitor.familyOpen(regionData, store.getFamily().getName());
            this.monitor.rethrowException();
            ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(store.getStorefiles());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding snapshot references for " + storeFiles + " hfiles"));
            }
            int sz = storeFiles.size();
            for (int i = 0; i < sz; ++i) {
                StoreFile storeFile = (StoreFile)storeFiles.get(i);
                this.monitor.rethrowException();
                LOG.debug((Object)("Adding reference for file (" + (i + 1) + "/" + sz + "): " + storeFile.getPath()));
                visitor.storeFile(regionData, familyData, storeFile.getFileInfo());
            }
            visitor.familyClose(regionData, familyData);
        }
        visitor.regionClose(regionData);
    }

    public void addRegion(Path tableDir, HRegionInfo regionInfo) throws IOException {
        RegionVisitor visitor = this.createRegionVisitor(this.desc);
        this.addRegion(tableDir, regionInfo, visitor);
    }

    protected void addRegion(Path tableDir, HRegionInfo regionInfo, RegionVisitor visitor) throws IOException {
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(this.conf, this.rootFs, tableDir, regionInfo, true);
        this.monitor.rethrowException();
        LOG.debug((Object)"Storing region-info for snapshot.");
        Object regionData = visitor.regionOpen(regionInfo);
        this.monitor.rethrowException();
        LOG.debug((Object)"Creating references for hfiles");
        Collection<String> familyNames = regionFs.getFamilies();
        if (familyNames != null) {
            for (String familyName : familyNames) {
                Object familyData = visitor.familyOpen(regionData, Bytes.toBytes(familyName));
                this.monitor.rethrowException();
                Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(familyName);
                if (storeFiles == null) {
                    LOG.debug((Object)("No files under family: " + familyName));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding snapshot references for " + storeFiles + " hfiles"));
                }
                int i = 0;
                int sz = storeFiles.size();
                for (StoreFileInfo storeFile : storeFiles) {
                    this.monitor.rethrowException();
                    LOG.debug((Object)("Adding reference for file (" + ++i + "/" + sz + "): " + storeFile.getPath()));
                    visitor.storeFile(regionData, familyData, storeFile);
                }
                visitor.familyClose(regionData, familyData);
            }
        }
        visitor.regionClose(regionData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        switch (SnapshotManifest.getSnapshotFormat(this.desc)) {
            case 0: {
                this.htd = FSTableDescriptors.getTableDescriptorFromFs(this.workingDirFs, this.workingDir);
                ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
                try {
                    this.regionManifests = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.rootFs, this.workingDir, this.desc);
                    break;
                }
                finally {
                    tpool.shutdown();
                }
            }
            case 2: {
                List<SnapshotProtos.SnapshotRegionManifest> v2Regions;
                List<SnapshotProtos.SnapshotRegionManifest> v1Regions;
                SnapshotProtos.SnapshotDataManifest dataManifest = this.readDataManifest();
                if (dataManifest != null) {
                    this.htd = HTableDescriptor.convert(dataManifest.getTableSchema());
                    this.regionManifests = dataManifest.getRegionManifestsList();
                    break;
                }
                ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
                try {
                    v1Regions = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.rootFs, this.workingDir, this.desc);
                    v2Regions = SnapshotManifestV2.loadRegionManifests(this.conf, tpool, this.rootFs, this.workingDir, this.desc, this.manifestSizeLimit);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CorruptedSnapshotException("unable to parse region manifest " + e.getMessage(), e);
                }
                finally {
                    tpool.shutdown();
                }
                if (v1Regions != null && v2Regions != null) {
                    this.regionManifests = new ArrayList<SnapshotProtos.SnapshotRegionManifest>(v1Regions.size() + v2Regions.size());
                    this.regionManifests.addAll(v1Regions);
                    this.regionManifests.addAll(v2Regions);
                    break;
                }
                if (v1Regions != null) {
                    this.regionManifests = v1Regions;
                    break;
                }
                this.regionManifests = v2Regions;
                break;
            }
            default: {
                throw new CorruptedSnapshotException("Invalid Snapshot version: " + this.desc.getVersion(), this.desc);
            }
        }
    }

    public Path getSnapshotDir() {
        return this.workingDir;
    }

    public HBaseProtos.SnapshotDescription getSnapshotDescription() {
        return this.desc;
    }

    public HTableDescriptor getTableDescriptor() {
        return this.htd;
    }

    public List<SnapshotProtos.SnapshotRegionManifest> getRegionManifests() {
        return this.regionManifests;
    }

    private void setStatusMsg(String msg) {
        if (this.statusTask != null) {
            this.statusTask.setStatus(msg);
        }
    }

    public Map<String, SnapshotProtos.SnapshotRegionManifest> getRegionManifestsMap() {
        if (this.regionManifests == null || this.regionManifests.size() == 0) {
            return null;
        }
        HashMap<String, SnapshotProtos.SnapshotRegionManifest> regionsMap = new HashMap<String, SnapshotProtos.SnapshotRegionManifest>(this.regionManifests.size());
        for (SnapshotProtos.SnapshotRegionManifest manifest : this.regionManifests) {
            String regionName = SnapshotManifest.getRegionNameFromManifest(manifest);
            regionsMap.put(regionName, manifest);
        }
        return regionsMap;
    }

    public void consolidate() throws IOException {
        if (SnapshotManifest.getSnapshotFormat(this.desc) == 0) {
            Path rootDir = FSUtils.getRootDir(this.conf);
            LOG.info((Object)"Using old Snapshot Format");
            new FSTableDescriptors(this.conf, this.workingDirFs, rootDir).createTableDescriptorForTableDirectory(this.workingDir, this.htd, false);
        } else {
            LOG.debug((Object)("Convert to Single Snapshot Manifest for " + this.desc.getName()));
            this.convertToV2SingleManifest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToV2SingleManifest() throws IOException {
        ThreadPoolExecutor tpool = this.createExecutor("SnapshotManifestLoader");
        this.setStatusMsg("Loading Region manifests for " + this.desc.getName());
        try {
            List<SnapshotProtos.SnapshotRegionManifest> v1Regions = SnapshotManifestV1.loadRegionManifests(this.conf, tpool, this.workingDirFs, this.workingDir, this.desc);
            List<SnapshotProtos.SnapshotRegionManifest> v2Regions = SnapshotManifestV2.loadRegionManifests(this.conf, tpool, this.workingDirFs, this.workingDir, this.desc, this.manifestSizeLimit);
            SnapshotProtos.SnapshotDataManifest.Builder dataManifestBuilder = SnapshotProtos.SnapshotDataManifest.newBuilder();
            dataManifestBuilder.setTableSchema(this.htd.convert());
            if (v1Regions != null && v1Regions.size() > 0) {
                dataManifestBuilder.addAllRegionManifests(v1Regions);
            }
            if (v2Regions != null && v2Regions.size() > 0) {
                dataManifestBuilder.addAllRegionManifests(v2Regions);
            }
            this.setStatusMsg("Writing data manifest for " + this.desc.getName());
            SnapshotProtos.SnapshotDataManifest dataManifest = dataManifestBuilder.build();
            this.writeDataManifest(dataManifest);
            this.regionManifests = dataManifest.getRegionManifestsList();
            int totalDeletes = 0;
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(tpool);
            if (v1Regions != null) {
                for (final SnapshotProtos.SnapshotRegionManifest regionManifest : v1Regions) {
                    ++totalDeletes;
                    completionService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            SnapshotManifestV1.deleteRegionManifest(SnapshotManifest.this.workingDirFs, SnapshotManifest.this.workingDir, regionManifest);
                            return null;
                        }
                    });
                }
            }
            if (v2Regions != null) {
                for (final SnapshotProtos.SnapshotRegionManifest regionManifest : v2Regions) {
                    ++totalDeletes;
                    completionService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            SnapshotManifestV2.deleteRegionManifest(SnapshotManifest.this.workingDirFs, SnapshotManifest.this.workingDir, regionManifest);
                            return null;
                        }
                    });
                }
            }
            for (int i = 0; i < totalDeletes; ++i) {
                try {
                    completionService.take().get();
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException(ie.getMessage());
                }
                catch (ExecutionException e) {
                    throw new IOException("Error deleting region manifests", e.getCause());
                }
            }
        }
        finally {
            tpool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataManifest(SnapshotProtos.SnapshotDataManifest manifest) throws IOException {
        try (FSDataOutputStream stream = this.workingDirFs.create(new Path(this.workingDir, DATA_MANIFEST_NAME));){
            manifest.writeTo(stream);
        }
    }

    private SnapshotProtos.SnapshotDataManifest readDataManifest() throws IOException {
        try (FilterInputStream in = null;){
            in = this.workingDirFs.open(new Path(this.workingDir, DATA_MANIFEST_NAME));
            CodedInputStream cin = CodedInputStream.newInstance(in);
            cin.setSizeLimit(this.manifestSizeLimit);
            SnapshotProtos.SnapshotDataManifest snapshotDataManifest = SnapshotProtos.SnapshotDataManifest.parseFrom(cin);
            return snapshotDataManifest;
        }
    }

    private ThreadPoolExecutor createExecutor(String name) {
        return SnapshotManifest.createExecutor(this.conf, name);
    }

    public static ThreadPoolExecutor createExecutor(Configuration conf, String name) {
        int maxThreads = conf.getInt("hbase.snapshot.thread.pool.max", 8);
        return Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, Threads.getNamedThreadFactory(name));
    }

    static String getRegionNameFromManifest(SnapshotProtos.SnapshotRegionManifest manifest) {
        byte[] regionName = HRegionInfo.createRegionName(ProtobufUtil.toTableName(manifest.getRegionInfo().getTableName()), manifest.getRegionInfo().getStartKey().toByteArray(), manifest.getRegionInfo().getRegionId(), true);
        return HRegionInfo.encodeRegionName(regionName);
    }

    private static int getSnapshotFormat(HBaseProtos.SnapshotDescription desc) {
        return desc.hasVersion() ? desc.getVersion() : 0;
    }

    static interface RegionVisitor<TRegion, TFamily> {
        public TRegion regionOpen(HRegionInfo var1) throws IOException;

        public void regionClose(TRegion var1) throws IOException;

        public TFamily familyOpen(TRegion var1, byte[] var2) throws IOException;

        public void familyClose(TRegion var1, TFamily var2) throws IOException;

        public void storeFile(TRegion var1, TFamily var2, StoreFileInfo var3) throws IOException;
    }
}

