/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.DataOutputOutputStream;
import org.apache.hadoop.hbase.io.WritableWithSize;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ProtoUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableUtils;

@Deprecated
@InterfaceAudience.Private
class HbaseObjectWritableFor96Migration
implements Writable,
WritableWithSize,
Configurable {
    private static final Log LOG = LogFactory.getLog(HbaseObjectWritableFor96Migration.class);
    static final Map<Integer, Class<?>> CODE_TO_CLASS = new HashMap();
    static final Map<Class<?>, Integer> CLASS_TO_CODE = new HashMap();
    private static final byte NOT_ENCODED = 0;
    private static final int GENERIC_ARRAY_CODE;
    private static final int NEXT_CLASS_CODE;
    private Class<?> declaredClass;
    private Object instance;
    private Configuration conf;

    HbaseObjectWritableFor96Migration() {
    }

    HbaseObjectWritableFor96Migration(Object instance) {
        this.set(instance);
    }

    HbaseObjectWritableFor96Migration(Class<?> declaredClass, Object instance) {
        this.declaredClass = declaredClass;
        this.instance = instance;
    }

    Object get() {
        return this.instance;
    }

    Class<?> getDeclaredClass() {
        return this.declaredClass;
    }

    void set(Object instance) {
        this.declaredClass = instance.getClass();
        this.instance = instance;
    }

    public String toString() {
        return "OW[class=" + this.declaredClass + ",value=" + this.instance + "]";
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        HbaseObjectWritableFor96Migration.readObject(in, this, this.conf);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        HbaseObjectWritableFor96Migration.writeObject(out, this.instance, this.declaredClass, this.conf);
    }

    @Override
    public long getWritableSize() {
        return HbaseObjectWritableFor96Migration.getWritableSize(this.instance, this.declaredClass, this.conf);
    }

    static Integer getClassCode(Class<?> c) throws IOException {
        Integer code = CLASS_TO_CODE.get(c);
        if (code == null) {
            if (List.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(List.class);
            } else if (Writable.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Writable.class);
            } else if (c.isArray()) {
                code = CLASS_TO_CODE.get(Array.class);
            } else if (Message.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Message.class);
            } else if (Serializable.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Serializable.class);
            } else if (Scan.class.isAssignableFrom(c)) {
                code = CLASS_TO_CODE.get(Scan.class);
            }
        }
        return code;
    }

    static int getNextClassCode() {
        return NEXT_CLASS_CODE;
    }

    static void writeClassCode(DataOutput out, Class<?> c) throws IOException {
        Integer code = HbaseObjectWritableFor96Migration.getClassCode(c);
        if (code == null) {
            StackTraceElement[] els;
            LOG.error((Object)("Unsupported type " + c));
            for (StackTraceElement elem : els = new Exception().getStackTrace()) {
                LOG.error((Object)elem.getMethodName());
            }
            throw new UnsupportedOperationException("No code for unexpected " + c);
        }
        WritableUtils.writeVInt(out, code);
    }

    static long getWritableSize(Object instance, Class declaredClass, Configuration conf) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeObject(DataOutput out, Object instance, Class declaredClass, Configuration conf) throws IOException {
        Object instanceObj = instance;
        Class<Writable> declClass = declaredClass;
        if (instanceObj == null) {
            instanceObj = new NullInstance(declClass, conf);
            declClass = Writable.class;
        }
        HbaseObjectWritableFor96Migration.writeClassCode(out, declClass);
        if (declClass.isArray()) {
            if (declClass.equals(byte[].class)) {
                Bytes.writeByteArray(out, (byte[])instanceObj);
            } else {
                if (HbaseObjectWritableFor96Migration.getClassCode(declaredClass) == GENERIC_ARRAY_CODE) {
                    Class<?> componentType = declaredClass.getComponentType();
                    HbaseObjectWritableFor96Migration.writeClass(out, componentType);
                }
                int length = Array.getLength(instanceObj);
                out.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(instanceObj, i);
                    HbaseObjectWritableFor96Migration.writeObject(out, item, item.getClass(), conf);
                }
            }
        } else if (List.class.isAssignableFrom(declClass)) {
            List list = (List)instanceObj;
            int length = list.size();
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                Object elem;
                HbaseObjectWritableFor96Migration.writeObject(out, elem, (elem = list.get(i)) == null ? Writable.class : elem.getClass(), conf);
            }
        } else if (declClass == String.class) {
            Text.writeString(out, (String)instanceObj);
        } else if (declClass.isPrimitive()) {
            if (declClass == Boolean.TYPE) {
                out.writeBoolean((Boolean)instanceObj);
            } else if (declClass == Character.TYPE) {
                out.writeChar(((Character)instanceObj).charValue());
            } else if (declClass == Byte.TYPE) {
                out.writeByte(((Byte)instanceObj).byteValue());
            } else if (declClass == Short.TYPE) {
                out.writeShort(((Short)instanceObj).shortValue());
            } else if (declClass == Integer.TYPE) {
                out.writeInt((Integer)instanceObj);
            } else if (declClass == Long.TYPE) {
                out.writeLong((Long)instanceObj);
            } else if (declClass == Float.TYPE) {
                out.writeFloat(((Float)instanceObj).floatValue());
            } else if (declClass == Double.TYPE) {
                out.writeDouble((Double)instanceObj);
            } else if (declClass != Void.TYPE) {
                throw new IllegalArgumentException("Not a primitive: " + declClass);
            }
        } else if (declClass.isEnum()) {
            Text.writeString(out, ((Enum)instanceObj).name());
        } else if (Message.class.isAssignableFrom(declaredClass)) {
            Text.writeString(out, instanceObj.getClass().getName());
            ((Message)instance).writeDelimitedTo(DataOutputOutputStream.constructOutputStream(out));
        } else if (Writable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Integer code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString(out, c.getName());
            } else {
                HbaseObjectWritableFor96Migration.writeClassCode(out, c);
            }
            ((Writable)instanceObj).write(out);
        } else if (Serializable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Integer code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString(out, c.getName());
            } else {
                HbaseObjectWritableFor96Migration.writeClassCode(out, c);
            }
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(instanceObj);
                byte[] value = bos.toByteArray();
                out.writeInt(value.length);
                out.write(value);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
        } else if (Scan.class.isAssignableFrom(declClass)) {
            Scan scan = (Scan)instanceObj;
            byte[] scanBytes = ProtobufUtil.toScan(scan).toByteArray();
            out.writeInt(scanBytes.length);
            out.write(scanBytes);
        } else if (WAL.Entry.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Integer code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString(out, c.getName());
            } else {
                HbaseObjectWritableFor96Migration.writeClassCode(out, c);
            }
            WAL.Entry entry = (WAL.Entry)instanceObj;
            WALKey key = entry.getKey();
            if (!(key instanceof HLogKey)) {
                throw new IOException("Can't write Entry '" + instanceObj + "' due to key class '" + key.getClass() + "'");
            }
            ((HLogKey)key).write(out);
            entry.getEdit().write(out);
        } else {
            throw new IOException("Can't write: " + instanceObj + " as " + declClass);
        }
    }

    static void writeClass(DataOutput out, Class<?> c) throws IOException {
        Integer code = CLASS_TO_CODE.get(c);
        if (code == null) {
            WritableUtils.writeVInt(out, 0);
            Text.writeString(out, c.getName());
        } else {
            WritableUtils.writeVInt(out, code);
        }
    }

    static Class<?> readClass(Configuration conf, DataInput in) throws IOException {
        Class instanceClass = null;
        byte b = (byte)WritableUtils.readVInt(in);
        if (b == 0) {
            String className = Text.readString(in);
            try {
                instanceClass = HbaseObjectWritableFor96Migration.getClassByName(conf, className);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Can't find class " + className), (Throwable)e);
                throw new IOException("Can't find class " + className, e);
            }
        } else {
            instanceClass = CODE_TO_CLASS.get(b);
        }
        return instanceClass;
    }

    static Object readObject(DataInput in, Configuration conf) throws IOException {
        return HbaseObjectWritableFor96Migration.readObject(in, null, conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object readObject(DataInput in, HbaseObjectWritableFor96Migration objectWritable, Configuration conf) throws IOException {
        Object instance;
        Class<?> declaredClass = CODE_TO_CLASS.get(WritableUtils.readVInt(in));
        if (declaredClass.isPrimitive()) {
            if (declaredClass == Boolean.TYPE) {
                instance = in.readBoolean();
            } else if (declaredClass == Character.TYPE) {
                instance = Character.valueOf(in.readChar());
            } else if (declaredClass == Byte.TYPE) {
                instance = in.readByte();
            } else if (declaredClass == Short.TYPE) {
                instance = in.readShort();
            } else if (declaredClass == Integer.TYPE) {
                instance = in.readInt();
            } else if (declaredClass == Long.TYPE) {
                instance = in.readLong();
            } else if (declaredClass == Float.TYPE) {
                instance = Float.valueOf(in.readFloat());
            } else if (declaredClass == Double.TYPE) {
                instance = in.readDouble();
            } else {
                if (declaredClass != Void.TYPE) throw new IllegalArgumentException("Not a primitive: " + declaredClass);
                instance = null;
            }
        } else if (declaredClass.isArray()) {
            if (declaredClass.equals(byte[].class)) {
                instance = Bytes.readByteArray(in);
            } else {
                int length = in.readInt();
                instance = Array.newInstance(declaredClass.getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(instance, i, HbaseObjectWritableFor96Migration.readObject(in, conf));
                }
            }
        } else if (declaredClass.equals(Array.class)) {
            Class<?> componentType = HbaseObjectWritableFor96Migration.readClass(conf, in);
            int length = in.readInt();
            instance = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(instance, i, HbaseObjectWritableFor96Migration.readObject(in, conf));
            }
        } else if (List.class.isAssignableFrom(declaredClass)) {
            int length = in.readInt();
            instance = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                ((ArrayList)instance).add(HbaseObjectWritableFor96Migration.readObject(in, conf));
            }
        } else if (declaredClass == String.class) {
            instance = Text.readString(in);
        } else if (declaredClass.isEnum()) {
            instance = Enum.valueOf(declaredClass, Text.readString(in));
        } else {
            if (declaredClass == Message.class) {
                String className = Text.readString(in);
                try {
                    declaredClass = HbaseObjectWritableFor96Migration.getClassByName(conf, className);
                    instance = HbaseObjectWritableFor96Migration.tryInstantiateProtobuf(declaredClass, in);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Can't find class " + className), (Throwable)e);
                    throw new IOException("Can't find class " + className, e);
                }
            }
            if (Scan.class.isAssignableFrom(declaredClass)) {
                int length = in.readInt();
                byte[] scanBytes = new byte[length];
                in.readFully(scanBytes);
                ClientProtos.Scan.Builder scanProto = ClientProtos.Scan.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)scanProto, scanBytes);
                instance = ProtobufUtil.toScan(scanProto.build());
            } else {
                Class instanceClass = null;
                byte b = (byte)WritableUtils.readVInt(in);
                if (b == 0) {
                    String className = Text.readString(in);
                    if ("org.apache.hadoop.hbase.regionserver.wal.HLog$Entry".equals(className)) {
                        className = WAL.Entry.class.getName();
                    }
                    try {
                        instanceClass = HbaseObjectWritableFor96Migration.getClassByName(conf, className);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error((Object)("Can't find class " + className), (Throwable)e);
                        throw new IOException("Can't find class " + className, e);
                    }
                } else {
                    instanceClass = CODE_TO_CLASS.get(b);
                }
                if (Writable.class.isAssignableFrom(instanceClass)) {
                    Writable writable = WritableFactories.newInstance(instanceClass, conf);
                    try {
                        writable.readFields(in);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error in readFields", (Throwable)e);
                        throw new IOException("Error in readFields", e);
                    }
                    instance = writable;
                    if (instanceClass == NullInstance.class) {
                        declaredClass = ((NullInstance)instance).declaredClass;
                        instance = null;
                    }
                } else if (WAL.Entry.class.isAssignableFrom(instanceClass)) {
                    HLogKey key = new HLogKey();
                    WALEdit edit = new WALEdit();
                    key.readFields(in);
                    edit.readFields(in);
                    instance = new WAL.Entry(key, edit);
                } else {
                    int length = in.readInt();
                    byte[] objectBytes = new byte[length];
                    in.readFully(objectBytes);
                    ByteArrayInputStream bis = null;
                    ObjectInputStream ois = null;
                    try {
                        bis = new ByteArrayInputStream(objectBytes);
                        ois = new ObjectInputStream(bis);
                        instance = ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error((Object)"Class not found when attempting to deserialize object", (Throwable)e);
                        throw new IOException("Class not found when attempting to deserialize object", e);
                    }
                    finally {
                        if (bis != null) {
                            bis.close();
                        }
                        if (ois != null) {
                            ois.close();
                        }
                    }
                }
            }
        }
        if (objectWritable == null) return instance;
        objectWritable.declaredClass = declaredClass;
        objectWritable.instance = instance;
        return instance;
    }

    static Message tryInstantiateProtobuf(Class<?> protoClass, DataInput dataIn) throws IOException {
        try {
            if (dataIn instanceof InputStream) {
                Method parseMethod = HbaseObjectWritableFor96Migration.getStaticProtobufMethod(protoClass, "parseDelimitedFrom", InputStream.class);
                return (Message)parseMethod.invoke(null, (InputStream)((Object)dataIn));
            }
            int size = ProtoUtil.readRawVarint32(dataIn);
            if (size < 0) {
                throw new IOException("Invalid size: " + size);
            }
            byte[] data = new byte[size];
            dataIn.readFully(data);
            Method parseMethod = HbaseObjectWritableFor96Migration.getStaticProtobufMethod(protoClass, "parseFrom", byte[].class);
            return (Message)parseMethod.invoke(null, new Object[]{data});
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)("Could not access parse method in " + protoClass));
        }
    }

    static Method getStaticProtobufMethod(Class<?> declaredClass, String method, Class<?> ... args) {
        try {
            return declaredClass.getMethod(method, args);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Protocol buffer class " + declaredClass + " does not have an accessible parseFrom(InputStream) method!"));
        }
    }

    private static Class getClassByName(Configuration conf, String className) throws ClassNotFoundException {
        if (conf != null) {
            return conf.getClassByName(className);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = HbaseObjectWritableFor96Migration.class.getClassLoader();
        }
        return Class.forName(className, true, cl);
    }

    private static void addToMap(Class<?> clazz, int code) {
        CLASS_TO_CODE.put(clazz, code);
        CODE_TO_CLASS.put(code, clazz);
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    static {
        int code = 1;
        HbaseObjectWritableFor96Migration.addToMap(Boolean.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Byte.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Character.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Short.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Integer.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Long.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Float.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Double.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(Void.TYPE, code++);
        HbaseObjectWritableFor96Migration.addToMap(String.class, code++);
        HbaseObjectWritableFor96Migration.addToMap(byte[].class, code++);
        HbaseObjectWritableFor96Migration.addToMap(byte[][].class, code++);
        HbaseObjectWritableFor96Migration.addToMap(Text.class, code++);
        HbaseObjectWritableFor96Migration.addToMap(Writable.class, code++);
        HbaseObjectWritableFor96Migration.addToMap(Writable[].class, code++);
        int n = ++code;
        HbaseObjectWritableFor96Migration.addToMap(NullInstance.class, n);
        int n2 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(HColumnDescriptor.class, n2);
        int n3 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(HConstants.Modify.class, n3);
        int n4 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Integer.class, n4);
        int n5 = ++code;
        ++code;
        HbaseObjectWritableFor96Migration.addToMap(Integer[].class, n5);
        ++code;
        int n6 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(HRegionInfo.class, n6);
        int n7 = ++code;
        ++code;
        HbaseObjectWritableFor96Migration.addToMap(HRegionInfo[].class, n7);
        ++code;
        int n8 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(HTableDescriptor.class, n8);
        int n9 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(MapWritable.class, n9);
        int n10 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(ClusterStatus.class, n10);
        int n11 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Delete.class, n11);
        int n12 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Get.class, n12);
        int n13 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(KeyValue.class, n13);
        int n14 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(KeyValue[].class, n14);
        int n15 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Put.class, n15);
        int n16 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Put[].class, n16);
        int n17 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Result.class, n17);
        int n18 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Result[].class, n18);
        int n19 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Scan.class, n19);
        int n20 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(WhileMatchFilter.class, n20);
        int n21 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(PrefixFilter.class, n21);
        int n22 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(PageFilter.class, n22);
        int n23 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(InclusiveStopFilter.class, n23);
        int n24 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(ColumnCountGetFilter.class, n24);
        int n25 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(SingleColumnValueFilter.class, n25);
        int n26 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(SingleColumnValueExcludeFilter.class, n26);
        int n27 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(BinaryComparator.class, n27);
        int n28 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(BitComparator.class, n28);
        int n29 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(CompareFilter.class, n29);
        int n30 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(RowFilter.class, n30);
        int n31 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(ValueFilter.class, n31);
        int n32 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(QualifierFilter.class, n32);
        int n33 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(SkipFilter.class, n33);
        int n34 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(ByteArrayComparable.class, n34);
        int n35 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(FirstKeyOnlyFilter.class, n35);
        int n36 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(DependentColumnFilter.class, n36);
        int n37 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Delete[].class, n37);
        int n38 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(WAL.Entry.class, n38);
        int n39 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(WAL.Entry[].class, n39);
        int n40 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(HLogKey.class, n40);
        int n41 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(List.class, n41);
        int n42 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(NavigableSet.class, n42);
        int n43 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(ColumnPrefixFilter.class, n43);
        int n44 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Row.class, n44);
        int n45 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Action.class, n45);
        int n46 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(MultiAction.class, n46);
        int n47 = ++code;
        ++code;
        HbaseObjectWritableFor96Migration.addToMap(MultiResponse.class, n47);
        int n48 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Increment.class, n48);
        int n49 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(KeyOnlyFilter.class, n49);
        int n50 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Serializable.class, n50);
        int n51 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(RandomRowFilter.class, n51);
        int n52 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(CompareFilter.CompareOp.class, n52);
        int n53 = ++code;
        ++code;
        HbaseObjectWritableFor96Migration.addToMap(ColumnRangeFilter.class, n53);
        int n54 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(RegionOpeningState.class, n54);
        int n55 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(HTableDescriptor[].class, n55);
        int n56 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Append.class, n56);
        int n57 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(RowMutations.class, n57);
        int n58 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(Message.class, n58);
        int n59 = ++code;
        GENERIC_ARRAY_CODE = n59;
        HbaseObjectWritableFor96Migration.addToMap(Array.class, GENERIC_ARRAY_CODE);
        int n60 = ++code;
        HbaseObjectWritableFor96Migration.addToMap(RpcController.class, n60);
        NEXT_CLASS_CODE = ++code;
    }

    private static class NullInstance
    extends Configured
    implements Writable {
        Class<?> declaredClass;

        public NullInstance() {
            super(null);
        }

        public NullInstance(Class<?> declaredClass, Configuration conf) {
            super(conf);
            this.declaredClass = declaredClass;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.declaredClass = CODE_TO_CLASS.get(WritableUtils.readVInt(in));
        }

        @Override
        public void write(DataOutput out) throws IOException {
            HbaseObjectWritableFor96Migration.writeClassCode(out, this.declaredClass);
        }
    }
}

