/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;

@InterfaceAudience.Private
class AccessControlFilter
extends FilterBase {
    private TableAuthManager authManager;
    private TableName table;
    private User user;
    private boolean isSystemTable;
    private Strategy strategy;
    private Map<ByteRange, Integer> cfVsMaxVersions;
    private int familyMaxVersions;
    private int currentVersions;
    private ByteRange prevFam;
    private ByteRange prevQual;

    AccessControlFilter() {
    }

    AccessControlFilter(TableAuthManager mgr, User ugi, TableName tableName, Strategy strategy, Map<ByteRange, Integer> cfVsMaxVersions) {
        this.authManager = mgr;
        this.table = tableName;
        this.user = ugi;
        this.isSystemTable = tableName.isSystemTable();
        this.strategy = strategy;
        this.cfVsMaxVersions = cfVsMaxVersions;
        this.prevFam = new SimpleMutableByteRange();
        this.prevQual = new SimpleMutableByteRange();
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell cell) {
        if (this.isSystemTable) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.prevFam.getBytes() == null || Bytes.compareTo(this.prevFam.getBytes(), this.prevFam.getOffset(), this.prevFam.getLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()) != 0) {
            this.prevFam.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            this.familyMaxVersions = this.cfVsMaxVersions.get(this.prevFam);
            this.prevQual.unset();
        }
        if (this.prevQual.getBytes() == null || Bytes.compareTo(this.prevQual.getBytes(), this.prevQual.getOffset(), this.prevQual.getLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()) != 0) {
            this.prevQual.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.currentVersions = 0;
        }
        ++this.currentVersions;
        if (this.currentVersions > this.familyMaxVersions) {
            return Filter.ReturnCode.SKIP;
        }
        byte[] family = CellUtil.cloneFamily(cell);
        byte[] qualifier = CellUtil.cloneQualifier(cell);
        switch (this.strategy) {
            case CHECK_TABLE_AND_CF_ONLY: {
                if (!this.authManager.authorize(this.user, this.table, family, qualifier, Permission.Action.READ)) break;
                return Filter.ReturnCode.INCLUDE;
            }
            case CHECK_CELL_DEFAULT: {
                if (!this.authManager.authorize(this.user, this.table, family, qualifier, Permission.Action.READ) && !this.authManager.authorize(this.user, this.table, cell, Permission.Action.READ)) break;
                return Filter.ReturnCode.INCLUDE;
            }
            default: {
                throw new RuntimeException("Unhandled strategy " + (Object)((Object)this.strategy));
            }
        }
        return Filter.ReturnCode.SKIP;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public void reset() throws IOException {
        this.prevFam.unset();
        this.prevQual.unset();
        this.familyMaxVersions = 0;
        this.currentVersions = 0;
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }

    public static AccessControlFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessControlFilter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AccessControlFilter f = (AccessControlFilter)obj;
        return this.authManager.equals(f.authManager) && this.table.equals(f.table) && this.user.equals(f.user) && this.strategy.equals((Object)f.strategy) && this.cfVsMaxVersions.equals(f.cfVsMaxVersions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authManager, this.table, this.strategy, this.user, this.cfVsMaxVersions});
    }

    public static enum Strategy {
        CHECK_TABLE_AND_CF_ONLY,
        CHECK_CELL_DEFAULT;

    }
}

