/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
class FSWALEntry
extends WAL.Entry {
    private final transient long sequence;
    private final transient boolean inMemstore;
    private final transient HTableDescriptor htd;
    private final transient HRegionInfo hri;
    private final Set<byte[]> familyNames;

    FSWALEntry(long sequence, WALKey key, WALEdit edit, HTableDescriptor htd, HRegionInfo hri, boolean inMemstore) {
        super(key, edit);
        this.inMemstore = inMemstore;
        this.htd = htd;
        this.hri = hri;
        this.sequence = sequence;
        if (inMemstore) {
            ArrayList<Cell> cells = this.getEdit().getCells();
            if (CollectionUtils.isEmpty(cells)) {
                this.familyNames = Collections.emptySet();
            } else {
                TreeSet<byte[]> familySet = Sets.newTreeSet(Bytes.BYTES_COMPARATOR);
                for (Cell cell : cells) {
                    if (CellUtil.matchingFamily(cell, WALEdit.METAFAMILY)) continue;
                    familySet.add(CellUtil.cloneFamily(cell));
                }
                this.familyNames = Collections.unmodifiableSet(familySet);
            }
        } else {
            this.familyNames = Collections.emptySet();
        }
    }

    @Override
    public String toString() {
        return "sequence=" + this.sequence + ", " + super.toString();
    }

    boolean isInMemstore() {
        return this.inMemstore;
    }

    HTableDescriptor getHTableDescriptor() {
        return this.htd;
    }

    HRegionInfo getHRegionInfo() {
        return this.hri;
    }

    long getSequence() {
        return this.sequence;
    }

    long stampRegionSequenceId(MultiVersionConcurrencyControl.WriteEntry we) throws IOException {
        long regionSequenceId = we.getWriteNumber();
        if (!this.getEdit().isReplay() && this.inMemstore) {
            for (Cell c : this.getEdit().getCells()) {
                CellUtil.setSequenceId(c, regionSequenceId);
            }
        }
        this.getKey().setWriteEntry(we);
        return regionSequenceId;
    }

    Set<byte[]> getFamilyNames() {
        return this.familyNames;
    }
}

