/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.LossyCounting;

@InterfaceAudience.Private
public class MetricsUserAggregateImpl
implements MetricsUserAggregate {
    private final UserProvider userProvider;
    private final MetricsUserAggregateSource source = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).getUserAggregate();
    private final LossyCounting<MetricsUserSource> userMetricLossyCounting;

    public MetricsUserAggregateImpl(Configuration conf) {
        this.userMetricLossyCounting = new LossyCounting<MetricsUserSource>("userMetrics", conf, new LossyCounting.LossyCountingListener<MetricsUserSource>(){

            @Override
            public void sweep(MetricsUserSource key) {
                MetricsUserAggregateImpl.this.source.deregister(key);
            }
        });
        this.userProvider = UserProvider.instantiate(conf);
    }

    private String getActiveUser() {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            try {
                user = this.userProvider.getCurrent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return user != null ? user.getShortName() : null;
    }

    MetricsUserAggregateSource getSource() {
        return this.source;
    }

    @Override
    public void updatePut(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.getOrCreateMetricsUser(user).updatePut(t);
        }
    }

    @Override
    public void updateDelete(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.getOrCreateMetricsUser(user).updateDelete(t);
        }
    }

    @Override
    public void updateGet(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.getOrCreateMetricsUser(user).updateGet(t);
        }
    }

    @Override
    public void updateIncrement(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.getOrCreateMetricsUser(user).updateIncrement(t);
        }
    }

    @Override
    public void updateAppend(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.getOrCreateMetricsUser(user).updateAppend(t);
        }
    }

    @Override
    public void updateReplay(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.getOrCreateMetricsUser(user).updateReplay(t);
        }
    }

    @Override
    public void updateScanTime(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            this.getOrCreateMetricsUser(user).updateScanTime(t);
        }
    }

    private MetricsUserSource getOrCreateMetricsUser(String user) {
        MetricsUserSource userSource = this.source.getOrCreateMetricsUser(user);
        this.userMetricLossyCounting.add(userSource);
        return userSource;
    }
}

