/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues.queue;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Private
public final class EvictingQueue<E>
implements Serializable {
    private final Queue<E> delegate;
    final int maxSize;
    private static final long serialVersionUID = 0L;

    private EvictingQueue(int maxSize) {
        Preconditions.checkArgument(maxSize >= 0, "maxSize (%s) must >= 0", maxSize);
        this.delegate = new ArrayBlockingQueue(maxSize);
        this.maxSize = maxSize;
    }

    public static <E> EvictingQueue<E> create(int maxSize) {
        return new EvictingQueue<E>(maxSize);
    }

    public int remainingCapacity() {
        return this.maxSize - this.delegate.size();
    }

    protected Queue<E> delegate() {
        return this.delegate;
    }

    public boolean offer(E e) {
        return this.add(e);
    }

    public boolean add(E e) {
        Preconditions.checkNotNull(e);
        if (this.maxSize == 0) {
            return true;
        }
        if (this.delegate().size() == this.maxSize) {
            this.delegate.remove();
        }
        this.delegate.add(e);
        return true;
    }

    public <T> T[] toArray(T[] array) {
        return this.delegate().toArray(array);
    }

    public void clear() {
        this.delegate().clear();
    }

    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    public E poll() {
        return this.delegate().poll();
    }
}

