/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.master.snapshot.CloneSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.DisabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.EnabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.RestoreSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotExistsException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.TablePartiallyOpenException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
@InterfaceStability.Unstable
public class SnapshotManager
extends MasterProcedureManager
implements Stoppable {
    private static final Log LOG = LogFactory.getLog(SnapshotManager.class);
    private static final int SNAPSHOT_WAKE_MILLIS_DEFAULT = 500;
    public static final String HBASE_SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLIS = "hbase.snapshot.sentinels.cleanup.timeoutMillis";
    public static final long SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLS_DEFAULT = 60000L;
    public static final String HBASE_SNAPSHOT_ENABLED = "hbase.snapshot.enabled";
    private static final String SNAPSHOT_WAKE_MILLIS_KEY = "hbase.snapshot.master.wakeMillis";
    public static final String ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION = "online-snapshot";
    public static final String SNAPSHOT_POOL_THREADS_KEY = "hbase.snapshot.master.threads";
    public static final int SNAPSHOT_POOL_THREADS_DEFAULT = 1;
    private boolean stopped;
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private boolean isSnapshotSupported = false;
    private final Map<TableName, SnapshotSentinel> snapshotHandlers = new HashMap<TableName, SnapshotSentinel>();
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("SnapshotHandlerChoreCleaner").setDaemon(true).build());
    private ScheduledFuture<?> snapshotHandlerChoreCleanerTask;
    private Map<TableName, SnapshotSentinel> restoreHandlers = new HashMap<TableName, SnapshotSentinel>();
    private Path rootDir;
    private ExecutorService executorService;
    private ReentrantReadWriteLock takingSnapshotLock = new ReentrantReadWriteLock(true);

    public SnapshotManager() {
    }

    @InterfaceAudience.Private
    SnapshotManager(MasterServices master, ProcedureCoordinator coordinator, ExecutorService pool, int sentinelCleanInterval) throws IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        Configuration conf = master.getConfiguration();
        this.checkSnapshotSupport(conf, master.getMasterFileSystem());
        this.coordinator = coordinator;
        this.executorService = pool;
        this.resetTempDir();
        this.initSnapshotHandlerChoreCleanerTask(sentinelCleanInterval);
    }

    private void initSnapshotHandlerChoreCleanerTask(long sentinelCleanInterval) {
        this.snapshotHandlerChoreCleanerTask = this.scheduleThreadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SnapshotManager.this.cleanupSentinels();
            }
        }, sentinelCleanInterval, sentinelCleanInterval, TimeUnit.SECONDS);
    }

    public List<HBaseProtos.SnapshotDescription> getCompletedSnapshots() throws IOException {
        return this.getCompletedSnapshots(SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HBaseProtos.SnapshotDescription> getCompletedSnapshots(Path snapshotDir) throws IOException {
        ArrayList<HBaseProtos.SnapshotDescription> snapshotDescs = new ArrayList<HBaseProtos.SnapshotDescription>();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        if (snapshotDir == null) {
            snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir);
        }
        if (!fs.exists(snapshotDir)) {
            return snapshotDescs;
        }
        FileStatus[] snapshots = fs.listStatus(snapshotDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs));
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        for (FileStatus snapshot : snapshots) {
            Path info = new Path(snapshot.getPath(), ".snapshotinfo");
            if (!fs.exists(info)) {
                LOG.error((Object)("Snapshot information for " + snapshot.getPath() + " doesn't exist"));
                continue;
            }
            try (FSDataInputStream in = null;){
                in = fs.open(info);
                HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.parseFrom(in);
                if (cpHost != null) {
                    try {
                        cpHost.preListSnapshot(desc);
                    }
                    catch (AccessDeniedException e) {
                        LOG.warn((Object)("Current user does not have access to " + desc.getName() + " snapshot. " + "Either you should be owner of this snapshot or admin user."));
                        if (in == null) continue;
                        in.close();
                        continue;
                    }
                }
                snapshotDescs.add(desc);
                if (cpHost == null) continue;
                cpHost.postListSnapshot(desc);
            }
        }
        return snapshotDescs;
    }

    private void resetTempDir() throws IOException {
        Path tmpdir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.rootDir, this.master.getConfiguration());
        FileSystem tmpFs = tmpdir.getFileSystem(this.master.getConfiguration());
        if (!tmpFs.delete(tmpdir, true)) {
            LOG.warn((Object)("Couldn't delete working snapshot directory: " + tmpdir));
        }
    }

    public void deleteSnapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (!this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotDoesNotExistException(snapshot);
        }
        String snapshotName = snapshot.getName();
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, this.rootDir);
        snapshot = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preDeleteSnapshot(snapshot);
        }
        LOG.debug((Object)("Deleting snapshot: " + snapshotName));
        if (!fs.delete(snapshotDir, true)) {
            throw new HBaseSnapshotException("Failed to delete snapshot directory: " + snapshotDir);
        }
        if (cpHost != null) {
            cpHost.postDeleteSnapshot(snapshot);
        }
    }

    public boolean isSnapshotDone(HBaseProtos.SnapshotDescription expected) throws IOException {
        if (expected == null) {
            throw new UnknownSnapshotException("No snapshot name passed in request, can't figure out which snapshot you want to check.");
        }
        String ssString = ClientSnapshotDescriptionUtils.toString(expected);
        SnapshotSentinel handler = this.removeSentinelIfFinished(this.snapshotHandlers, expected);
        this.cleanupSentinels();
        if (handler == null) {
            if (!this.isSnapshotCompleted(expected)) {
                throw new UnknownSnapshotException("Snapshot " + ssString + " is not currently running or one of the known completed snapshots.");
            }
            return true;
        }
        try {
            handler.rethrowExceptionIfFailed();
        }
        catch (ForeignException e) {
            Procedure p = this.coordinator.getProcedure(expected.getName());
            String status = p != null ? p.getStatus() : expected.getName() + " not found in proclist " + this.coordinator.getProcedureNames();
            throw new HBaseSnapshotException("Snapshot " + ssString + " had an error.  " + status, e, expected);
        }
        if (handler.isFinished()) {
            LOG.debug((Object)("Snapshot '" + ssString + "' has completed, notifying client."));
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Snapshoting '" + ssString + "' is still in progress!"));
        }
        return false;
    }

    synchronized boolean isTakingSnapshot(HBaseProtos.SnapshotDescription snapshot) {
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        if (this.isTakingSnapshot(snapshotTable)) {
            return true;
        }
        for (Map.Entry<TableName, SnapshotSentinel> entry : this.snapshotHandlers.entrySet()) {
            SnapshotSentinel sentinel = entry.getValue();
            if (!snapshot.getName().equals(sentinel.getSnapshot().getName()) || sentinel.isFinished()) continue;
            return true;
        }
        return false;
    }

    synchronized boolean isTakingSnapshot(TableName tableName) {
        SnapshotSentinel handler = this.snapshotHandlers.get(tableName);
        return handler != null && !handler.isFinished();
    }

    private synchronized void prepareToTakeSnapshot(HBaseProtos.SnapshotDescription snapshot) throws HBaseSnapshotException {
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir, this.master.getConfiguration());
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        if (this.isTakingSnapshot(snapshot)) {
            SnapshotSentinel handler = this.snapshotHandlers.get(snapshotTable);
            throw new SnapshotCreationException("Rejected taking " + ClientSnapshotDescriptionUtils.toString(snapshot) + " because we are already running another snapshot " + (handler != null ? "on the same table " + ClientSnapshotDescriptionUtils.toString(handler.getSnapshot()) : "with the same name"), snapshot);
        }
        if (this.isRestoringTable(snapshotTable)) {
            SnapshotSentinel handler = this.restoreHandlers.get(snapshotTable);
            throw new SnapshotCreationException("Rejected taking " + ClientSnapshotDescriptionUtils.toString(snapshot) + " because we are already have a restore in progress on the same snapshot " + ClientSnapshotDescriptionUtils.toString(handler.getSnapshot()), snapshot);
        }
        try {
            FileSystem workingDirFS = workingDir.getFileSystem(this.master.getConfiguration());
            workingDirFS.delete(workingDir, true);
            if (!workingDirFS.mkdirs(workingDir)) {
                throw new SnapshotCreationException("Couldn't create working directory (" + workingDir + ") for snapshot", snapshot);
            }
        }
        catch (HBaseSnapshotException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Exception while checking to see if snapshot could be started.", e, snapshot);
        }
    }

    private synchronized void snapshotDisabledTable(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.prepareToTakeSnapshot(snapshot);
        snapshot = snapshot.toBuilder().setType(HBaseProtos.SnapshotDescription.Type.DISABLED).build();
        DisabledTableSnapshotHandler handler = new DisabledTableSnapshotHandler(snapshot, this.master, this);
        this.snapshotTable(snapshot, handler);
    }

    private synchronized void snapshotEnabledTable(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.prepareToTakeSnapshot(snapshot);
        EnabledTableSnapshotHandler handler = new EnabledTableSnapshotHandler(snapshot, this.master, this);
        this.snapshotTable(snapshot, handler);
    }

    private synchronized void snapshotTable(HBaseProtos.SnapshotDescription snapshot, TakeSnapshotHandler handler) throws IOException {
        try {
            handler.prepare();
            this.executorService.submit(handler);
            this.snapshotHandlers.put(TableName.valueOf(snapshot.getTable()), handler);
        }
        catch (Exception e) {
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir, this.master.getConfiguration());
            FileSystem workingDirFs = workingDir.getFileSystem(this.master.getConfiguration());
            try {
                if (!workingDirFs.delete(workingDir, true)) {
                    LOG.error((Object)("Couldn't delete working directory (" + workingDir + " for snapshot:" + ClientSnapshotDescriptionUtils.toString(snapshot)));
                }
            }
            catch (IOException e1) {
                LOG.error((Object)("Couldn't delete working directory (" + workingDir + " for snapshot:" + ClientSnapshotDescriptionUtils.toString(snapshot)));
            }
            throw new SnapshotCreationException("Could not build snapshot handler", e, snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeSnapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.takingSnapshotLock.readLock().lock();
        try {
            this.takeSnapshotInternal(snapshot);
        }
        finally {
            this.takingSnapshotLock.readLock().unlock();
        }
    }

    private void takeSnapshotInternal(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotExistsException("Snapshot '" + snapshot.getName() + "' already stored on the filesystem.", snapshot);
        }
        LOG.debug((Object)"No existing snapshot, attempting snapshot...");
        this.cleanupSentinels();
        HTableDescriptor desc = null;
        try {
            desc = this.master.getTableDescriptors().get(TableName.valueOf(snapshot.getTable()));
        }
        catch (FileNotFoundException e) {
            String msg = "Table:" + snapshot.getTable() + " info doesn't exist!";
            LOG.error((Object)msg);
            throw new SnapshotCreationException(msg, e, snapshot);
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Error while geting table description for table " + snapshot.getTable(), e, snapshot);
        }
        if (desc == null) {
            throw new SnapshotCreationException("Table '" + snapshot.getTable() + "' doesn't exist, can't take snapshot.", snapshot);
        }
        HBaseProtos.SnapshotDescription.Builder builder = snapshot.toBuilder();
        if (!snapshot.hasVersion()) {
            builder.setVersion(2);
        }
        User user = RpcServer.getRequestUser();
        if (this.master.getConfiguration().getBoolean("hbase.security.authorization", false) && user != null) {
            builder.setOwner(user.getShortName());
        }
        snapshot = builder.build();
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSnapshot(snapshot, desc);
        }
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        AssignmentManager assignmentMgr = this.master.getAssignmentManager();
        if (assignmentMgr.getTableStateManager().isTableState(snapshotTable, ZooKeeperProtos.Table.State.ENABLED)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Table enabled, starting distributed snapshot for " + ClientSnapshotDescriptionUtils.toString(snapshot)));
            }
            this.snapshotEnabledTable(snapshot);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Started snapshot: " + ClientSnapshotDescriptionUtils.toString(snapshot)));
            }
        } else if (assignmentMgr.getTableStateManager().isTableState(snapshotTable, ZooKeeperProtos.Table.State.DISABLED)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Table is disabled, running snapshot entirely on master " + ClientSnapshotDescriptionUtils.toString(snapshot)));
            }
            this.snapshotDisabledTable(snapshot);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Started snapshot: " + ClientSnapshotDescriptionUtils.toString(snapshot)));
            }
        } else {
            LOG.error((Object)("Can't snapshot table '" + snapshot.getTable() + "', isn't open or closed, we don't know what to do!"));
            TablePartiallyOpenException tpoe = new TablePartiallyOpenException(snapshot.getTable() + " isn't fully open.");
            throw new SnapshotCreationException("Table is not entirely open or closed", tpoe, snapshot);
        }
        if (cpHost != null) {
            cpHost.postSnapshot(snapshot, desc);
        }
    }

    public ReadWriteLock getTakingSnapshotLock() {
        return this.takingSnapshotLock;
    }

    public synchronized boolean isTakingAnySnapshot() {
        return this.takingSnapshotLock.getReadHoldCount() > 0 || this.snapshotHandlers.size() > 0;
    }

    public synchronized void setSnapshotHandlerForTesting(TableName tableName, SnapshotSentinel handler) {
        if (handler != null) {
            this.snapshotHandlers.put(tableName, handler);
        } else {
            this.snapshotHandlers.remove(tableName);
        }
    }

    ProcedureCoordinator getCoordinator() {
        return this.coordinator;
    }

    private boolean isSnapshotCompleted(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        try {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, this.rootDir);
            FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
            return fs.exists(snapshotDir);
        }
        catch (IllegalArgumentException iae) {
            throw new UnknownSnapshotException("Unexpected exception thrown", iae);
        }
    }

    synchronized void cloneSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor, boolean restoreAcl) throws HBaseSnapshotException {
        TableName tableName = hTableDescriptor.getTableName();
        if (this.isTakingSnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            CloneSnapshotHandler handler = new CloneSnapshotHandler(this.master, snapshot, hTableDescriptor, restoreAcl).prepare();
            this.executorService.submit(handler);
            this.restoreHandlers.put(tableName, handler);
        }
        catch (Exception e) {
            String msg = "Couldn't clone the snapshot=" + ClientSnapshotDescriptionUtils.toString(snapshot) + " on table=" + tableName;
            LOG.error((Object)msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, e);
        }
    }

    @Deprecated
    public void restoreSnapshot(HBaseProtos.SnapshotDescription reqSnapshot) throws IOException {
        this.restoreSnapshot(reqSnapshot, false);
    }

    public void restoreSnapshot(HBaseProtos.SnapshotDescription reqSnapshot, boolean restoreAcl) throws IOException {
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(reqSnapshot, this.rootDir);
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        if (!fs.exists(snapshotDir)) {
            LOG.error((Object)("A Snapshot named '" + reqSnapshot.getName() + "' does not exist."));
            throw new SnapshotDoesNotExistException(reqSnapshot);
        }
        HBaseProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open(this.master.getConfiguration(), fs, snapshotDir, snapshot);
        HTableDescriptor snapshotTableDesc = manifest.getTableDescriptor();
        TableName tableName = TableName.valueOf(reqSnapshot.getTable());
        this.cleanupSentinels();
        SnapshotReferenceUtil.verifySnapshot(this.master.getConfiguration(), fs, manifest);
        if (MetaTableAccessor.tableExists(this.master.getConnection(), tableName)) {
            if (this.master.getAssignmentManager().getTableStateManager().isTableState(TableName.valueOf(snapshot.getTable()), ZooKeeperProtos.Table.State.ENABLED)) {
                throw new UnsupportedOperationException("Table '" + TableName.valueOf(snapshot.getTable()) + "' must be disabled in order to " + "perform a restore operation" + ".");
            }
            if (cpHost != null) {
                cpHost.preRestoreSnapshot(snapshot, snapshotTableDesc);
            }
            int tableRegionCount = -1;
            try {
                tableRegionCount = this.getRegionCountOfTable(tableName);
                int snapshotRegionCount = manifest.getRegionManifestsMap().size();
                if (tableRegionCount > 0 && tableRegionCount < snapshotRegionCount) {
                    this.checkAndUpdateNamespaceRegionQuota(snapshotRegionCount, tableName);
                }
                this.restoreSnapshot(snapshot, snapshotTableDesc, restoreAcl);
                if (tableRegionCount > 0 && tableRegionCount > snapshotRegionCount) {
                    this.checkAndUpdateNamespaceRegionQuota(snapshotRegionCount, tableName);
                }
            }
            catch (QuotaExceededException e) {
                LOG.error((Object)("Region quota exceeded while restoring the snapshot " + snapshot.getName() + " as table " + tableName.getNameAsString()), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                if (tableRegionCount > 0) {
                    this.checkAndUpdateNamespaceRegionQuota(tableRegionCount, tableName);
                }
                LOG.error((Object)("Exception occurred while restoring the snapshot " + snapshot.getName() + " as table " + tableName.getNameAsString()), (Throwable)e);
                throw e;
            }
            LOG.info((Object)("Restore snapshot=" + snapshot.getName() + " as table=" + tableName));
            if (cpHost != null) {
                cpHost.postRestoreSnapshot(snapshot, snapshotTableDesc);
            }
        } else {
            HTableDescriptor htd = new HTableDescriptor(tableName, snapshotTableDesc);
            if (cpHost != null) {
                cpHost.preCloneSnapshot(snapshot, htd);
            }
            try {
                this.checkAndUpdateNamespaceQuota(manifest, tableName);
                this.cloneSnapshot(snapshot, htd, restoreAcl);
            }
            catch (IOException e) {
                this.master.getMasterQuotaManager().removeTableFromNamespaceQuota(tableName);
                LOG.error((Object)("Exception occurred while cloning the snapshot " + snapshot.getName() + " as table " + tableName.getNameAsString()), (Throwable)e);
                throw e;
            }
            LOG.info((Object)("Clone snapshot=" + snapshot.getName() + " as table=" + tableName));
            if (cpHost != null) {
                cpHost.postCloneSnapshot(snapshot, htd);
            }
        }
    }

    private void checkAndUpdateNamespaceQuota(SnapshotManifest manifest, TableName tableName) throws IOException {
        if (this.master.getMasterQuotaManager().isQuotaInitialized()) {
            this.master.getMasterQuotaManager().checkNamespaceTableAndRegionQuota(tableName, manifest.getRegionManifestsMap().size());
        }
    }

    private void checkAndUpdateNamespaceRegionQuota(int updatedRegionCount, TableName tableName) throws IOException {
        if (this.master.getMasterQuotaManager().isQuotaInitialized()) {
            this.master.getMasterQuotaManager().checkAndUpdateNamespaceRegionQuota(tableName, updatedRegionCount);
        }
    }

    private int getRegionCountOfTable(TableName tableName) throws IOException {
        if (this.master.getMasterQuotaManager().isQuotaInitialized()) {
            return this.master.getMasterQuotaManager().getRegionCountOfTable(tableName);
        }
        return -1;
    }

    private synchronized void restoreSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor, boolean restoreAcl) throws HBaseSnapshotException {
        TableName tableName = hTableDescriptor.getTableName();
        if (this.isTakingSnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            RestoreSnapshotHandler handler = new RestoreSnapshotHandler(this.master, snapshot, hTableDescriptor, restoreAcl).prepare();
            this.executorService.submit(handler);
            this.restoreHandlers.put(tableName, handler);
        }
        catch (Exception e) {
            String msg = "Couldn't restore the snapshot=" + ClientSnapshotDescriptionUtils.toString(snapshot) + " on table=" + tableName;
            LOG.error((Object)msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, e);
        }
    }

    private synchronized boolean isRestoringTable(TableName tableName) {
        SnapshotSentinel sentinel = this.restoreHandlers.get(tableName);
        return sentinel != null && !sentinel.isFinished();
    }

    public boolean isRestoreDone(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        SnapshotSentinel sentinel = this.removeSentinelIfFinished(this.restoreHandlers, snapshot);
        this.cleanupSentinels();
        if (sentinel == null) {
            return true;
        }
        LOG.debug((Object)("Verify snapshot=" + snapshot.getName() + " against=" + sentinel.getSnapshot().getName() + " table=" + TableName.valueOf(snapshot.getTable())));
        sentinel.rethrowExceptionIfFailed();
        if (sentinel.isFinished()) {
            LOG.debug((Object)("Restore snapshot=" + ClientSnapshotDescriptionUtils.toString(snapshot) + " has completed. Notifying the client."));
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sentinel is not yet finished with restoring snapshot=" + ClientSnapshotDescriptionUtils.toString(snapshot)));
        }
        return false;
    }

    private synchronized SnapshotSentinel removeSentinelIfFinished(Map<TableName, SnapshotSentinel> sentinels, HBaseProtos.SnapshotDescription snapshot) {
        if (!snapshot.hasTable()) {
            return null;
        }
        TableName snapshotTable = TableName.valueOf(snapshot.getTable());
        SnapshotSentinel h = sentinels.get(snapshotTable);
        if (h == null) {
            return null;
        }
        if (!h.getSnapshot().getName().equals(snapshot.getName())) {
            return null;
        }
        if (h.isFinished()) {
            sentinels.remove(snapshotTable);
        }
        return h;
    }

    private void cleanupSentinels() {
        this.cleanupSentinels(this.snapshotHandlers);
        this.cleanupSentinels(this.restoreHandlers);
    }

    private synchronized void cleanupSentinels(Map<TableName, SnapshotSentinel> sentinels) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        long sentinelsCleanupTimeoutMillis = this.master.getConfiguration().getLong(HBASE_SNAPSHOT_SENTINELS_CLEANUP_TIMEOUT_MILLIS, 60000L);
        Iterator<Map.Entry<TableName, SnapshotSentinel>> it = sentinels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TableName, SnapshotSentinel> entry = it.next();
            SnapshotSentinel sentinel = entry.getValue();
            if (!sentinel.isFinished() || currentTime - sentinel.getCompletionTimestamp() <= sentinelsCleanupTimeoutMillis) continue;
            it.remove();
        }
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        for (SnapshotSentinel snapshotHandler : this.snapshotHandlers.values()) {
            snapshotHandler.cancel(why);
        }
        if (this.snapshotHandlerChoreCleanerTask != null) {
            this.snapshotHandlerChoreCleanerTask.cancel(true);
        }
        for (SnapshotSentinel restoreHandler : this.restoreHandlers.values()) {
            restoreHandler.cancel(why);
        }
        try {
            if (this.coordinator != null) {
                this.coordinator.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"stop ProcedureCoordinator error", (Throwable)e);
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public void checkSnapshotSupport() throws UnsupportedOperationException {
        if (!this.isSnapshotSupported) {
            throw new UnsupportedOperationException("To use snapshots, You must add to the hbase-site.xml of the HBase Master: 'hbase.snapshot.enabled' property with value 'true'.");
        }
    }

    private void checkSnapshotSupport(Configuration conf, MasterFileSystem mfs) throws IOException, UnsupportedOperationException {
        String enabled = conf.get(HBASE_SNAPSHOT_ENABLED);
        boolean snapshotEnabled = conf.getBoolean(HBASE_SNAPSHOT_ENABLED, false);
        boolean userDisabled = enabled != null && enabled.trim().length() > 0 && !snapshotEnabled;
        HashSet<String> hfileCleaners = new HashSet<String>();
        String[] cleaners = conf.getStrings("hbase.master.hfilecleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(hfileCleaners, cleaners);
        }
        HashSet logCleaners = new HashSet();
        cleaners = conf.getStrings("hbase.master.logcleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(logCleaners, cleaners);
        }
        Path oldSnapshotDir = new Path(mfs.getRootDir(), ".snapshot");
        FileSystem fs = mfs.getFileSystem();
        List<HBaseProtos.SnapshotDescription> ss = this.getCompletedSnapshots(new Path(this.rootDir, oldSnapshotDir));
        if (ss != null && !ss.isEmpty()) {
            LOG.error((Object)("Snapshots from an earlier release were found under: " + oldSnapshotDir));
            LOG.error((Object)"Please rename the directory as .hbase-snapshot");
        }
        if (snapshotEnabled) {
            hfileCleaners.add(SnapshotHFileCleaner.class.getName());
            hfileCleaners.add(HFileLinkCleaner.class.getName());
            conf.setStrings("hbase.master.hfilecleaner.plugins", hfileCleaners.toArray(new String[hfileCleaners.size()]));
            conf.setStrings("hbase.master.logcleaner.plugins", logCleaners.toArray(new String[logCleaners.size()]));
        } else {
            boolean bl = snapshotEnabled = hfileCleaners.contains(SnapshotHFileCleaner.class.getName()) && hfileCleaners.contains(HFileLinkCleaner.class.getName());
            if (snapshotEnabled) {
                LOG.warn((Object)("Snapshot log and hfile cleaners are present in the configuration, but the 'hbase.snapshot.enabled' property " + (userDisabled ? "is set to 'false'." : "is not set.")));
            }
        }
        boolean bl = this.isSnapshotSupported = snapshotEnabled && !userDisabled;
        if (!snapshotEnabled) {
            FileStatus[] snapshots;
            LOG.info((Object)"Snapshot feature is not enabled, missing log and hfile cleaners.");
            Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(mfs.getRootDir());
            if (fs.exists(snapshotDir) && (snapshots = FSUtils.listStatus(fs, snapshotDir, new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs))) != null) {
                LOG.error((Object)"Snapshots are present, but cleaners are not enabled.");
                this.checkSnapshotSupport();
            }
        }
    }

    @Override
    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        this.checkSnapshotSupport(master.getConfiguration(), master.getMasterFileSystem());
        Configuration conf = master.getConfiguration();
        long wakeFrequency = conf.getInt(SNAPSHOT_WAKE_MILLIS_KEY, 500);
        long timeoutMillis = Math.max(conf.getLong("hbase.snapshot.master.timeoutMillis", 300000L), conf.getLong("hbase.snapshot.master.timeout.millis", 300000L));
        int opThreads = conf.getInt(SNAPSHOT_POOL_THREADS_KEY, 1);
        String name = master.getServerName().toString();
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool(name, opThreads);
        ZKProcedureCoordinatorRpcs comms = new ZKProcedureCoordinatorRpcs(master.getZooKeeper(), ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION, name);
        this.coordinator = new ProcedureCoordinator(comms, tpool, timeoutMillis, wakeFrequency);
        this.executorService = master.getExecutorService();
        this.resetTempDir();
        this.initSnapshotHandlerChoreCleanerTask(10L);
    }

    @Override
    public String getProcedureSignature() {
        return ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION;
    }

    @Override
    public void execProcedure(HBaseProtos.ProcedureDescription desc) throws IOException {
        this.takeSnapshot(this.toSnapshotDescription(desc));
    }

    @Override
    public boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) throws IOException {
        return this.isSnapshotDone(this.toSnapshotDescription(desc));
    }

    private HBaseProtos.SnapshotDescription toSnapshotDescription(HBaseProtos.ProcedureDescription desc) throws IOException {
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        if (!desc.hasInstance()) {
            throw new IOException("Snapshot name is not defined: " + desc.toString());
        }
        String snapshotName = desc.getInstance();
        List<HBaseProtos.NameStringPair> props = desc.getConfigurationList();
        String table = null;
        for (HBaseProtos.NameStringPair prop : props) {
            if (!"table".equalsIgnoreCase(prop.getName())) continue;
            table = prop.getValue();
        }
        if (table == null) {
            throw new IOException("Snapshot table is not defined: " + desc.toString());
        }
        TableName tableName = TableName.valueOf(table);
        builder.setTable(tableName.getNameAsString());
        builder.setName(snapshotName);
        builder.setType(HBaseProtos.SnapshotDescription.Type.FLUSH);
        return builder.build();
    }
}

