/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;

@InterfaceAudience.Private
public class SplitLogManager {
    private static final Log LOG = LogFactory.getLog(SplitLogManager.class);
    private Server server;
    private final Stoppable stopper;
    private final Configuration conf;
    private final ChoreService choreService;
    public static final int DEFAULT_UNASSIGNED_TIMEOUT = 180000;
    private long unassignedTimeout;
    private long lastTaskCreateTime = Long.MAX_VALUE;
    private long checkRecoveringTimeThreshold = 15000L;
    private final List<Pair<Set<ServerName>, Boolean>> failedRecoveringRegionDeletions = Collections.synchronizedList(new ArrayList());
    protected final ReentrantLock recoveringRegionLock = new ReentrantLock();
    private final ConcurrentMap<String, Task> tasks = new ConcurrentHashMap<String, Task>();
    private TimeoutMonitor timeoutMonitor;
    private volatile Set<ServerName> deadWorkers = null;
    private final Object deadWorkersLock = new Object();

    public SplitLogManager(Server server, Configuration conf, Stoppable stopper, MasterServices master, ServerName serverName) throws IOException {
        this.server = server;
        this.conf = conf;
        this.stopper = stopper;
        this.choreService = new ChoreService(serverName.toString() + "_splitLogManager_");
        if (server.getCoordinatedStateManager() != null) {
            SplitLogManagerCoordination coordination = ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getSplitLogManagerCoordination();
            Set<String> failedDeletions = Collections.synchronizedSet(new HashSet());
            SplitLogManagerCoordination.SplitLogManagerDetails details = new SplitLogManagerCoordination.SplitLogManagerDetails(this.tasks, master, failedDeletions, serverName);
            coordination.setDetails(details);
            coordination.init();
        }
        this.unassignedTimeout = conf.getInt("hbase.splitlog.manager.unassigned.timeout", 180000);
        this.timeoutMonitor = new TimeoutMonitor(conf.getInt("hbase.splitlog.manager.timeoutmonitor.period", 1000), stopper);
        this.choreService.scheduleChore(this.timeoutMonitor);
    }

    private FileStatus[] getFileList(List<Path> logDirs, PathFilter filter) throws IOException {
        return SplitLogManager.getFileList(this.conf, logDirs, filter);
    }

    public static FileStatus[] getFileList(Configuration conf, List<Path> logDirs, PathFilter filter) throws IOException {
        ArrayList fileStatus = new ArrayList();
        for (Path logDir : logDirs) {
            FileSystem fs = logDir.getFileSystem(conf);
            if (!fs.exists(logDir)) {
                LOG.warn((Object)(logDir + " doesn't exist. Nothing to do!"));
                continue;
            }
            FileStatus[] logfiles = FSUtils.listStatus(fs, logDir, filter);
            if (logfiles == null || logfiles.length == 0) {
                LOG.info((Object)(logDir + " is empty dir, no logs to split"));
                continue;
            }
            Collections.addAll(fileStatus, logfiles);
        }
        FileStatus[] a = new FileStatus[fileStatus.size()];
        return fileStatus.toArray(a);
    }

    public long splitLogDistributed(Path logDir) throws IOException {
        ArrayList<Path> logDirs = new ArrayList<Path>();
        logDirs.add(logDir);
        return this.splitLogDistributed(logDirs);
    }

    public long splitLogDistributed(List<Path> logDirs) throws IOException {
        if (logDirs.isEmpty()) {
            return 0L;
        }
        HashSet<ServerName> serverNames = new HashSet<ServerName>();
        for (Path logDir : logDirs) {
            try {
                ServerName serverName = DefaultWALProvider.getServerNameFromWALDirectoryName(logDir);
                if (serverName == null) continue;
                serverNames.add(serverName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)("Cannot parse server name from " + logDir));
            }
        }
        return this.splitLogDistributed(serverNames, logDirs, null);
    }

    public long splitLogDistributed(Set<ServerName> serverNames, List<Path> logDirs, PathFilter filter) throws IOException {
        String msg;
        MonitoredTask status = TaskMonitor.get().createStatus("Doing distributed log split in " + logDirs + " for serverName=" + serverNames);
        FileStatus[] logfiles = this.getFileList(logDirs, filter);
        status.setStatus("Checking directory contents...");
        SplitLogCounters.tot_mgr_log_split_batch_start.incrementAndGet();
        LOG.info((Object)("Started splitting " + logfiles.length + " logs in " + logDirs + " for " + serverNames));
        long t = EnvironmentEdgeManager.currentTime();
        long totalSize = 0L;
        TaskBatch batch = new TaskBatch();
        Boolean isMetaRecovery = filter == null ? null : Boolean.valueOf(false);
        for (FileStatus lf : logfiles) {
            totalSize += lf.getLen();
            String pathToLog = FSUtils.removeWALRootPath(lf.getPath(), this.conf);
            if (this.enqueueSplitTask(pathToLog, batch)) continue;
            throw new IOException("duplicate log split scheduled for " + lf.getPath());
        }
        this.waitForSplittingCompletion(batch, status);
        if (filter == MasterFileSystem.META_FILTER) {
            isMetaRecovery = true;
        }
        this.removeRecoveringRegions(serverNames, isMetaRecovery);
        if (batch.done != batch.installed) {
            batch.isDead = true;
            SplitLogCounters.tot_mgr_log_split_batch_err.incrementAndGet();
            LOG.warn((Object)("error while splitting logs in " + logDirs + " installed = " + batch.installed + " but only " + batch.done + " done"));
            msg = "error or interrupted while splitting logs in " + logDirs + " Task = " + batch;
            status.abort(msg);
            throw new IOException(msg);
        }
        for (Path logDir : logDirs) {
            status.setStatus("Cleaning up log directory...");
            FileSystem fs = logDir.getFileSystem(this.conf);
            try {
                if (fs.exists(logDir) && !fs.delete(logDir, false)) {
                    LOG.warn((Object)("Unable to delete log src dir. Ignoring. " + logDir));
                }
            }
            catch (IOException ioe) {
                Object[] files = fs.listStatus(logDir);
                if (files != null && files.length > 0) {
                    LOG.warn((Object)("Returning success without actually splitting and deleting all the log files in path " + logDir + ": " + Arrays.toString(files)), (Throwable)ioe);
                }
                LOG.warn((Object)("Unable to delete log src dir. Ignoring. " + logDir), (Throwable)ioe);
            }
            SplitLogCounters.tot_mgr_log_split_batch_success.incrementAndGet();
        }
        msg = "finished splitting (more than or equal to) " + totalSize + " bytes in " + batch.installed + " log files in " + logDirs + " in " + (EnvironmentEdgeManager.currentTime() - t) + "ms";
        status.markComplete(msg);
        LOG.info((Object)msg);
        return totalSize;
    }

    boolean enqueueSplitTask(String taskname, TaskBatch batch) {
        this.lastTaskCreateTime = EnvironmentEdgeManager.currentTime();
        String task = ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().prepareTask(taskname);
        Task oldtask = this.createTaskIfAbsent(task, batch);
        if (oldtask == null) {
            ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().submitTask(task);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSplittingCompletion(TaskBatch batch, MonitoredTask status) {
        TaskBatch taskBatch = batch;
        synchronized (taskBatch) {
            while (batch.done + batch.error != batch.installed) {
                try {
                    int remainingTasks;
                    status.setStatus("Waiting for distributed tasks to finish.  scheduled=" + batch.installed + " done=" + batch.done + " error=" + batch.error);
                    int remaining = batch.installed - (batch.done + batch.error);
                    int actual = this.activeTasks(batch);
                    if (remaining != actual) {
                        LOG.warn((Object)("Expected " + remaining + " active tasks, but actually there are " + actual));
                    }
                    if ((remainingTasks = ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().remainingTasksInCoordination()) >= 0 && actual > remainingTasks) {
                        LOG.warn((Object)("Expected at least" + actual + " tasks remaining, but actually there are " + remainingTasks));
                    }
                    if (remainingTasks == 0 || actual == 0) {
                        LOG.warn((Object)("No more task remaining, splitting should have completed. Remaining tasks is " + remainingTasks + ", active tasks in map " + actual));
                        if (remainingTasks == 0 && actual == 0) {
                            return;
                        }
                    }
                    batch.wait(100L);
                    if (!this.stopper.isStopped()) continue;
                    LOG.warn((Object)"Stopped while waiting for log splits to be completed");
                    return;
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting for log splits to be completed");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    ConcurrentMap<String, Task> getTasks() {
        return this.tasks;
    }

    private int activeTasks(TaskBatch batch) {
        int count = 0;
        for (Task t : this.tasks.values()) {
            if (t.batch != batch || t.status != TerminationStatus.IN_PROGRESS) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRecoveringRegions(Set<ServerName> serverNames, Boolean isMetaRecovery) {
        if (!this.isLogReplaying()) {
            return;
        }
        if (serverNames == null || serverNames.isEmpty()) {
            return;
        }
        HashSet<String> recoveredServerNameSet = new HashSet<String>();
        for (ServerName tmpServerName : serverNames) {
            recoveredServerNameSet.add(tmpServerName.getServerName());
        }
        this.recoveringRegionLock.lock();
        try {
            ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().removeRecoveringRegions(recoveredServerNameSet, isMetaRecovery);
        }
        catch (IOException e) {
            LOG.warn((Object)"removeRecoveringRegions got exception. Will retry", (Throwable)e);
            if (serverNames != null && !serverNames.isEmpty()) {
                this.failedRecoveringRegionDeletions.add(new Pair<Set<ServerName>, Boolean>(serverNames, isMetaRecovery));
            }
        }
        finally {
            this.recoveringRegionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStaleRecoveringRegions(Set<ServerName> failedServers) throws IOException, InterruptedIOException {
        HashSet<String> knownFailedServers = new HashSet<String>();
        if (failedServers != null) {
            for (ServerName tmpServerName : failedServers) {
                knownFailedServers.add(tmpServerName.getServerName());
            }
        }
        this.recoveringRegionLock.lock();
        try {
            ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().removeStaleRecoveringRegions(knownFailedServers);
        }
        finally {
            this.recoveringRegionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task createTaskIfAbsent(String path, TaskBatch batch) {
        Task newtask = new Task();
        newtask.batch = batch;
        Task oldtask = this.tasks.putIfAbsent(path, newtask);
        if (oldtask == null) {
            ++batch.installed;
            return null;
        }
        Task task = oldtask;
        synchronized (task) {
            if (oldtask.isOrphan()) {
                if (oldtask.status == TerminationStatus.SUCCESS) {
                    return null;
                }
                if (oldtask.status == TerminationStatus.IN_PROGRESS) {
                    oldtask.batch = batch;
                    ++batch.installed;
                    LOG.debug((Object)("Previously orphan task " + path + " is now being waited upon"));
                    return null;
                }
                while (oldtask.status == TerminationStatus.FAILURE) {
                    LOG.debug((Object)("wait for status of task " + path + " to change to DELETED"));
                    SplitLogCounters.tot_mgr_wait_for_zk_delete.incrementAndGet();
                    try {
                        oldtask.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.warn((Object)"Interrupted when waiting for znode delete callback");
                        break;
                    }
                }
                if (oldtask.status != TerminationStatus.DELETED) {
                    LOG.warn((Object)("Failure because previously failed task state still present. Waiting for znode delete callback path=" + path));
                    return oldtask;
                }
                Task t = this.tasks.putIfAbsent(path, newtask);
                if (t == null) {
                    ++batch.installed;
                    return null;
                }
                LOG.fatal((Object)"Logic error. Deleted task still present in tasks map");
                assert (false) : "Deleted task still present in tasks map";
                return t;
            }
            LOG.warn((Object)("Failure because two threads can't wait for the same task; path=" + path));
            return oldtask;
        }
    }

    Task findOrCreateOrphanTask(String path) {
        Task orphanTask = new Task();
        Task task = this.tasks.putIfAbsent(path, orphanTask);
        if (task == null) {
            LOG.info((Object)("creating orphan task " + path));
            SplitLogCounters.tot_mgr_orphan_task_acquired.incrementAndGet();
            task = orphanTask;
        }
        return task;
    }

    public void stop() {
        if (this.choreService != null) {
            this.choreService.shutdown();
        }
        if (this.timeoutMonitor != null) {
            this.timeoutMonitor.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeadWorker(ServerName workerName) {
        Object object = this.deadWorkersLock;
        synchronized (object) {
            if (this.deadWorkers == null) {
                this.deadWorkers = new HashSet<ServerName>(100);
            }
            this.deadWorkers.add(workerName);
        }
        LOG.info((Object)("dead splitlog worker " + workerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeadWorkers(Set<ServerName> serverNames) {
        Object object = this.deadWorkersLock;
        synchronized (object) {
            if (this.deadWorkers == null) {
                this.deadWorkers = new HashSet<ServerName>(100);
            }
            this.deadWorkers.addAll(serverNames);
        }
        LOG.info((Object)("dead splitlog workers " + serverNames));
    }

    public void setRecoveryMode(boolean isForInitialization) throws IOException {
        ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().setRecoveryMode(isForInitialization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRegionsRecovering(ServerName server, Set<HRegionInfo> userRegions) throws InterruptedIOException, IOException {
        if (userRegions == null || !this.isLogReplaying()) {
            return;
        }
        try {
            this.recoveringRegionLock.lock();
            ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().markRegionsRecovering(server, userRegions);
        }
        finally {
            this.recoveringRegionLock.unlock();
        }
    }

    public boolean isLogReplaying() {
        if (this.server.getCoordinatedStateManager() == null) {
            return false;
        }
        return ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().isReplaying();
    }

    public boolean isLogSplitting() {
        if (this.server.getCoordinatedStateManager() == null) {
            return false;
        }
        return ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().isSplitting();
    }

    public ZooKeeperProtos.SplitLogTask.RecoveryMode getRecoveryMode() {
        return ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().getRecoveryMode();
    }

    public static enum TerminationStatus {
        IN_PROGRESS("in_progress"),
        SUCCESS("success"),
        FAILURE("failure"),
        DELETED("deleted");

        final String statusMsg;

        private TerminationStatus(String msg) {
            this.statusMsg = msg;
        }

        public String toString() {
            return this.statusMsg;
        }
    }

    public static enum ResubmitDirective {
        CHECK,
        FORCE;

    }

    private class TimeoutMonitor
    extends ScheduledChore {
        private long lastLog;

        public TimeoutMonitor(int period, Stoppable stopper) {
            super("SplitLogManager Timeout Monitor", stopper, period);
            this.lastLog = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void chore() {
            Set<String> failedDeletions;
            long now;
            Task task;
            Set localDeadWorkers;
            int resubmitted = 0;
            int unassigned = 0;
            int tot = 0;
            boolean found_assigned_task = false;
            Object object = SplitLogManager.this.deadWorkersLock;
            synchronized (object) {
                localDeadWorkers = SplitLogManager.this.deadWorkers;
                SplitLogManager.this.deadWorkers = null;
            }
            for (Map.Entry e : SplitLogManager.this.tasks.entrySet()) {
                String path = (String)e.getKey();
                task = (Task)e.getValue();
                ServerName cur_worker = task.cur_worker_name;
                ++tot;
                if (task.isUnassigned()) {
                    ++unassigned;
                    continue;
                }
                found_assigned_task = true;
                if (localDeadWorkers != null && localDeadWorkers.contains(cur_worker)) {
                    SplitLogCounters.tot_mgr_resubmit_dead_server_task.incrementAndGet();
                    if (((BaseCoordinatedStateManager)SplitLogManager.this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().resubmitTask(path, task, ResubmitDirective.FORCE)) {
                        ++resubmitted;
                        continue;
                    }
                    SplitLogManager.this.handleDeadWorker(cur_worker);
                    LOG.warn((Object)("Failed to resubmit task " + path + " owned by dead " + cur_worker + ", will retry."));
                    continue;
                }
                if (!((BaseCoordinatedStateManager)SplitLogManager.this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().resubmitTask(path, task, ResubmitDirective.CHECK)) continue;
                ++resubmitted;
            }
            if (tot > 0 && (now = EnvironmentEdgeManager.currentTime()) > this.lastLog + 5000L) {
                this.lastLog = now;
                LOG.info((Object)("total tasks = " + tot + " unassigned = " + unassigned + " tasks=" + SplitLogManager.this.tasks));
            }
            if (resubmitted > 0) {
                LOG.info((Object)("resubmitted " + resubmitted + " out of " + tot + " tasks"));
            }
            if (tot > 0 && !found_assigned_task && EnvironmentEdgeManager.currentTime() - SplitLogManager.this.lastTaskCreateTime > SplitLogManager.this.unassignedTimeout) {
                for (Map.Entry e : SplitLogManager.this.tasks.entrySet()) {
                    String key = (String)e.getKey();
                    task = (Task)e.getValue();
                    if (!task.isUnassigned() || task.status == TerminationStatus.FAILURE) continue;
                    ((BaseCoordinatedStateManager)SplitLogManager.this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().checkTaskStillAvailable(key);
                }
                ((BaseCoordinatedStateManager)SplitLogManager.this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().checkTasks();
                SplitLogCounters.tot_mgr_resubmit_unassigned.incrementAndGet();
                LOG.debug((Object)"resubmitting unassigned task(s) after timeout");
            }
            if ((failedDeletions = ((BaseCoordinatedStateManager)SplitLogManager.this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().getDetails().getFailedDeletions()).size() > 0) {
                ArrayList<String> tmpPaths = new ArrayList<String>(failedDeletions);
                for (String tmpPath : tmpPaths) {
                    ((BaseCoordinatedStateManager)SplitLogManager.this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().deleteTask(tmpPath);
                }
                failedDeletions.removeAll(tmpPaths);
            }
            long timeInterval = EnvironmentEdgeManager.currentTime() - ((BaseCoordinatedStateManager)SplitLogManager.this.server.getCoordinatedStateManager()).getSplitLogManagerCoordination().getLastRecoveryTime();
            if (!SplitLogManager.this.failedRecoveringRegionDeletions.isEmpty() || tot == 0 && SplitLogManager.this.tasks.size() == 0 && timeInterval > SplitLogManager.this.checkRecoveringTimeThreshold) {
                if (!SplitLogManager.this.failedRecoveringRegionDeletions.isEmpty()) {
                    ArrayList previouslyFailedDeletions = new ArrayList(SplitLogManager.this.failedRecoveringRegionDeletions);
                    SplitLogManager.this.failedRecoveringRegionDeletions.removeAll(previouslyFailedDeletions);
                    for (Pair failedDeletion : previouslyFailedDeletions) {
                        SplitLogManager.this.removeRecoveringRegions((Set)failedDeletion.getFirst(), (Boolean)failedDeletion.getSecond());
                    }
                } else {
                    SplitLogManager.this.removeRecoveringRegions(null, null);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static class Task {
        public volatile long last_update;
        public volatile int last_version = -1;
        public volatile ServerName cur_worker_name;
        public volatile TaskBatch batch;
        public volatile TerminationStatus status;
        public volatile AtomicInteger incarnation = new AtomicInteger(0);
        public final AtomicInteger unforcedResubmits = new AtomicInteger();
        public volatile boolean resubmitThresholdReached;

        public String toString() {
            return "last_update = " + this.last_update + " last_version = " + this.last_version + " cur_worker_name = " + this.cur_worker_name + " status = " + (Object)((Object)this.status) + " incarnation = " + this.incarnation + " resubmits = " + this.unforcedResubmits.get() + " batch = " + this.batch;
        }

        public Task() {
            this.status = TerminationStatus.IN_PROGRESS;
            this.setUnassigned();
        }

        public boolean isOrphan() {
            return this.batch == null || this.batch.isDead;
        }

        public boolean isUnassigned() {
            return this.cur_worker_name == null;
        }

        public void heartbeatNoDetails(long time) {
            this.last_update = time;
        }

        public void heartbeat(long time, int version, ServerName worker) {
            this.last_version = version;
            this.last_update = time;
            this.cur_worker_name = worker;
        }

        public void setUnassigned() {
            this.cur_worker_name = null;
            this.last_update = -1L;
        }
    }

    @InterfaceAudience.Private
    public static class TaskBatch {
        public int installed = 0;
        public int done = 0;
        public int error = 0;
        public volatile boolean isDead = false;

        public String toString() {
            return "installed = " + this.installed + " done = " + this.done + " error = " + this.error;
        }
    }
}

