/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSourceFactory;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;

@InterfaceAudience.Private
public class MetricsHBaseServer {
    private MetricsHBaseServerSource source;
    private MetricsHBaseServerWrapper serverWrapper;

    public MetricsHBaseServer(String serverName, MetricsHBaseServerWrapper wrapper) {
        this.serverWrapper = wrapper;
        this.source = CompatibilitySingletonFactory.getInstance(MetricsHBaseServerSourceFactory.class).create(serverName, wrapper);
    }

    void authorizationSuccess() {
        this.source.authorizationSuccess();
    }

    void authorizationFailure() {
        this.source.authorizationFailure();
    }

    void authenticationFailure() {
        this.source.authenticationFailure();
    }

    void authenticationSuccess() {
        this.source.authenticationSuccess();
    }

    void authenticationFallback() {
        this.source.authenticationFallback();
    }

    void sentBytes(long count) {
        this.source.sentBytes(count);
    }

    void receivedBytes(int count) {
        this.source.receivedBytes(count);
    }

    void sentResponse(long count) {
        this.source.sentResponse(count);
    }

    void receivedRequest(long count) {
        this.source.receivedRequest(count);
    }

    void dequeuedCall(int qTime) {
        this.source.dequeuedCall(qTime);
    }

    void processedCall(int processingTime) {
        this.source.processedCall(processingTime);
    }

    void totalCall(int totalTime) {
        this.source.queuedAndProcessedCall(totalTime);
    }

    public void exception(Throwable throwable) {
        this.source.exception();
        if (throwable != null) {
            if (throwable instanceof OutOfOrderScannerNextException) {
                this.source.outOfOrderException();
            } else if (throwable instanceof RegionTooBusyException) {
                this.source.tooBusyException();
            } else if (throwable instanceof UnknownScannerException) {
                this.source.unknownScannerException();
            } else if (throwable instanceof ScannerResetException) {
                this.source.scannerResetException();
            } else if (throwable instanceof RegionMovedException) {
                this.source.movedRegionException();
            } else if (throwable instanceof NotServingRegionException) {
                this.source.notServingRegionException();
            } else if (throwable instanceof FailedSanityCheckException) {
                this.source.failedSanityException();
            } else if (throwable instanceof MultiActionResultTooLarge) {
                this.source.multiActionTooLargeException();
            } else if (throwable instanceof CallQueueTooBigException) {
                this.source.callQueueTooBigException();
            }
        }
    }

    public MetricsHBaseServerSource getMetricsSource() {
        return this.source;
    }

    public MetricsHBaseServerWrapper getHBaseServerWrapper() {
        return this.serverWrapper;
    }
}

