/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.Cache;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.RemovalListener;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.RemovalNotification;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;

@InterfaceAudience.Private
public class BufferedBucketCache
extends BucketCache {
    private static final Log LOG = LogFactory.getLog(BufferedBucketCache.class);
    static final String RAM_BUFFER_SIZE_RATIO = "hbase.bucketcache.rambuffer.ratio";
    static final double RAM_BUFFER_SIZE_RATIO_DEFAULT = 0.1;
    static final String RAM_BUFFER_TIMEOUT = "hbase.bucketcache.rambuffer.timeout";
    static final int RAM_BUFFER_TIMEOUT_DEFAULT = 60;
    private final Cache<BlockCacheKey, Cacheable> ramBuffer;
    private final long maxBufferSize;
    private final AtomicLong ramBufferEvictCount = new AtomicLong(0L);
    private volatile float ramBufferThreshold;
    private final transient ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("RAMBufferAdjustExecutor").setDaemon(true).build());

    public BufferedBucketCache(String ioEngineName, long capacity, int blockSize, int[] bucketSizes, int writerThreadNum, int writerQLen, String persistencePath, int ioErrorsTolerationDuration, Configuration conf) throws IOException {
        super(ioEngineName, capacity, blockSize, bucketSizes, writerThreadNum, writerQLen, persistencePath, ioErrorsTolerationDuration, conf);
        this.maxBufferSize = (long)((double)capacity / (double)blockSize * conf.getDouble(RAM_BUFFER_SIZE_RATIO, 0.1));
        int timeout = conf.getInt(RAM_BUFFER_TIMEOUT, 60);
        this.ramBuffer = CacheBuilder.newBuilder().expireAfterAccess(timeout, TimeUnit.SECONDS).maximumSize(this.maxBufferSize).removalListener(new RemovalListener<BlockCacheKey, Cacheable>(){

            @Override
            public void onRemoval(RemovalNotification<BlockCacheKey, Cacheable> removalNotification) {
                BufferedBucketCache.this.ramBufferEvictCount.incrementAndGet();
            }
        }).build();
        this.scheduleThreadPool.scheduleAtFixedRate(new RAMBufferAdjustThread(this), 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey key, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        Cacheable block = this.ramBuffer.getIfPresent(key);
        if (block != null) {
            if (updateCacheMetrics) {
                this.getStats().hit(caching, key.isPrimary(), key.getBlockType());
            }
            return block;
        }
        block = super.getBlock(key, caching, repeat, updateCacheMetrics);
        if (block != null && (float)this.ramBuffer.size() < (float)this.maxBufferSize * this.ramBufferThreshold) {
            this.ramBuffer.put(key, block);
        }
        return block;
    }

    private void updateRAMBufferThreshold(float newThreshold) {
        this.ramBufferThreshold = Math.max(Math.min(newThreshold, 1.0f), 0.01f);
    }

    static class RAMBufferAdjustThread
    extends Thread {
        private final BufferedBucketCache bucketCache;

        RAMBufferAdjustThread(BufferedBucketCache bucketCache) {
            this.bucketCache = bucketCache;
        }

        @Override
        public void run() {
            long currentEvictCount = this.bucketCache.ramBufferEvictCount.get();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)e);
                return;
            }
            long delta = (this.bucketCache.ramBufferEvictCount.get() - currentEvictCount) / 10L;
            if (delta > 100L) {
                this.bucketCache.updateRAMBufferThreshold((float)((double)this.bucketCache.ramBufferThreshold * 0.9));
            } else if (delta < 10L) {
                this.bucketCache.updateRAMBufferThreshold((float)((double)this.bucketCache.ramBufferThreshold * 1.1));
            }
        }
    }
}

