/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.shaded.com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class JobBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    JobBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, can't do anything without a JobID."})))._();
            return;
        }
        JobId jobID = MRApps.toJobID(jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Sorry, ", jid, " not found."})))._();
            return;
        }
        List<AMInfo> amInfos = job.getAMInfos();
        String amString = amInfos.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        JobInfo jinfo = new JobInfo(job, true);
        this.info("Job Overview")._("Job Name:", jinfo.getName())._("State:", jinfo.getState())._("Uberized:", jinfo.isUberized())._("Started:", new Date(jinfo.getStartTime()))._("Elapsed:", StringUtils.formatTime(jinfo.getElapsedTime()));
        HamletSpec.DIV div = ((Hamlet)html._(InfoBlock.class)).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        HamletSpec.TABLE table = ((Hamlet.DIV)div).table("#job");
        ((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TABLE)table).tr()).th(amString)))._()).tr()).th(".ui-state-default", "Attempt Number")).th(".ui-state-default", "Start Time")).th(".ui-state-default", "Node")).th(".ui-state-default", "Logs")))._();
        for (AMInfo amInfo : amInfos) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, jinfo.getId(), jinfo.getUserName());
            ((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)table).tr()).td(String.valueOf(attempt.getAttemptId()))).td(new Date(attempt.getStartTime()).toString())).td()).a(".nodelink", this.url(MRWebAppUtil.getYARNWebappScheme(), attempt.getNodeHttpAddress()), attempt.getNodeHttpAddress())))._()).td()).a(".logslink", this.url(attempt.getLogsLink()), "logs")))._())._();
        }
        ((HamletImpl.EImp)((Object)table))._();
        ((HamletImpl.EImp)((Object)div))._();
        ((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((HamletImpl.EImp)((Object)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)html.div(".info-wrap.ui-widget-content.ui-corner-bottom")).table("#job")).tr()).th(".ui-state-default", "Task Type")).th(".ui-state-default", "Progress")).th(".ui-state-default", "Total")).th(".ui-state-default", "Pending")).th(".ui-state-default", "Running")).th(".ui-state-default", "Complete")))._()).tr(".odd")).th("Map")).td()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all")).$title(StringHelper.join(jinfo.getMapProgressPercent(), Character.valueOf('%')))).div(".ui-progressbar-value.ui-widget-header.ui-corner-left")).$style(StringHelper.join("width:", jinfo.getMapProgressPercent(), Character.valueOf('%')))))._())._())._()).td()).a(this.url("tasks", jid, "m", "ALL"), String.valueOf(jinfo.getMapsTotal()))))._()).td()).a(this.url("tasks", jid, "m", "PENDING"), String.valueOf(jinfo.getMapsPending()))))._()).td()).a(this.url("tasks", jid, "m", "RUNNING"), String.valueOf(jinfo.getMapsRunning()))))._()).td()).a(this.url("tasks", jid, "m", "COMPLETED"), String.valueOf(jinfo.getMapsCompleted()))))._())._()).tr(".even")).th("Reduce")).td()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all")).$title(StringHelper.join(jinfo.getReduceProgressPercent(), Character.valueOf('%')))).div(".ui-progressbar-value.ui-widget-header.ui-corner-left")).$style(StringHelper.join("width:", jinfo.getReduceProgressPercent(), Character.valueOf('%')))))._())._())._()).td()).a(this.url("tasks", jid, "r", "ALL"), String.valueOf(jinfo.getReducesTotal()))))._()).td()).a(this.url("tasks", jid, "r", "PENDING"), String.valueOf(jinfo.getReducesPending()))))._()).td()).a(this.url("tasks", jid, "r", "RUNNING"), String.valueOf(jinfo.getReducesRunning()))))._()).td()).a(this.url("tasks", jid, "r", "COMPLETED"), String.valueOf(jinfo.getReducesCompleted()))))._())._())._()).table("#job")).tr()).th(".ui-state-default", "Attempt Type")).th(".ui-state-default", "New")).th(".ui-state-default", "Running")).th(".ui-state-default", "Failed")).th(".ui-state-default", "Killed")).th(".ui-state-default", "Successful")))._()).tr(".odd")).th("Maps")).td()).a(this.url("attempts", jid, "m", MRApps.TaskAttemptStateUI.NEW.toString()), String.valueOf(jinfo.getNewMapAttempts()))))._()).td()).a(this.url("attempts", jid, "m", MRApps.TaskAttemptStateUI.RUNNING.toString()), String.valueOf(jinfo.getRunningMapAttempts()))))._()).td()).a(this.url("attempts", jid, "m", MRApps.TaskAttemptStateUI.FAILED.toString()), String.valueOf(jinfo.getFailedMapAttempts()))))._()).td()).a(this.url("attempts", jid, "m", MRApps.TaskAttemptStateUI.KILLED.toString()), String.valueOf(jinfo.getKilledMapAttempts()))))._()).td()).a(this.url("attempts", jid, "m", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()), String.valueOf(jinfo.getSuccessfulMapAttempts()))))._())._()).tr(".even")).th("Reduces")).td()).a(this.url("attempts", jid, "r", MRApps.TaskAttemptStateUI.NEW.toString()), String.valueOf(jinfo.getNewReduceAttempts()))))._()).td()).a(this.url("attempts", jid, "r", MRApps.TaskAttemptStateUI.RUNNING.toString()), String.valueOf(jinfo.getRunningReduceAttempts()))))._()).td()).a(this.url("attempts", jid, "r", MRApps.TaskAttemptStateUI.FAILED.toString()), String.valueOf(jinfo.getFailedReduceAttempts()))))._()).td()).a(this.url("attempts", jid, "r", MRApps.TaskAttemptStateUI.KILLED.toString()), String.valueOf(jinfo.getKilledReduceAttempts()))))._()).td()).a(this.url("attempts", jid, "r", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()), String.valueOf(jinfo.getSuccessfulReduceAttempts()))))._())._())._())._();
    }
}

