/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;

@InterfaceAudience.Private
public class XAttrStorage {
    public static List<XAttr> readINodeXAttrs(INode inode, int snapshotId) {
        XAttrFeature f = inode.getXAttrFeature(snapshotId);
        return f == null ? ImmutableList.of() : f.getXAttrs();
    }

    public static List<XAttr> readINodeXAttrs(INode inode) {
        XAttrFeature f = inode.getXAttrFeature();
        return f == null ? ImmutableList.of() : f.getXAttrs();
    }

    public static void updateINodeXAttrs(INode inode, List<XAttr> xAttrs, int snapshotId) throws QuotaExceededException {
        if (xAttrs == null || xAttrs.isEmpty()) {
            if (inode.getXAttrFeature() != null) {
                inode.removeXAttrFeature(snapshotId);
            }
            return;
        }
        ImmutableList<XAttr> newXAttrs = ImmutableList.copyOf(xAttrs);
        if (inode.getXAttrFeature() != null) {
            inode.removeXAttrFeature(snapshotId);
        }
        inode.addXAttrFeature(new XAttrFeature(newXAttrs), snapshotId);
    }
}

