/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ReplicationChecker {
    private static final Log LOG = LogFactory.getLog(ReplicationChecker.class);
    private final ZooKeeperWatcher zkw;
    private HBaseFsck.ErrorReporter errorReporter;
    private ReplicationQueuesClient queuesClient;
    private ReplicationPeers replicationPeers;
    private ReplicationQueueDeletor queueDeletor;
    private Map<String, List<String>> undeletedQueueIds = new HashMap<String, List<String>>();
    private Set<String> undeletedHFileRefsQueueIds = new HashSet<String>();
    private final String hfileRefsZNode;

    public ReplicationChecker(Configuration conf, ZooKeeperWatcher zkw, HConnection connection, HBaseFsck.ErrorReporter errorReporter) throws IOException {
        try {
            this.zkw = zkw;
            this.errorReporter = errorReporter;
            this.queuesClient = ReplicationFactory.getReplicationQueuesClient(zkw, conf, connection);
            this.queuesClient.init();
            this.replicationPeers = ReplicationFactory.getReplicationPeers(zkw, conf, this.queuesClient, connection);
            this.replicationPeers.init();
            this.queueDeletor = new ReplicationQueueDeletor(zkw, conf, connection);
        }
        catch (ReplicationException e) {
            throw new IOException("failed to construct ReplicationChecker", e);
        }
        String replicationZNodeName = conf.get("zookeeper.znode.replication", "replication");
        String replicationZNode = ZKUtil.joinZNode(this.zkw.baseZNode, replicationZNodeName);
        String hfileRefsZNodeName = conf.get("zookeeper.znode.replication.hfile.refs", "hfile-refs");
        this.hfileRefsZNode = ZKUtil.joinZNode(replicationZNode, hfileRefsZNodeName);
    }

    public boolean hasUnDeletedQueues() {
        return this.errorReporter.getErrorList().contains((Object)HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE);
    }

    public void checkUnDeletedQueues() throws IOException {
        HashSet<String> peerIds = new HashSet<String>(this.replicationPeers.getAllPeerIds());
        try {
            List<String> replicators = this.queuesClient.getListOfReplicators();
            if (replicators == null || replicators.isEmpty()) {
                return;
            }
            for (String replicator : replicators) {
                List<String> queueIds = this.queuesClient.getAllQueues(replicator);
                for (String queueId : queueIds) {
                    ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                    if (peerIds.contains(queueInfo.getPeerId())) continue;
                    if (!this.undeletedQueueIds.containsKey(replicator)) {
                        this.undeletedQueueIds.put(replicator, new ArrayList());
                    }
                    this.undeletedQueueIds.get(replicator).add(queueId);
                    String msg = "Undeleted replication queue for removed peer found: " + String.format("[removedPeerId=%s, replicator=%s, queueId=%s]", queueInfo.getPeerId(), replicator, queueId);
                    this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
                }
            }
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
        this.checkUnDeletedHFileRefsQueues(peerIds);
    }

    private void checkUnDeletedHFileRefsQueues(Set<String> peerIds) throws IOException {
        try {
            if (-1 == ZKUtil.checkExists(this.zkw, this.hfileRefsZNode)) {
                return;
            }
            List<String> listOfPeers = this.queuesClient.getAllPeersFromHFileRefsQueue();
            HashSet<String> peers = new HashSet<String>(listOfPeers);
            peers.removeAll(peerIds);
            if (!peers.isEmpty()) {
                this.undeletedHFileRefsQueueIds.addAll(peers);
                String msg = "Undeleted replication hfile-refs queue for removed peer found: " + this.undeletedHFileRefsQueueIds + " under hfile-refs node " + this.hfileRefsZNode;
                this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, msg);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed to get list of all peers from hfile-refs znode " + this.hfileRefsZNode, e);
        }
    }

    public void fixUnDeletedQueues() throws IOException {
        for (Map.Entry<String, List<String>> replicatorAndQueueIds : this.undeletedQueueIds.entrySet()) {
            String replicator = replicatorAndQueueIds.getKey();
            for (String queueId : replicatorAndQueueIds.getValue()) {
                this.queueDeletor.removeQueue(replicator, queueId);
            }
        }
        this.fixUnDeletedHFileRefsQueue();
    }

    private void fixUnDeletedHFileRefsQueue() throws IOException {
        for (String hfileRefsQueueId : this.undeletedHFileRefsQueueIds) {
            String node = ZKUtil.joinZNode(this.hfileRefsZNode, hfileRefsQueueId);
            try {
                ZKUtil.deleteNodeRecursively(this.zkw, node);
                LOG.info((Object)("Successfully deleted hfile-refs queue " + hfileRefsQueueId + " from path " + this.hfileRefsZNode));
            }
            catch (KeeperException e) {
                throw new IOException("Failed to delete hfile-refs queue " + hfileRefsQueueId + " from path " + this.hfileRefsZNode);
            }
        }
    }

    private static class ReplicationQueueDeletor
    extends ReplicationStateZKBase {
        public ReplicationQueueDeletor(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
            super(zk, conf, abortable);
        }

        public void removeQueue(String replicator, String queueId) throws IOException {
            String queueZnodePath = ZKUtil.joinZNode(ZKUtil.joinZNode(this.queuesZNode, replicator), queueId);
            try {
                ZKUtil.deleteNodeRecursively(this.zookeeper, queueZnodePath);
                LOG.info((Object)("remove replication queue, replicator: " + replicator + ", queueId: " + queueId));
            }
            catch (KeeperException e) {
                throw new IOException("failed to delete queue, replicator: " + replicator + ", queueId: " + queueId);
            }
        }
    }
}

