/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DirectMemoryUtils {
    private static final Log LOG = LogFactory.getLog(DirectMemoryUtils.class);
    private static final String MEMORY_USED = "MemoryUsed";
    private static final MBeanServer BEAN_SERVER;
    private static final ObjectName NIO_DIRECT_POOL;
    private static final boolean HAS_MEMORY_USED_ATTRIBUTE;

    public static long getDirectMemorySize() {
        RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimemxBean.getInputArguments();
        long multiplier = 1L;
        for (String s : arguments) {
            if (!s.contains("-XX:MaxDirectMemorySize=")) continue;
            String memSize = s.toLowerCase().replace("-xx:maxdirectmemorysize=", "").trim();
            if (memSize.contains("k")) {
                multiplier = 1024L;
            } else if (memSize.contains("m")) {
                multiplier = 0x100000L;
            } else if (memSize.contains("g")) {
                multiplier = 0x40000000L;
            }
            memSize = memSize.replaceAll("[^\\d]", "");
            long retValue = Long.parseLong(memSize);
            return retValue * multiplier;
        }
        return 0L;
    }

    public static long getDirectMemoryUsage() {
        if (BEAN_SERVER == null || NIO_DIRECT_POOL == null || !HAS_MEMORY_USED_ATTRIBUTE) {
            return 0L;
        }
        try {
            Long value = (Long)BEAN_SERVER.getAttribute(NIO_DIRECT_POOL, MEMORY_USED);
            return value == null ? 0L : value;
        }
        catch (JMException e) {
            return 0L;
        }
    }

    public static void destroyDirectByteBuffer(ByteBuffer toBeDestroyed) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Preconditions.checkArgument(toBeDestroyed.isDirect(), "toBeDestroyed isn't direct!");
        Method cleanerMethod = toBeDestroyed.getClass().getMethod("cleaner", new Class[0]);
        cleanerMethod.setAccessible(true);
        Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
        Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
        cleanMethod.setAccessible(true);
        cleanMethod.invoke(cleaner, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ObjectName n = null;
        MBeanServer s = null;
        Object a = null;
        try {
            n = new ObjectName("java.nio:type=BufferPool,name=direct");
        }
        catch (MalformedObjectNameException e) {
            LOG.warn((Object)"Unable to initialize ObjectName for DirectByteBuffer allocations.");
        }
        finally {
            NIO_DIRECT_POOL = n;
        }
        if (NIO_DIRECT_POOL != null) {
            s = ManagementFactory.getPlatformMBeanServer();
        }
        if ((BEAN_SERVER = s) != null) {
            try {
                a = BEAN_SERVER.getAttribute(NIO_DIRECT_POOL, MEMORY_USED);
            }
            catch (JMException e) {
                LOG.debug((Object)("Failed to retrieve nio.BufferPool direct MemoryUsed attribute: " + e));
            }
        }
        HAS_MEMORY_USED_ATTRIBUTE = a != null;
    }
}

