/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.JasperException;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.JspCompilationContext;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.ParserController;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.TagFileProcessor;

class ImplicitTagLibraryInfo
extends TagLibraryInfo {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    private static final String TAG_FILE_SUFFIX = ".tag";
    private static final String TAGX_FILE_SUFFIX = ".tagx";
    private static final String TAGS_SHORTNAME = "tags";
    private static final String TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "2.0";
    private Hashtable tagFileMap;
    private ParserController pc;
    private Vector vec;

    public ImplicitTagLibraryInfo(JspCompilationContext ctxt, ParserController pc, String prefix, String tagdir, ErrorDispatcher err) throws JasperException {
        super(prefix, null);
        this.pc = pc;
        this.tagFileMap = new Hashtable();
        this.vec = new Vector();
        this.functions = new FunctionInfo[0];
        this.tlibversion = TLIB_VERSION;
        this.jspversion = JSP_VERSION;
        if (!tagdir.startsWith(WEB_INF_TAGS)) {
            err.jspError("jsp.error.invalid.tagdir", tagdir);
        }
        if (tagdir.equals(WEB_INF_TAGS) || tagdir.equals("/WEB-INF/tags/")) {
            this.shortname = TAGS_SHORTNAME;
        } else {
            this.shortname = tagdir.substring(WEB_INF_TAGS.length());
            this.shortname = this.shortname.replace('/', '-');
        }
        Set dirList = ctxt.getResourcePaths(tagdir);
        if (dirList != null) {
            Iterator it = dirList.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (!path.endsWith(TAG_FILE_SUFFIX) && !path.endsWith(TAGX_FILE_SUFFIX)) continue;
                String suffix = path.endsWith(TAG_FILE_SUFFIX) ? TAG_FILE_SUFFIX : TAGX_FILE_SUFFIX;
                String tagName = path.substring(path.lastIndexOf("/") + 1);
                tagName = tagName.substring(0, tagName.lastIndexOf(suffix));
                this.tagFileMap.put(tagName, path);
            }
        }
    }

    public TagFileInfo getTagFile(String shortName) {
        TagFileInfo tagFile = super.getTagFile(shortName);
        if (tagFile == null) {
            String path = (String)this.tagFileMap.get(shortName);
            if (path == null) {
                return null;
            }
            TagInfo tagInfo = null;
            try {
                tagInfo = TagFileProcessor.parseTagFileDirectives(this.pc, shortName, path, this);
            }
            catch (JasperException je) {
                throw new RuntimeException(je.toString());
            }
            tagFile = new TagFileInfo(shortName, path, tagInfo);
            this.vec.addElement(tagFile);
            this.tagFiles = new TagFileInfo[this.vec.size()];
            this.vec.copyInto(this.tagFiles);
        }
        return tagFile;
    }
}

