/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.lmax.disruptor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.AlertException;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.Sequence;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.SequenceBarrier;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.WaitStrategy;

public final class LiteBlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();
    private final AtomicBoolean signalNeeded = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence = cursorSequence.get();
        if (availableSequence < sequence) {
            this.lock.lock();
            try {
                do {
                    this.signalNeeded.getAndSet(true);
                    availableSequence = cursorSequence.get();
                    if (availableSequence >= sequence) {
                        break;
                    }
                    barrier.checkAlert();
                    this.processorNotifyCondition.await();
                } while ((availableSequence = cursorSequence.get()) < sequence);
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWhenBlocking() {
        if (this.signalNeeded.getAndSet(false)) {
            this.lock.lock();
            try {
                this.processorNotifyCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

