/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ZKPermissionWatcher
extends ZooKeeperListener
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ZKPermissionWatcher.class);
    static final String ACL_NODE = "acl";
    TableAuthManager authManager;
    String aclZNode;
    CountDownLatch initialized = new CountDownLatch(1);
    AtomicReference<List<ZKUtil.NodeAndData>> nodes = new AtomicReference<Object>(null);
    ExecutorService executor;

    public ZKPermissionWatcher(ZooKeeperWatcher watcher, TableAuthManager authManager, Configuration conf) {
        super(watcher);
        this.authManager = authManager;
        String aclZnodeParent = conf.get("zookeeper.znode.acl.parent", ACL_NODE);
        this.aclZNode = ZKUtil.joinZNode(watcher.baseZNode, aclZnodeParent);
        this.executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("zk-permission-watcher"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws KeeperException {
        block7: {
            try {
                this.watcher.registerListener(this);
                if (!ZKUtil.watchAndCheckExists(this.watcher, this.aclZNode)) break block7;
                try {
                    this.executor.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws KeeperException {
                            List<ZKUtil.NodeAndData> existing = ZKUtil.getChildDataAndWatchForNewChildren(ZKPermissionWatcher.this.watcher, ZKPermissionWatcher.this.aclZNode);
                            if (existing != null) {
                                ZKPermissionWatcher.this.refreshNodes(existing, null);
                            }
                            return null;
                        }
                    }).get();
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() instanceof KeeperException) {
                        throw (KeeperException)ex.getCause();
                    }
                    throw new RuntimeException(ex.getCause());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this.initialized.countDown();
            }
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    private void waitUntilStarted() {
        try {
            this.initialized.await();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while waiting for start", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void nodeCreated(String path) {
        this.waitUntilStarted();
        if (path.equals(this.aclZNode)) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(ZKPermissionWatcher.this.watcher, ZKPermissionWatcher.this.aclZNode);
                        ZKPermissionWatcher.this.refreshNodes(nodes, null);
                    }
                    catch (KeeperException ke) {
                        LOG.error((Object)"Error reading data from zookeeper", (Throwable)ke);
                        ZKPermissionWatcher.this.watcher.abort("Zookeeper error obtaining acl node children", ke);
                    }
                }
            });
        }
    }

    @Override
    public void nodeDeleted(final String path) {
        this.waitUntilStarted();
        if (this.aclZNode.equals(ZKUtil.getParent(path))) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    String table = ZKUtil.getNodeName(path);
                    if (AccessControlLists.isNamespaceEntry(table)) {
                        ZKPermissionWatcher.this.authManager.removeNamespace(Bytes.toBytes(table));
                    } else {
                        ZKPermissionWatcher.this.authManager.removeTable(TableName.valueOf(table));
                    }
                }
            });
        }
    }

    @Override
    public void nodeDataChanged(final String path) {
        this.waitUntilStarted();
        if (this.aclZNode.equals(ZKUtil.getParent(path))) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    String entry = ZKUtil.getNodeName(path);
                    try {
                        byte[] data = ZKUtil.getDataAndWatch(ZKPermissionWatcher.this.watcher, path);
                        ZKPermissionWatcher.this.refreshAuthManager(entry, data);
                    }
                    catch (KeeperException ke) {
                        LOG.error((Object)("Error reading data from zookeeper for node " + entry), (Throwable)ke);
                        ZKPermissionWatcher.this.watcher.abort("Zookeeper error getting data for node " + entry, ke);
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)"Error reading permissions writables", (Throwable)ioe);
                    }
                }
            });
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        this.waitUntilStarted();
        if (path.equals(this.aclZNode)) {
            try {
                List<ZKUtil.NodeAndData> nodeList = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.aclZNode);
                while (!this.nodes.compareAndSet(null, nodeList)) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Interrupted while setting node list", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error reading data from zookeeper for path " + path), (Throwable)ke);
                this.watcher.abort("Zookeeper error get node children for path " + path, ke);
            }
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    List<ZKUtil.NodeAndData> nodeList = ZKPermissionWatcher.this.nodes.get();
                    ZKPermissionWatcher.this.nodes.set(null);
                    ZKPermissionWatcher.this.refreshNodes(nodeList, ZKPermissionWatcher.this.nodes);
                }
            });
        }
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes, AtomicReference ref) {
        for (ZKUtil.NodeAndData n : nodes) {
            if (ref != null && ref.get() != null) break;
            if (n.isEmpty()) continue;
            String path = n.getNode();
            String entry = ZKUtil.getNodeName(path);
            try {
                this.refreshAuthManager(entry, n.getData());
            }
            catch (IOException ioe) {
                LOG.error((Object)("Failed parsing permissions for table '" + entry + "' from zk"), (Throwable)ioe);
            }
        }
    }

    private void refreshAuthManager(String entry, byte[] nodeData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating permissions cache from node " + entry + " with data: " + Bytes.toStringBinary(nodeData)));
        }
        if (AccessControlLists.isNamespaceEntry(entry)) {
            this.authManager.refreshNamespaceCacheFromWritable(AccessControlLists.fromNamespaceEntry(entry), nodeData);
        } else {
            this.authManager.refreshTableCacheFromWritable(TableName.valueOf(entry), nodeData);
        }
    }

    public void writeToZookeeper(byte[] entry, byte[] permsData) {
        String entryName = Bytes.toString(entry);
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, entryName);
        try {
            ZKUtil.createWithParents(this.watcher, zkNode);
            ZKUtil.updateExistingNodeData(this.watcher, zkNode, permsData, -1);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed updating permissions for entry '" + entryName + "'"), (Throwable)e);
            this.watcher.abort("Failed writing node " + zkNode + " to zookeeper", e);
        }
    }

    public void deleteTableACLNode(TableName tableName) {
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, tableName.getNameAsString());
        try {
            ZKUtil.deleteNode(this.watcher, zkNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn((Object)("No acl notify node of table '" + tableName + "'"));
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed deleting acl node of table '" + tableName + "'"), (Throwable)e);
            this.watcher.abort("Failed deleting node " + zkNode, e);
        }
    }

    public void deleteNamespaceACLNode(String namespace) {
        String zkNode = ZKUtil.joinZNode(this.watcher.baseZNode, ACL_NODE);
        zkNode = ZKUtil.joinZNode(zkNode, '@' + namespace);
        try {
            ZKUtil.deleteNode(this.watcher, zkNode);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn((Object)("No acl notify node of namespace '" + namespace + "'"));
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed deleting acl node of namespace '" + namespace + "'"), (Throwable)e);
            this.watcher.abort("Failed deleting node " + zkNode, e);
        }
    }
}

