/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class TimeRangeTracker
implements Writable {
    static final long INITIAL_MIN_TIMESTAMP = Long.MAX_VALUE;
    static final long INITIAL_MAX_TIMESTAMP = -1L;
    long minimumTimestamp = Long.MAX_VALUE;
    long maximumTimestamp = -1L;

    public TimeRangeTracker() {
    }

    public TimeRangeTracker(TimeRangeTracker trt) {
        this.set(trt.getMin(), trt.getMax());
    }

    public TimeRangeTracker(long minimumTimestamp, long maximumTimestamp) {
        this.set(minimumTimestamp, maximumTimestamp);
    }

    private void set(long min, long max) {
        this.minimumTimestamp = min;
        this.maximumTimestamp = max;
    }

    private boolean init(long l) {
        if (this.minimumTimestamp != Long.MAX_VALUE) {
            return false;
        }
        this.set(l, l);
        return true;
    }

    public void includeTimestamp(Cell cell) {
        this.includeTimestamp(cell.getTimestamp());
        if (CellUtil.isDeleteColumnOrFamily(cell)) {
            this.includeTimestamp(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"MT_CORRECTNESS"}, justification="Intentional")
    void includeTimestamp(long timestamp) {
        if (timestamp < this.minimumTimestamp) {
            TimeRangeTracker timeRangeTracker = this;
            synchronized (timeRangeTracker) {
                if (!this.init(timestamp) && timestamp < this.minimumTimestamp) {
                    this.minimumTimestamp = timestamp;
                }
            }
        }
        if (timestamp > this.maximumTimestamp) {
            TimeRangeTracker timeRangeTracker = this;
            synchronized (timeRangeTracker) {
                if (!this.init(timestamp) && this.maximumTimestamp < timestamp) {
                    this.maximumTimestamp = timestamp;
                }
            }
        }
    }

    public synchronized boolean includesTimeRange(TimeRange tr) {
        return this.minimumTimestamp < tr.getMax() && this.maximumTimestamp >= tr.getMin();
    }

    public synchronized long getMin() {
        return this.minimumTimestamp;
    }

    public synchronized long getMax() {
        return this.maximumTimestamp;
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        out.writeLong(this.minimumTimestamp);
        out.writeLong(this.maximumTimestamp);
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        this.minimumTimestamp = in.readLong();
        this.maximumTimestamp = in.readLong();
    }

    public synchronized String toString() {
        return "[" + this.minimumTimestamp + "," + this.maximumTimestamp + "]";
    }

    public static TimeRangeTracker getTimeRangeTracker(byte[] timeRangeTrackerBytes) throws IOException {
        if (timeRangeTrackerBytes == null) {
            return null;
        }
        TimeRangeTracker trt = new TimeRangeTracker();
        Writables.copyWritable(timeRangeTrackerBytes, (Writable)trt);
        return trt;
    }

    static TimeRange getTimeRange(byte[] timeRangeTrackerBytes) throws IOException {
        TimeRangeTracker trt = TimeRangeTracker.getTimeRangeTracker(timeRangeTrackerBytes);
        return trt == null ? null : trt.toTimeRange();
    }

    TimeRange toTimeRange() throws IOException {
        long min = this.getMin();
        long max = this.getMax();
        if (min == Long.MAX_VALUE) {
            min = 0L;
        }
        if (max == -1L) {
            max = Long.MAX_VALUE;
        }
        return new TimeRange(min, max);
    }
}

