/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.GeneralBulkAssigner;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class EnableTableProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.EnableTableState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(EnableTableProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private final ProcedurePrepareLatch syncLatch;
    private TableName tableName;
    private boolean skipTableStateCheck;
    private UserGroupInformation user;
    private Boolean traceEnabled = null;

    public EnableTableProcedure() {
        this.syncLatch = null;
    }

    public EnableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck) {
        this(env, tableName, skipTableStateCheck, null);
    }

    public EnableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck, ProcedurePrepareLatch syncLatch) {
        this.tableName = tableName;
        this.skipTableStateCheck = skipTableStateCheck;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
        this.syncLatch = syncLatch;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case ENABLE_TABLE_PREPARE: {
                    if (this.prepareEnable(env)) {
                        this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_PRE_OPERATION);
                        break;
                    }
                    assert (this.isFailed()) : "enable should have an exception here";
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case ENABLE_TABLE_PRE_OPERATION: {
                    this.preEnable(env, state);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_SET_ENABLING_TABLE_STATE);
                    break;
                }
                case ENABLE_TABLE_SET_ENABLING_TABLE_STATE: {
                    EnableTableProcedure.setTableStateToEnabling(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE);
                    break;
                }
                case ENABLE_TABLE_MARK_REGIONS_ONLINE: {
                    EnableTableProcedure.markRegionsOnline(env, this.tableName, true);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_SET_ENABLED_TABLE_STATE);
                    break;
                }
                case ENABLE_TABLE_SET_ENABLED_TABLE_STATE: {
                    EnableTableProcedure.setTableStateToEnabled(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_POST_OPERATION);
                    break;
                }
                case ENABLE_TABLE_POST_OPERATION: {
                    this.postEnable(env, state);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | HBaseException e) {
            LOG.error((Object)("Error trying to enable table=" + this.tableName + " state=" + state), (Throwable)e);
            this.setFailure("master-enable-table", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case ENABLE_TABLE_POST_OPERATION: {
                    break;
                }
                case ENABLE_TABLE_SET_ENABLED_TABLE_STATE: {
                    DisableTableProcedure.setTableStateToDisabling(env, this.tableName);
                    break;
                }
                case ENABLE_TABLE_MARK_REGIONS_ONLINE: {
                    this.markRegionsOfflineDuringRecovery(env);
                    break;
                }
                case ENABLE_TABLE_SET_ENABLING_TABLE_STATE: {
                    DisableTableProcedure.setTableStateToDisabled(env, this.tableName);
                    break;
                }
                case ENABLE_TABLE_PRE_OPERATION: {
                    break;
                }
                case ENABLE_TABLE_PREPARE: {
                    ProcedurePrepareLatch.releaseLatch(this.syncLatch, this);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (HBaseException e) {
            LOG.warn((Object)("Failed enable table rollback attempt step=" + state + " table=" + this.tableName), (Throwable)e);
            throw new IOException(e);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed enable table rollback attempt step=" + state + " table=" + this.tableName), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected MasterProcedureProtos.EnableTableState getState(int stateId) {
        return MasterProcedureProtos.EnableTableState.valueOf(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.EnableTableState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.EnableTableState getInitialState() {
        return MasterProcedureProtos.EnableTableState.ENABLE_TABLE_PREPARE;
    }

    @Override
    protected void setNextState(MasterProcedureProtos.EnableTableState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("Enable-table", "abort requested");
        } else {
            super.setNextState(state);
        }
    }

    @Override
    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    @Override
    protected boolean acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized(this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableExclusiveLock(this, this.tableName);
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableExclusiveLock(this, this.tableName);
    }

    @Override
    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.EnableTableStateData.Builder enableTableMsg = MasterProcedureProtos.EnableTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setTableName(ProtobufUtil.toProtoTableName(this.tableName)).setSkipTableStateCheck(this.skipTableStateCheck);
        enableTableMsg.build().writeDelimitedTo(stream);
    }

    @Override
    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.EnableTableStateData enableTableMsg = MasterProcedureProtos.EnableTableStateData.parseDelimitedFrom(stream);
        this.user = MasterProcedureUtil.toUserInfo(enableTableMsg.getUserInfo());
        this.tableName = ProtobufUtil.toTableName(enableTableMsg.getTableName());
        this.skipTableStateCheck = enableTableMsg.getSkipTableStateCheck();
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.ENABLE;
    }

    private boolean prepareEnable(MasterProcedureEnv env) throws IOException {
        boolean canTableBeEnabled = true;
        if (!MetaTableAccessor.tableExists(env.getMasterServices().getConnection(), this.tableName)) {
            this.setFailure("master-enable-table", new TableNotFoundException(this.tableName));
            canTableBeEnabled = false;
        } else if (!this.skipTableStateCheck) {
            TableStateManager tsm = env.getMasterServices().getAssignmentManager().getTableStateManager();
            if (!tsm.isTableState(this.tableName, ZooKeeperProtos.Table.State.DISABLED)) {
                LOG.info((Object)("Table " + this.tableName + " isn't disabled; skipping enable"));
                this.setFailure("master-enable-table", new TableNotDisabledException(this.tableName));
                canTableBeEnabled = false;
            }
        }
        ProcedurePrepareLatch.releaseLatch(this.syncLatch, this);
        return canTableBeEnabled;
    }

    private void preEnable(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    protected static void setTableStateToEnabling(MasterProcedureEnv env, TableName tableName) throws HBaseException, IOException {
        LOG.info((Object)("Attempting to enable the table " + tableName));
        env.getMasterServices().getAssignmentManager().getTableStateManager().setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
    }

    protected static void markRegionsOnline(MasterProcedureEnv env, TableName tableName, Boolean retryRequired) throws IOException {
        int maxTry = retryRequired != false ? 10 : 1;
        boolean done = false;
        do {
            try {
                done = EnableTableProcedure.markRegionsOnline(env, tableName);
                if (done) break;
                --maxTry;
            }
            catch (Exception e) {
                LOG.warn((Object)("Received exception while marking regions online. tries left: " + maxTry), (Throwable)e);
                if (--maxTry > 0) continue;
                throw e;
            }
        } while (maxTry > 0);
        if (!done) {
            LOG.warn((Object)("Some or all regions of the Table '" + tableName + "' were offline"));
        }
    }

    private static boolean markRegionsOnline(MasterProcedureEnv env, TableName tableName) throws IOException {
        AssignmentManager assignmentManager = env.getMasterServices().getAssignmentManager();
        MasterServices masterServices = env.getMasterServices();
        ServerManager serverManager = masterServices.getServerManager();
        boolean done = false;
        List<Pair<HRegionInfo, ServerName>> tableRegionsAndLocations = TableName.META_TABLE_NAME.equals(tableName) ? new MetaTableLocator().getMetaRegionsAndLocations(masterServices.getZooKeeper()) : MetaTableAccessor.getTableRegionsAndLocations(masterServices.getZooKeeper(), masterServices.getConnection(), tableName, true);
        int countOfRegionsInTable = tableRegionsAndLocations.size();
        Map<HRegionInfo, ServerName> regionsToAssign = EnableTableProcedure.regionsToAssignWithServerName(env, tableRegionsAndLocations);
        List<HRegionInfo> unrecordedReplicas = AssignmentManager.replicaRegionsNotRecordedInMeta(new HashSet<HRegionInfo>(regionsToAssign.keySet()), masterServices);
        Map<ServerName, List<HRegionInfo>> srvToUnassignedRegs = assignmentManager.getBalancer().roundRobinAssignment(unrecordedReplicas, serverManager.getOnlineServersList());
        if (srvToUnassignedRegs != null) {
            for (Map.Entry<ServerName, List<HRegionInfo>> entry : srvToUnassignedRegs.entrySet()) {
                for (HRegionInfo h : entry.getValue()) {
                    regionsToAssign.put(h, entry.getKey());
                }
            }
        }
        int offlineRegionsCount = regionsToAssign.size();
        LOG.info((Object)("Table '" + tableName + "' has " + countOfRegionsInTable + " regions, of which " + offlineRegionsCount + " are offline."));
        if (offlineRegionsCount == 0) {
            return true;
        }
        List<ServerName> onlineServers = serverManager.createDestinationServersList();
        Map<ServerName, List<HRegionInfo>> bulkPlan = env.getMasterServices().getAssignmentManager().getBalancer().retainAssignment(regionsToAssign, onlineServers);
        if (bulkPlan != null) {
            LOG.info((Object)("Bulk assigning " + offlineRegionsCount + " region(s) across " + bulkPlan.size() + " server(s), retainAssignment=true"));
            GeneralBulkAssigner ba = new GeneralBulkAssigner(masterServices, bulkPlan, assignmentManager, true);
            try {
                if (ba.bulkAssign()) {
                    done = true;
                }
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Enable operation was interrupted when enabling table '" + tableName + "'"));
                Thread.currentThread().interrupt();
            }
        } else {
            LOG.info((Object)("Balancer was unable to find suitable servers for table " + tableName + ", leaving unassigned"));
        }
        return done;
    }

    private void markRegionsOfflineDuringRecovery(MasterProcedureEnv env) {
        try {
            DisableTableProcedure.markRegionsOffline(env, this.tableName, true);
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to offline all regions of table " + this.tableName + ". Ignoring"), (Throwable)e);
        }
    }

    protected static void setTableStateToEnabled(MasterProcedureEnv env, TableName tableName) throws HBaseException, IOException {
        env.getMasterServices().getAssignmentManager().getTableStateManager().setTableState(tableName, ZooKeeperProtos.Table.State.ENABLED);
        LOG.info((Object)("Table '" + tableName + "' was successfully enabled."));
    }

    private void postEnable(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private static Map<HRegionInfo, ServerName> regionsToAssignWithServerName(MasterProcedureEnv env, List<Pair<HRegionInfo, ServerName>> regionsInMeta) throws IOException {
        HashMap<HRegionInfo, ServerName> regionsToAssign = new HashMap<HRegionInfo, ServerName>(regionsInMeta.size());
        RegionStates regionStates = env.getMasterServices().getAssignmentManager().getRegionStates();
        for (Pair<HRegionInfo, ServerName> regionLocation : regionsInMeta) {
            HRegionInfo hri = regionLocation.getFirst();
            ServerName sn = regionLocation.getSecond();
            if (regionStates.isRegionOffline(hri)) {
                regionsToAssign.put(hri, sn);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping assign for the region " + hri + " during enable table " + hri.getTable() + " because its already in tranition or assigned."));
        }
        return regionsToAssign;
    }

    private void runCoprocessorAction(MasterProcedureEnv env, final MasterProcedureProtos.EnableTableState state) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            this.user.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    switch (state) {
                        case ENABLE_TABLE_PRE_OPERATION: {
                            cpHost.preEnableTableHandler(EnableTableProcedure.this.getTableName());
                            break;
                        }
                        case ENABLE_TABLE_POST_OPERATION: {
                            cpHost.postEnableTableHandler(EnableTableProcedure.this.getTableName());
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(this + " unhandled state=" + state);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

