/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class ContainerManagementProtocolProxy {
    static final Log LOG = LogFactory.getLog(ContainerManagementProtocolProxy.class);
    private final int maxConnectedNMs;
    private final LinkedHashMap<String, ContainerManagementProtocolProxyData> cmProxy;
    private final Configuration conf;
    private final YarnRPC rpc;
    private NMTokenCache nmTokenCache;

    public ContainerManagementProtocolProxy(Configuration conf) {
        this(conf, NMTokenCache.getSingleton());
    }

    public ContainerManagementProtocolProxy(Configuration conf, NMTokenCache nmTokenCache) {
        this.conf = conf;
        this.nmTokenCache = nmTokenCache;
        this.maxConnectedNMs = conf.getInt("yarn.client.max-nodemanagers-proxies", 500);
        if (this.maxConnectedNMs < 1) {
            throw new YarnRuntimeException("yarn.client.max-nodemanagers-proxies (" + this.maxConnectedNMs + ") can not be less than 1.");
        }
        LOG.info((Object)("yarn.client.max-nodemanagers-proxies : " + this.maxConnectedNMs));
        this.cmProxy = new LinkedHashMap();
        this.rpc = YarnRPC.create(conf);
    }

    public synchronized ContainerManagementProtocolProxyData getProxy(String containerManagerBindAddr, ContainerId containerId) throws SecretManager.InvalidToken {
        ContainerManagementProtocolProxyData proxy = this.cmProxy.get(containerManagerBindAddr);
        while (proxy != null && !proxy.token.getIdentifier().equals(this.nmTokenCache.getToken(containerManagerBindAddr).getIdentifier())) {
            LOG.info((Object)("Refreshing proxy as NMToken got updated for node : " + containerManagerBindAddr));
            if (!proxy.scheduledForClose) {
                this.removeProxy(proxy);
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (proxy.activeCallers >= 0) continue;
            proxy = this.cmProxy.get(containerManagerBindAddr);
        }
        if (proxy == null) {
            proxy = new ContainerManagementProtocolProxyData(this.rpc, containerManagerBindAddr, containerId, this.nmTokenCache.getToken(containerManagerBindAddr));
            if (this.cmProxy.size() > this.maxConnectedNMs) {
                String cmAddr = this.cmProxy.keySet().iterator().next();
                this.removeProxy(this.cmProxy.get(cmAddr));
            }
            this.cmProxy.put(containerManagerBindAddr, proxy);
        }
        proxy.activeCallers++;
        this.updateLRUCache(containerManagerBindAddr);
        return proxy;
    }

    private void updateLRUCache(String containerManagerBindAddr) {
        ContainerManagementProtocolProxyData proxy = (ContainerManagementProtocolProxyData)this.cmProxy.remove(containerManagerBindAddr);
        this.cmProxy.put(containerManagerBindAddr, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mayBeCloseProxy(ContainerManagementProtocolProxyData proxy) {
        proxy.activeCallers--;
        if (proxy.scheduledForClose && proxy.activeCallers < 0) {
            LOG.info((Object)("Closing proxy : " + proxy.containerManagerBindAddr));
            this.cmProxy.remove(proxy.containerManagerBindAddr);
            try {
                this.rpc.stopProxy(proxy.getContainerManagementProtocol(), this.conf);
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private synchronized void removeProxy(ContainerManagementProtocolProxyData proxy) {
        if (!proxy.scheduledForClose) {
            proxy.scheduledForClose = true;
            this.mayBeCloseProxy(proxy);
        }
    }

    public synchronized void stopAllProxies() {
        ArrayList<String> nodeIds = new ArrayList<String>();
        nodeIds.addAll(this.cmProxy.keySet());
        for (String nodeId : nodeIds) {
            ContainerManagementProtocolProxyData proxy = this.cmProxy.get(nodeId);
            proxy.activeCallers = 0;
            try {
                this.removeProxy(proxy);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error closing connection", t);
            }
        }
        this.cmProxy.clear();
    }

    public class ContainerManagementProtocolProxyData {
        private final String containerManagerBindAddr;
        private final ContainerManagementProtocol proxy;
        private int activeCallers;
        private boolean scheduledForClose;
        private final org.apache.hadoop.yarn.api.records.Token token;

        @InterfaceAudience.Private
        @VisibleForTesting
        public ContainerManagementProtocolProxyData(YarnRPC rpc, String containerManagerBindAddr, ContainerId containerId, org.apache.hadoop.yarn.api.records.Token token) throws SecretManager.InvalidToken {
            this.containerManagerBindAddr = containerManagerBindAddr;
            this.activeCallers = 0;
            this.scheduledForClose = false;
            this.token = token;
            this.proxy = this.newProxy(rpc, containerManagerBindAddr, containerId, token);
        }

        @InterfaceAudience.Private
        @VisibleForTesting
        protected ContainerManagementProtocol newProxy(final YarnRPC rpc, String containerManagerBindAddr, ContainerId containerId, org.apache.hadoop.yarn.api.records.Token token) throws SecretManager.InvalidToken {
            if (token == null) {
                throw new SecretManager.InvalidToken("No NMToken sent for " + containerManagerBindAddr);
            }
            final InetSocketAddress cmAddr = NetUtils.createSocketAddr(containerManagerBindAddr);
            LOG.info((Object)("Opening proxy : " + containerManagerBindAddr));
            UserGroupInformation user = UserGroupInformation.createRemoteUser(containerId.getApplicationAttemptId().toString());
            Token nmToken = ConverterUtils.convertFromYarn(token, cmAddr);
            user.addToken(nmToken);
            ContainerManagementProtocol proxy = user.doAs(new PrivilegedAction<ContainerManagementProtocol>(){

                @Override
                public ContainerManagementProtocol run() {
                    return (ContainerManagementProtocol)rpc.getProxy(ContainerManagementProtocol.class, cmAddr, ContainerManagementProtocolProxy.this.conf);
                }
            });
            return proxy;
        }

        public ContainerManagementProtocol getContainerManagementProtocol() {
            return this.proxy;
        }
    }
}

