/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.server.JNStorage;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeHttpServer;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.ImageServlet;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class GetJournalEditServlet
extends HttpServlet {
    private static final long serialVersionUID = -4635891628211723009L;
    private static final Log LOG = LogFactory.getLog(GetJournalEditServlet.class);
    static final String STORAGEINFO_PARAM = "storageInfo";
    static final String JOURNAL_ID_PARAM = "jid";
    static final String SEGMENT_TXID_PARAM = "segmentTxId";

    protected boolean isValidRequestor(HttpServletRequest request, Configuration conf) throws IOException {
        String remotePrincipal = request.getUserPrincipal().getName();
        String remoteShortName = request.getRemoteUser();
        if (remotePrincipal == null) {
            LOG.warn((Object)"Received null remoteUser while authorizing access to GetJournalEditServlet");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Validating request made by " + remotePrincipal + " / " + remoteShortName + ". This user is: " + UserGroupInformation.getLoginUser()));
        }
        HashSet<String> validRequestors = new HashSet<String>();
        validRequestors.addAll(DFSUtil.getAllNnPrincipals(conf));
        validRequestors.add(SecurityUtil.getServerPrincipal(conf.get("dfs.secondary.namenode.kerberos.principal"), SecondaryNameNode.getHttpAddress(conf).getHostName()));
        for (String v : validRequestors) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isValidRequestor is comparing to valid requestor: " + v));
            }
            if (v == null || !v.equals(remotePrincipal)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isValidRequestor is allowing: " + remotePrincipal));
            }
            return true;
        }
        if (remoteShortName.equals(UserGroupInformation.getLoginUser().getShortUserName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isValidRequestor is allowing other JN principal: " + remotePrincipal));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isValidRequestor is rejecting: " + remotePrincipal));
        }
        return false;
    }

    private boolean checkRequestorOrSendError(Configuration conf, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (UserGroupInformation.isSecurityEnabled() && !this.isValidRequestor(request, conf)) {
            response.sendError(403, "Only Namenode and another JournalNode may access this servlet");
            LOG.warn((Object)("Received non-NN/JN request for edits from " + request.getRemoteHost()));
            return false;
        }
        return true;
    }

    private boolean checkStorageInfoOrSendError(JNStorage storage, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int myNsId = storage.getNamespaceID();
        String myClusterId = storage.getClusterID();
        String theirStorageInfoString = StringEscapeUtils.escapeHtml(request.getParameter(STORAGEINFO_PARAM));
        if (theirStorageInfoString != null) {
            int theirNsId = StorageInfo.getNsIdFromColonSeparatedString(theirStorageInfoString);
            String theirClusterId = StorageInfo.getClusterIdFromColonSeparatedString(theirStorageInfoString);
            if (myNsId != theirNsId || !myClusterId.equals(theirClusterId)) {
                String msg = "This node has namespaceId '" + myNsId + " and clusterId '" + myClusterId + "' but the requesting node expected '" + theirNsId + "' and '" + theirClusterId + "'";
                response.sendError(403, msg);
                LOG.warn((Object)("Received an invalid request file transfer request from " + request.getRemoteAddr() + ": " + msg));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileJournalManager.EditLogFile elf;
        Configuration conf;
        FileInputStream editFileIn;
        block12: {
            FileJournalManager fjm;
            JNStorage storage;
            block11: {
                block10: {
                    editFileIn = null;
                    ServletContext context = this.getServletContext();
                    conf = (Configuration)this.getServletContext().getAttribute("current.conf");
                    String journalId = request.getParameter(JOURNAL_ID_PARAM);
                    QuorumJournalManager.checkJournalId(journalId);
                    storage = JournalNodeHttpServer.getJournalFromContext(context, journalId).getStorage();
                    if (this.checkRequestorOrSendError(conf, request, response)) break block10;
                    IOUtils.closeStream(editFileIn);
                    return;
                }
                if (this.checkStorageInfoOrSendError(storage, request, response)) break block11;
                IOUtils.closeStream(editFileIn);
                return;
            }
            long segmentTxId = ServletUtil.parseLongParam((ServletRequest)request, SEGMENT_TXID_PARAM);
            FileJournalManager fileJournalManager = fjm = storage.getJournalManager();
            // MONITORENTER : fileJournalManager
            elf = fjm.getLogFile(segmentTxId);
            if (elf != null) break block12;
            response.sendError(404, "No edit log found starting at txid " + segmentTxId);
            // MONITOREXIT : fileJournalManager
            IOUtils.closeStream(editFileIn);
            return;
        }
        try {
            File editFile = elf.getFile();
            ImageServlet.setVerificationHeadersForGet(response, editFile);
            ImageServlet.setFileNameHeaders(response, editFile);
            editFileIn = new FileInputStream(editFile);
            // MONITOREXIT : fileJournalManager
            DataTransferThrottler throttler = ImageServlet.getThrottler(conf);
            TransferFsImage.copyFileToStream((OutputStream)response.getOutputStream(), editFile, editFileIn, throttler);
        }
        catch (Throwable t) {
            try {
                String errMsg = "getedit failed. " + StringUtils.stringifyException(t);
                response.sendError(500, errMsg);
                throw new IOException(errMsg);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(editFileIn);
                throw throwable;
            }
        }
        IOUtils.closeStream(editFileIn);
        return;
    }

    public static String buildPath(String journalId, long segmentTxId, NamespaceInfo nsInfo) {
        StringBuilder path = new StringBuilder("/getJournal?");
        try {
            path.append(JOURNAL_ID_PARAM).append("=").append(URLEncoder.encode(journalId, "UTF-8"));
            path.append("&segmentTxId").append("=").append(segmentTxId);
            path.append("&storageInfo").append("=").append(URLEncoder.encode(nsInfo.toColonSeparatedString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return path.toString();
    }
}

