/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.GnuParser;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.OptionBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class RegionSplitter {
    private static final Log LOG = LogFactory.getLog(RegionSplitter.class);

    public static void main(String[] args) throws IOException, InterruptedException, ParseException {
        Configuration conf = HBaseConfiguration.create();
        Options opt = new Options();
        OptionBuilder.withArgName("property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Override HBase Configuration Settings");
        opt.addOption(OptionBuilder.create("D"));
        OptionBuilder.withArgName("region count");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Create a new table with a pre-split number of regions");
        opt.addOption(OptionBuilder.create("c"));
        OptionBuilder.withArgName("family:family:...");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Column Families to create with new table.  Required with -c");
        opt.addOption(OptionBuilder.create("f"));
        opt.addOption("h", false, "Print this usage help");
        opt.addOption("r", false, "Perform a rolling split of an existing region");
        OptionBuilder.withArgName("count");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Max outstanding splits that have unfinished major compactions");
        opt.addOption(OptionBuilder.create("o"));
        opt.addOption(null, "firstrow", true, "First Row in Table for Split Algorithm");
        opt.addOption(null, "lastrow", true, "Last Row in Table for Split Algorithm");
        opt.addOption(null, "risky", false, "Skip verification steps to complete quickly.STRONGLY DISCOURAGED for production systems.  ");
        CommandLine cmd = new GnuParser().parse(opt, args);
        if (cmd.hasOption("D")) {
            for (String confOpt : cmd.getOptionValues("D")) {
                String[] kv = confOpt.split("=", 2);
                if (kv.length != 2) {
                    throw new ParseException("-D option format invalid: " + confOpt);
                }
                conf.set(kv[0], kv[1]);
                LOG.debug((Object)("-D configuration override: " + kv[0] + "=" + kv[1]));
            }
        }
        if (cmd.hasOption("risky")) {
            conf.setBoolean("split.verify", false);
        }
        boolean createTable = cmd.hasOption("c") && cmd.hasOption("f");
        boolean rollingSplit = cmd.hasOption("r");
        boolean oneOperOnly = createTable ^ rollingSplit;
        if (2 != cmd.getArgList().size() || !oneOperOnly || cmd.hasOption("h")) {
            new HelpFormatter().printHelp("RegionSplitter <TABLE> <SPLITALGORITHM>\nSPLITALGORITHM is a java class name of a class implementing SplitAlgorithm, or one of the special strings HexStringSplit or UniformSplit, which are built-in split algorithms. HexStringSplit treats keys as hexadecimal ASCII, and UniformSplit treats keys as arbitrary bytes.", opt);
            return;
        }
        TableName tableName = TableName.valueOf(cmd.getArgs()[0]);
        String splitClass = cmd.getArgs()[1];
        SplitAlgorithm splitAlgo = RegionSplitter.newSplitAlgoInstance(conf, splitClass);
        if (cmd.hasOption("firstrow")) {
            splitAlgo.setFirstRow(cmd.getOptionValue("firstrow"));
        }
        if (cmd.hasOption("lastrow")) {
            splitAlgo.setLastRow(cmd.getOptionValue("lastrow"));
        }
        if (createTable) {
            conf.set("split.count", cmd.getOptionValue("c"));
            RegionSplitter.createPresplitTable(tableName, splitAlgo, cmd.getOptionValue("f").split(":"), conf);
        }
        if (rollingSplit) {
            if (cmd.hasOption("o")) {
                conf.set("split.outstanding", cmd.getOptionValue("o"));
            }
            RegionSplitter.rollingSplit(tableName, splitAlgo, conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createPresplitTable(TableName tableName, SplitAlgorithm splitAlgo, String[] columnFamilies, Configuration conf) throws IOException, InterruptedException {
        int splitCount = conf.getInt("split.count", 0);
        Preconditions.checkArgument(splitCount > 1, "Split count must be > 1");
        Preconditions.checkArgument(columnFamilies.length > 0, "Must specify at least one column family. ");
        LOG.debug((Object)("Creating table " + tableName + " with " + columnFamilies.length + " column families.  Presplitting to " + splitCount + " regions"));
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (String cf : columnFamilies) {
            desc.addFamily(new HColumnDescriptor(Bytes.toBytes(cf)));
        }
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            try (Admin admin = connection.getAdmin();){
                Preconditions.checkArgument(!admin.tableExists(tableName), "Table already exists: " + tableName);
                admin.createTable(desc, splitAlgo.split(splitCount));
            }
            LOG.debug((Object)"Table created!  Waiting for regions to show online in META...");
            if (!conf.getBoolean("split.verify", true)) {
                int onlineRegions = 0;
                while (onlineRegions < splitCount) {
                    onlineRegions = MetaTableAccessor.getRegionCount(connection, tableName);
                    LOG.debug((Object)(onlineRegions + " of " + splitCount + " regions online..."));
                    if (onlineRegions >= splitCount) continue;
                    Thread.sleep(10000L);
                }
            }
            LOG.debug((Object)("Finished creating table with " + splitCount + " regions"));
        }
    }

    private static int getRegionServerCount(Connection connection) throws IOException {
        try (Admin admin = connection.getAdmin();){
            ClusterStatus status = admin.getClusterStatus();
            Collection<ServerName> servers = status.getServers();
            int n = servers == null || servers.isEmpty() ? 0 : servers.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(FileSystem fs, Path path) throws IOException {
        try (FSDataInputStream tmpIn = fs.open(path);){
            byte[] rawData = new byte[tmpIn.available()];
            tmpIn.readFully(rawData);
            byte[] byArray = rawData;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rollingSplit(TableName tableName, SplitAlgorithm splitAlgo, Configuration conf) throws IOException, InterruptedException {
        int minOS = conf.getInt("split.outstanding", 2);
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            int MAX_OUTSTANDING = Math.max(RegionSplitter.getRegionServerCount(connection) / 2, minOS);
            Path hbDir = FSUtils.getRootDir(conf);
            Path tableDir = FSUtils.getTableDir(hbDir, tableName);
            Path splitFile = new Path(tableDir, "_balancedSplit");
            FileSystem fs = FileSystem.get(conf);
            LinkedList<Pair<byte[], byte[]>> tmpRegionSet = null;
            try (Table table = connection.getTable(tableName);){
                tmpRegionSet = RegionSplitter.getSplits(connection, tableName, splitAlgo);
            }
            LinkedList<Pair<byte[], byte[]>> outstanding = Lists.newLinkedList();
            int splitCount = 0;
            int origCount = tmpRegionSet.size();
            LOG.debug((Object)"Bucketing regions by regionserver...");
            TreeMap daughterRegions = Maps.newTreeMap();
            try (RegionLocator regionLocator = connection.getRegionLocator(tableName);){
                for (Pair pair : tmpRegionSet) {
                    String rsLocation = regionLocator.getRegionLocation((byte[])pair.getSecond()).getHostnamePort();
                    if (!daughterRegions.containsKey(rsLocation)) {
                        LinkedList entry = Lists.newLinkedList();
                        daughterRegions.put(rsLocation, entry);
                    }
                    ((LinkedList)daughterRegions.get(rsLocation)).add(pair);
                }
                LOG.debug((Object)"Done with bucketing.  Split time!");
                long startTime = System.currentTimeMillis();
                byte[] rawData = RegionSplitter.readFile(fs, splitFile);
                FSDataOutputStream splitOut = fs.create(splitFile);
                try {
                    splitOut.write(rawData);
                    try {
                        while (!daughterRegions.isEmpty()) {
                            LOG.debug((Object)(daughterRegions.size() + " RS have regions to splt."));
                            final TreeMap<ServerName, Integer> rsSizes = Maps.newTreeMap();
                            List<HRegionLocation> hrls = regionLocator.getAllRegionLocations();
                            for (HRegionLocation hrl : hrls) {
                                ServerName sn = hrl.getServerName();
                                if (rsSizes.containsKey(sn)) {
                                    rsSizes.put(sn, (Integer)rsSizes.get(sn) + 1);
                                    continue;
                                }
                                rsSizes.put(sn, 1);
                            }
                            ArrayList<String> arrayList = Lists.newArrayList(daughterRegions.keySet());
                            Collections.sort(arrayList, new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return ((Integer)rsSizes.get(o1)).compareTo((Integer)rsSizes.get(o2));
                                }
                            });
                            for (String rsLoc : arrayList) {
                                Object newRs;
                                byte[] split;
                                Pair dr = null;
                                LOG.debug((Object)("Finding a region on " + rsLoc));
                                LinkedList regionList = (LinkedList)daughterRegions.get(rsLoc);
                                while (!regionList.isEmpty()) {
                                    dr = (Pair)regionList.pop();
                                    split = (byte[])dr.getSecond();
                                    HRegionLocation regionLoc = regionLocator.getRegionLocation(split);
                                    newRs = regionLoc.getHostnamePort();
                                    if (((String)newRs).compareTo(rsLoc) != 0) {
                                        LOG.debug((Object)("Region with " + splitAlgo.rowToStr(split) + " moved to " + (String)newRs + ". Relocating..."));
                                        if (!daughterRegions.containsKey(newRs)) {
                                            LinkedList entry = Lists.newLinkedList();
                                            daughterRegions.put(newRs, entry);
                                        }
                                        ((LinkedList)daughterRegions.get(newRs)).add(dr);
                                        dr = null;
                                        continue;
                                    }
                                    byte[] sk = regionLoc.getRegionInfo().getStartKey();
                                    if (sk.length == 0) break;
                                    if (Bytes.equals(split, sk)) {
                                        LOG.debug((Object)("Region already split on " + splitAlgo.rowToStr(split) + ".  Skipping this region..."));
                                        ++splitCount;
                                        dr = null;
                                        continue;
                                    }
                                    byte[] byArray = (byte[])dr.getFirst();
                                    Preconditions.checkArgument(Bytes.equals(byArray, sk), splitAlgo.rowToStr(byArray) + " != " + splitAlgo.rowToStr(sk));
                                    break;
                                }
                                if (regionList.isEmpty()) {
                                    daughterRegions.remove(rsLoc);
                                }
                                if (dr == null) continue;
                                split = (byte[])dr.getSecond();
                                LOG.debug((Object)("Splitting at " + splitAlgo.rowToStr(split)));
                                Admin admin = connection.getAdmin();
                                newRs = null;
                                try {
                                    admin.split(tableName, split);
                                }
                                catch (Throwable x2) {
                                    newRs = x2;
                                    throw x2;
                                }
                                finally {
                                    if (admin != null) {
                                        if (newRs != null) {
                                            try {
                                                admin.close();
                                            }
                                            catch (Throwable x2) {
                                                ((Throwable)newRs).addSuppressed(x2);
                                            }
                                        } else {
                                            admin.close();
                                        }
                                    }
                                }
                                LinkedList<Object> finished = Lists.newLinkedList();
                                LinkedList<Object> local_finished = Lists.newLinkedList();
                                if (conf.getBoolean("split.verify", true)) {
                                    outstanding.addLast(dr);
                                    while (outstanding.size() >= MAX_OUTSTANDING) {
                                        LOG.debug((Object)("Wait for outstanding splits " + outstanding.size()));
                                        local_finished = RegionSplitter.splitScan(outstanding, connection, tableName, splitAlgo);
                                        if (local_finished.isEmpty()) {
                                            Thread.sleep(30000L);
                                            continue;
                                        }
                                        finished.addAll(local_finished);
                                        outstanding.removeAll(local_finished);
                                        LOG.debug((Object)(local_finished.size() + " outstanding splits finished"));
                                    }
                                } else {
                                    finished.add(dr);
                                }
                                for (Pair pair : finished) {
                                    splitOut.writeChars("- " + splitAlgo.rowToStr((byte[])pair.getFirst()) + " " + splitAlgo.rowToStr((byte[])pair.getSecond()) + "\n");
                                    if (++splitCount % 10 != 0) continue;
                                    long tDiff = (System.currentTimeMillis() - startTime) / (long)splitCount;
                                    LOG.debug((Object)("STATUS UPDATE: " + splitCount + " / " + origCount + ". Avg Time / Split = " + org.apache.hadoop.util.StringUtils.formatTime(tDiff)));
                                }
                            }
                        }
                        if (conf.getBoolean("split.verify", true)) {
                            while (!outstanding.isEmpty()) {
                                LOG.debug((Object)("Finally Wait for outstanding splits " + outstanding.size()));
                                LinkedList<Pair<byte[], byte[]>> finished = RegionSplitter.splitScan(outstanding, connection, tableName, splitAlgo);
                                if (finished.isEmpty()) {
                                    Thread.sleep(30000L);
                                    continue;
                                }
                                outstanding.removeAll(finished);
                                for (Pair pair : finished) {
                                    splitOut.writeChars("- " + splitAlgo.rowToStr((byte[])pair.getFirst()) + " " + splitAlgo.rowToStr((byte[])pair.getSecond()) + "\n");
                                    ++splitCount;
                                }
                                LOG.debug((Object)("Finally " + finished.size() + " outstanding splits finished"));
                            }
                        }
                        LOG.debug((Object)"All regions have been successfully split!");
                    }
                    finally {
                        long tDiff = System.currentTimeMillis() - startTime;
                        LOG.debug((Object)("TOTAL TIME = " + org.apache.hadoop.util.StringUtils.formatTime(tDiff)));
                        LOG.debug((Object)("Splits = " + splitCount));
                        if (0 < splitCount) {
                            LOG.debug((Object)("Avg Time / Split = " + org.apache.hadoop.util.StringUtils.formatTime(tDiff / (long)splitCount)));
                        }
                    }
                }
                finally {
                    splitOut.close();
                    fs.delete(splitFile, false);
                }
            }
        }
    }

    public static SplitAlgorithm newSplitAlgoInstance(Configuration conf, String splitClassName) throws IOException {
        Class splitClass;
        if (splitClassName.equals(HexStringSplit.class.getSimpleName())) {
            splitClass = HexStringSplit.class;
        } else if (splitClassName.equals(UniformSplit.class.getSimpleName())) {
            splitClass = UniformSplit.class;
        } else {
            try {
                splitClass = conf.getClassByName(splitClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Couldn't load split class " + splitClassName, e);
            }
            if (splitClass == null) {
                throw new IOException("Failed loading split class " + splitClassName);
            }
            if (!SplitAlgorithm.class.isAssignableFrom(splitClass)) {
                throw new IOException("Specified split class doesn't implement SplitAlgorithm");
            }
        }
        try {
            return splitClass.asSubclass(SplitAlgorithm.class).newInstance();
        }
        catch (Exception e) {
            throw new IOException("Problem loading split algorithm: ", e);
        }
    }

    static LinkedList<Pair<byte[], byte[]>> splitScan(LinkedList<Pair<byte[], byte[]>> regionList, Connection connection, TableName tableName, SplitAlgorithm splitAlgo) throws IOException, InterruptedException {
        LinkedList<Pair<byte[], byte[]>> finished = Lists.newLinkedList();
        LinkedList<Pair> logicalSplitting = Lists.newLinkedList();
        LinkedList<Pair> physicalSplitting = Lists.newLinkedList();
        Pair<Path, Path> tableDirAndSplitFile = RegionSplitter.getTableDirAndSplitFile(connection.getConfiguration(), tableName);
        Path tableDir = tableDirAndSplitFile.getFirst();
        FileSystem fs = tableDir.getFileSystem(connection.getConfiguration());
        ((ClusterConnection)connection).clearRegionCache();
        HTableDescriptor htd = null;
        try (Table table = connection.getTable(tableName);){
            htd = table.getTableDescriptor();
        }
        var12_12 = null;
        try (RegionLocator regionLocator = connection.getRegionLocator(tableName);){
            for (Pair pair : regionList) {
                byte[] split;
                byte[] start;
                block35: {
                    start = (byte[])pair.getFirst();
                    split = (byte[])pair.getSecond();
                    try {
                        HRegionInfo dri = regionLocator.getRegionLocation(split).getRegionInfo();
                        if (dri.isOffline() || !Bytes.equals(dri.getStartKey(), split)) {
                            logicalSplitting.add(pair);
                        }
                        break block35;
                    }
                    catch (NoServerForRegionException nsfre) {
                        LOG.info((Object)nsfre);
                        logicalSplitting.add(pair);
                    }
                    continue;
                }
                try {
                    LinkedList<HRegionInfo> check = Lists.newLinkedList();
                    check.add(regionLocator.getRegionLocation(start).getRegionInfo());
                    check.add(regionLocator.getRegionLocation(split).getRegionInfo());
                    for (HRegionInfo hri : check.toArray(new HRegionInfo[check.size()])) {
                        HColumnDescriptor c;
                        byte[] sk = hri.getStartKey();
                        if (sk.length == 0) {
                            sk = splitAlgo.firstRow();
                        }
                        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(connection.getConfiguration(), fs, tableDir, hri, true);
                        boolean refFound = false;
                        Iterator<HColumnDescriptor> i$ = htd.getFamilies().iterator();
                        while (i$.hasNext() && !(refFound = regionFs.hasReferences((c = i$.next()).getNameAsString()))) {
                        }
                        if (refFound) continue;
                        check.remove(hri);
                    }
                    if (check.isEmpty()) {
                        finished.add(pair);
                        continue;
                    }
                    physicalSplitting.add(pair);
                }
                catch (NoServerForRegionException nsfre) {
                    LOG.debug((Object)("No Server Exception thrown for: " + splitAlgo.rowToStr(start)));
                    physicalSplitting.add(pair);
                    ((ClusterConnection)connection).clearRegionCache();
                }
            }
            LOG.debug((Object)("Split Scan: " + finished.size() + " finished / " + logicalSplitting.size() + " split wait / " + physicalSplitting.size() + " reference wait"));
            LinkedList<Pair<byte[], byte[]>> linkedList = finished;
            return linkedList;
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
    }

    private static Pair<Path, Path> getTableDirAndSplitFile(Configuration conf, TableName tableName) throws IOException {
        Path hbDir = FSUtils.getRootDir(conf);
        Path tableDir = FSUtils.getTableDir(hbDir, tableName);
        Path splitFile = new Path(tableDir, "_balancedSplit");
        return new Pair<Path, Path>(tableDir, splitFile);
    }

    /*
     * WARNING - void declaration
     */
    static LinkedList<Pair<byte[], byte[]>> getSplits(Connection connection, TableName tableName, SplitAlgorithm splitAlgo) throws IOException {
        Pair<Path, Path> tableDirAndSplitFile = RegionSplitter.getTableDirAndSplitFile(connection.getConfiguration(), tableName);
        Path tableDir = tableDirAndSplitFile.getFirst();
        Path splitFile = tableDirAndSplitFile.getSecond();
        FileSystem fs = tableDir.getFileSystem(connection.getConfiguration());
        HashSet<Pair<String, String>> daughterRegions = Sets.newHashSet();
        if (!fs.exists(splitFile)) {
            void var10_12;
            LOG.debug((Object)("No " + splitFile.getName() + " file. Calculating splits "));
            HashSet<Pair<byte[], byte[]>> rows = Sets.newHashSet();
            Pair<byte[][], byte[][]> tmp = null;
            try (RegionLocator regionLocator = connection.getRegionLocator(tableName);){
                tmp = regionLocator.getStartEndKeys();
            }
            Preconditions.checkArgument(tmp.getFirst().length == tmp.getSecond().length, "Start and End rows should be equivalent");
            boolean bl = false;
            while (var10_12 < tmp.getFirst().length) {
                byte[] start = tmp.getFirst()[var10_12];
                byte[] end = tmp.getSecond()[var10_12];
                if (start.length == 0) {
                    start = splitAlgo.firstRow();
                }
                if (end.length == 0) {
                    end = splitAlgo.lastRow();
                }
                rows.add(Pair.newPair(start, end));
                ++var10_12;
            }
            LOG.debug((Object)("Table " + tableName + " has " + rows.size() + " regions that will be split."));
            Path path = new Path(tableDir, "_balancedSplit_prepare");
            FSDataOutputStream tmpOut = fs.create(path);
            for (Pair pair : rows) {
                byte[] splitPoint = splitAlgo.split((byte[])pair.getFirst(), (byte[])pair.getSecond());
                String startStr = splitAlgo.rowToStr((byte[])pair.getFirst());
                String splitStr = splitAlgo.rowToStr(splitPoint);
                daughterRegions.add(Pair.newPair(startStr, splitStr));
                LOG.debug((Object)("Will Split [" + startStr + " , " + splitAlgo.rowToStr((byte[])pair.getSecond()) + ") at " + splitStr));
                tmpOut.writeChars("+ " + startStr + splitAlgo.separator() + splitStr + "\n");
            }
            tmpOut.close();
            fs.rename(path, splitFile);
        } else {
            LOG.debug((Object)"_balancedSplit file found. Replay log to restore state...");
            FSUtils.getInstance(fs, connection.getConfiguration()).recoverFileLease(fs, splitFile, connection.getConfiguration(), null);
            FSDataInputStream tmpIn = fs.open(splitFile);
            StringBuilder sb = new StringBuilder(tmpIn.available());
            while (tmpIn.available() > 0) {
                sb.append(tmpIn.readChar());
            }
            tmpIn.close();
            for (String string : sb.toString().split("\n")) {
                String[] cmd = string.split(splitAlgo.separator());
                Preconditions.checkArgument(3 == cmd.length);
                byte[] start = splitAlgo.strToRow(cmd[1]);
                String startStr = splitAlgo.rowToStr(start);
                byte[] splitPoint = splitAlgo.strToRow(cmd[2]);
                String splitStr = splitAlgo.rowToStr(splitPoint);
                Pair<String, String> r = Pair.newPair(startStr, splitStr);
                if (cmd[0].equals("+")) {
                    LOG.debug((Object)("Adding: " + r));
                    daughterRegions.add(r);
                    continue;
                }
                LOG.debug((Object)("Removing: " + r));
                Preconditions.checkArgument(cmd[0].equals("-"), "Unknown option: " + cmd[0]);
                Preconditions.checkState(daughterRegions.contains(r), "Missing row: " + r);
                daughterRegions.remove(r);
            }
            LOG.debug((Object)("Done reading. " + daughterRegions.size() + " regions left."));
        }
        LinkedList<Pair<byte[], byte[]>> ret = Lists.newLinkedList();
        for (Pair pair : daughterRegions) {
            ret.add(Pair.newPair(splitAlgo.strToRow((String)pair.getFirst()), splitAlgo.strToRow((String)pair.getSecond())));
        }
        return ret;
    }

    public static class UniformSplit
    implements SplitAlgorithm {
        static final byte xFF = -1;
        byte[] firstRowBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        byte[] lastRowBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};

        @Override
        public byte[] split(byte[] start, byte[] end) {
            return Bytes.split(start, end, 1)[1];
        }

        @Override
        public byte[][] split(int numRegions) {
            Preconditions.checkArgument(Bytes.compareTo(this.lastRowBytes, this.firstRowBytes) > 0, "last row (%s) is configured less than first row (%s)", Bytes.toStringBinary(this.lastRowBytes), Bytes.toStringBinary(this.firstRowBytes));
            byte[][] splits = Bytes.split(this.firstRowBytes, this.lastRowBytes, true, numRegions - 1);
            Preconditions.checkState(splits != null, "Could not split region with given user input: " + this);
            return (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
        }

        @Override
        public byte[][] split(byte[] start, byte[] end, int numSplits, boolean inclusive) {
            if (Arrays.equals(start, HConstants.EMPTY_BYTE_ARRAY)) {
                start = this.firstRowBytes;
            }
            if (Arrays.equals(end, HConstants.EMPTY_BYTE_ARRAY)) {
                end = this.lastRowBytes;
            }
            Preconditions.checkArgument(Bytes.compareTo(end, start) > 0, "last row (%s) is configured less than first row (%s)", Bytes.toStringBinary(end), Bytes.toStringBinary(start));
            byte[][] splits = Bytes.split(start, end, true, numSplits - 1);
            Preconditions.checkState(splits != null, "Could not calculate input splits with given user input: " + this);
            if (inclusive) {
                return splits;
            }
            return (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
        }

        @Override
        public byte[] firstRow() {
            return this.firstRowBytes;
        }

        @Override
        public byte[] lastRow() {
            return this.lastRowBytes;
        }

        @Override
        public void setFirstRow(String userInput) {
            this.firstRowBytes = Bytes.toBytesBinary(userInput);
        }

        @Override
        public void setLastRow(String userInput) {
            this.lastRowBytes = Bytes.toBytesBinary(userInput);
        }

        @Override
        public void setFirstRow(byte[] userInput) {
            this.firstRowBytes = userInput;
        }

        @Override
        public void setLastRow(byte[] userInput) {
            this.lastRowBytes = userInput;
        }

        @Override
        public byte[] strToRow(String input) {
            return Bytes.toBytesBinary(input);
        }

        @Override
        public String rowToStr(byte[] row) {
            return Bytes.toStringBinary(row);
        }

        @Override
        public String separator() {
            return ",";
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.rowToStr(this.firstRow()) + "," + this.rowToStr(this.lastRow()) + "]";
        }
    }

    public static class HexStringSplit
    implements SplitAlgorithm {
        static final String DEFAULT_MIN_HEX = "00000000";
        static final String DEFAULT_MAX_HEX = "FFFFFFFF";
        String firstRow = "00000000";
        BigInteger firstRowInt = BigInteger.ZERO;
        String lastRow = "FFFFFFFF";
        BigInteger lastRowInt = new BigInteger(this.lastRow, 16);
        int rowComparisonLength = this.lastRow.length();

        @Override
        public byte[] split(byte[] start, byte[] end) {
            BigInteger s = this.convertToBigInteger(start);
            BigInteger e = this.convertToBigInteger(end);
            Preconditions.checkArgument(!e.equals(BigInteger.ZERO));
            return this.convertToByte(this.split2(s, e));
        }

        @Override
        public byte[][] split(int n) {
            Preconditions.checkArgument(this.lastRowInt.compareTo(this.firstRowInt) > 0, "last row (%s) is configured less than first row (%s)", this.lastRow, this.firstRow);
            BigInteger range = this.lastRowInt.subtract(this.firstRowInt).add(BigInteger.ONE);
            Preconditions.checkState(range.compareTo(BigInteger.valueOf(n)) >= 0, "split granularity (%s) is greater than the range (%s)", n, range);
            BigInteger[] splits = new BigInteger[n - 1];
            BigInteger sizeOfEachSplit = range.divide(BigInteger.valueOf(n));
            for (int i = 1; i < n; ++i) {
                splits[i - 1] = this.firstRowInt.add(sizeOfEachSplit.multiply(BigInteger.valueOf(i)));
            }
            return this.convertToBytes(splits);
        }

        @Override
        public byte[][] split(byte[] start, byte[] end, int numSplits, boolean inclusive) {
            BigInteger s = this.convertToBigInteger(start);
            BigInteger e = this.convertToBigInteger(end);
            Preconditions.checkArgument(e.compareTo(s) > 0, "last row (%s) is configured less than first row (%s)", this.rowToStr(end), end);
            BigInteger range = e.subtract(s).add(BigInteger.ONE);
            Preconditions.checkState(range.compareTo(BigInteger.valueOf(numSplits)) >= 0, "split granularity (%s) is greater than the range (%s)", numSplits, range);
            BigInteger[] splits = new BigInteger[numSplits - 1];
            BigInteger sizeOfEachSplit = range.divide(BigInteger.valueOf(numSplits));
            for (int i = 1; i < numSplits; ++i) {
                splits[i - 1] = s.add(sizeOfEachSplit.multiply(BigInteger.valueOf(i)));
            }
            if (inclusive) {
                BigInteger[] inclusiveSplitPoints = new BigInteger[numSplits + 1];
                inclusiveSplitPoints[0] = this.convertToBigInteger(start);
                inclusiveSplitPoints[numSplits] = this.convertToBigInteger(end);
                System.arraycopy(splits, 0, inclusiveSplitPoints, 1, splits.length);
                return this.convertToBytes(inclusiveSplitPoints);
            }
            return this.convertToBytes(splits);
        }

        @Override
        public byte[] firstRow() {
            return this.convertToByte(this.firstRowInt);
        }

        @Override
        public byte[] lastRow() {
            return this.convertToByte(this.lastRowInt);
        }

        @Override
        public void setFirstRow(String userInput) {
            this.firstRow = userInput;
            this.firstRowInt = new BigInteger(this.firstRow, 16);
        }

        @Override
        public void setLastRow(String userInput) {
            this.lastRow = userInput;
            this.lastRowInt = new BigInteger(this.lastRow, 16);
            this.rowComparisonLength = this.lastRow.length();
        }

        @Override
        public byte[] strToRow(String in) {
            return this.convertToByte(new BigInteger(in, 16));
        }

        @Override
        public String rowToStr(byte[] row) {
            return Bytes.toStringBinary(row);
        }

        @Override
        public String separator() {
            return " ";
        }

        @Override
        public void setFirstRow(byte[] userInput) {
            this.firstRow = Bytes.toString(userInput);
        }

        @Override
        public void setLastRow(byte[] userInput) {
            this.lastRow = Bytes.toString(userInput);
        }

        public BigInteger split2(BigInteger a, BigInteger b) {
            return a.add(b).divide(BigInteger.valueOf(2L)).abs();
        }

        public byte[][] convertToBytes(BigInteger[] bigIntegers) {
            byte[][] returnBytes = new byte[bigIntegers.length][];
            for (int i = 0; i < bigIntegers.length; ++i) {
                returnBytes[i] = this.convertToByte(bigIntegers[i]);
            }
            return returnBytes;
        }

        public static byte[] convertToByte(BigInteger bigInteger, int pad) {
            String bigIntegerString = bigInteger.toString(16);
            bigIntegerString = StringUtils.leftPad(bigIntegerString, pad, '0');
            return Bytes.toBytes(bigIntegerString);
        }

        public byte[] convertToByte(BigInteger bigInteger) {
            return HexStringSplit.convertToByte(bigInteger, this.rowComparisonLength);
        }

        public BigInteger convertToBigInteger(byte[] row) {
            return row.length > 0 ? new BigInteger(Bytes.toString(row), 16) : BigInteger.ZERO;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.rowToStr(this.firstRow()) + "," + this.rowToStr(this.lastRow()) + "]";
        }
    }

    public static interface SplitAlgorithm {
        public byte[] split(byte[] var1, byte[] var2);

        public byte[][] split(int var1);

        public byte[][] split(byte[] var1, byte[] var2, int var3, boolean var4);

        public byte[] firstRow();

        public byte[] lastRow();

        public void setFirstRow(String var1);

        public void setLastRow(String var1);

        public byte[] strToRow(String var1);

        public String rowToStr(byte[] var1);

        public String separator();

        public void setFirstRow(byte[] var1);

        public void setLastRow(byte[] var1);
    }
}

