/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.math.genetics;

import java.util.ArrayList;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.genetics.Chromosome;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.genetics.ChromosomePair;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.genetics.GeneticAlgorithm;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.genetics.ListPopulation;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.genetics.Population;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math.genetics.SelectionPolicy;

public class TournamentSelection
implements SelectionPolicy {
    private int arity;

    public TournamentSelection(int arity) {
        this.arity = arity;
    }

    public ChromosomePair select(Population population) {
        return new ChromosomePair(this.tournament((ListPopulation)population), this.tournament((ListPopulation)population));
    }

    private Chromosome tournament(ListPopulation population) {
        if (population.getPopulationSize() < this.arity) {
            throw new IllegalArgumentException("Tournament arity cannot be bigger than population size.");
        }
        ListPopulation tournamentPopulation = new ListPopulation(this.arity){

            public Population nextGeneration() {
                return null;
            }
        };
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>(population.getChromosomes());
        for (int i = 0; i < this.arity; ++i) {
            int rind = GeneticAlgorithm.getRandomGenerator().nextInt(chromosomes.size());
            tournamentPopulation.addChromosome((Chromosome)chromosomes.get(rind));
            chromosomes.remove(rind);
        }
        return tournamentPopulation.getFittestChromosome();
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }
}

