/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.DaemonContext;
import org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.DaemonController;
import org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.DaemonInitException;

public final class DaemonLoader {
    private static Controller controller = null;
    private static Object daemon = null;
    private static Method init = null;
    private static Method start = null;
    private static Method stop = null;
    private static Method destroy = null;
    private static Method signal = null;
    static /* synthetic */ Class class$org$apache$commons$daemon$support$DaemonLoader;
    static /* synthetic */ Class class$org$apache$commons$daemon$support$DaemonWrapper;
    static /* synthetic */ Class class$org$apache$commons$daemon$DaemonContext;

    public static void version() {
        System.err.println("java version \"" + System.getProperty("java.version") + "\"");
        System.err.println(System.getProperty("java.runtime.name") + " (build " + System.getProperty("java.runtime.version") + ")");
        System.err.println(System.getProperty("java.vm.name") + " (build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")");
        System.err.println("commons daemon version \"" + System.getProperty("commons.daemon.version") + "\"");
        System.err.println("commons daemon process (id: " + System.getProperty("commons.daemon.process.id") + ", parent: " + System.getProperty("commons.daemon.process.parent") + ")");
    }

    public static boolean check(String cn) {
        try {
            if (cn == null) {
                throw new NullPointerException("Null class name specified");
            }
            ClassLoader cl = (class$org$apache$commons$daemon$support$DaemonLoader == null ? (class$org$apache$commons$daemon$support$DaemonLoader = DaemonLoader.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.support.DaemonLoader")) : class$org$apache$commons$daemon$support$DaemonLoader).getClassLoader();
            if (cl == null) {
                System.err.println("Cannot retrieve ClassLoader instance");
                return false;
            }
            Class<?> c = cl.loadClass(cn);
            if (c == null) {
                throw new ClassNotFoundException(cn);
            }
            c.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean signal() {
        try {
            if (signal != null) {
                signal.invoke(daemon, new Object[0]);
                return true;
            }
            System.out.println("Daemon doesn't support signaling");
        }
        catch (Throwable ex) {
            System.err.println("Cannot send signal: " + ex);
            ex.printStackTrace(System.err);
        }
        return false;
    }

    public static boolean load(String className, String[] args) {
        try {
            Class c;
            System.gc();
            if (args == null) {
                args = new String[]{};
            }
            if (className == null) {
                throw new NullPointerException("Null class name specified");
            }
            ClassLoader cl = (class$org$apache$commons$daemon$support$DaemonLoader == null ? (class$org$apache$commons$daemon$support$DaemonLoader = DaemonLoader.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.support.DaemonLoader")) : class$org$apache$commons$daemon$support$DaemonLoader).getClassLoader();
            if (cl == null) {
                System.err.println("Cannot retrieve ClassLoader instance");
                return false;
            }
            if (className.charAt(0) == '@') {
                c = class$org$apache$commons$daemon$support$DaemonWrapper == null ? (class$org$apache$commons$daemon$support$DaemonWrapper = DaemonLoader.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.support.DaemonWrapper")) : class$org$apache$commons$daemon$support$DaemonWrapper;
                String[] a = new String[args.length + 2];
                a[0] = "-start";
                a[1] = className.substring(1);
                System.arraycopy(args, 0, a, 2, args.length);
                args = a;
            } else {
                c = cl.loadClass(className);
            }
            if (c == null) {
                throw new ClassNotFoundException(className);
            }
            boolean isdaemon = false;
            try {
                Class<?> dclass = cl.loadClass("org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.Daemon");
                isdaemon = dclass.isAssignableFrom(c);
            }
            catch (Exception cnfex) {
                // empty catch block
            }
            Class[] myclass = new Class[]{isdaemon ? (class$org$apache$commons$daemon$DaemonContext == null ? (class$org$apache$commons$daemon$DaemonContext = DaemonLoader.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.daemon.DaemonContext")) : class$org$apache$commons$daemon$DaemonContext) : args.getClass()};
            init = c.getMethod("init", myclass);
            myclass = null;
            start = c.getMethod("start", myclass);
            stop = c.getMethod("stop", myclass);
            destroy = c.getMethod("destroy", myclass);
            try {
                signal = c.getMethod("signal", myclass);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            daemon = c.newInstance();
            if (isdaemon) {
                controller = new Controller();
                DaemonLoader.controller.setAvailable(false);
                Context context = new Context();
                context.setArguments(args);
                context.setController(controller);
                Object[] arg = new Object[]{context};
                init.invoke(daemon, arg);
            } else {
                Object[] arg = new Object[]{args};
                init.invoke(daemon, arg);
            }
        }
        catch (InvocationTargetException e) {
            Throwable thrown = e.getTargetException();
            if (thrown instanceof DaemonInitException) {
                DaemonLoader.failed(((DaemonInitException)thrown).getMessageWithCause());
            } else {
                thrown.printStackTrace(System.err);
            }
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean start() {
        try {
            Object[] arg = null;
            start.invoke(daemon, arg);
            if (controller != null) {
                DaemonLoader.controller.setAvailable(true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean stop() {
        try {
            if (controller != null) {
                DaemonLoader.controller.setAvailable(false);
            }
            Object[] arg = null;
            stop.invoke(daemon, arg);
            System.gc();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean destroy() {
        try {
            Object[] arg = null;
            destroy.invoke(daemon, arg);
            daemon = null;
            controller = null;
            System.gc();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private static native void shutdown(boolean var0);

    private static native void failed(String var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Context
    implements DaemonContext {
        private DaemonController daemonController = null;
        private String[] args = null;

        public DaemonController getController() {
            return this.daemonController;
        }

        public void setController(DaemonController controller) {
            this.daemonController = controller;
        }

        public String[] getArguments() {
            return this.args;
        }

        public void setArguments(String[] args) {
            this.args = args;
        }
    }

    public static class Controller
    implements DaemonController {
        private boolean available = false;

        private Controller() {
            this.setAvailable(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isAvailable() {
            Controller controller = this;
            synchronized (controller) {
                return this.available;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setAvailable(boolean available) {
            Controller controller = this;
            synchronized (controller) {
                this.available = available;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws IllegalStateException {
            Controller controller = this;
            synchronized (controller) {
                if (!this.isAvailable()) {
                    throw new IllegalStateException();
                }
                this.setAvailable(false);
                DaemonLoader.shutdown(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() throws IllegalStateException {
            Controller controller = this;
            synchronized (controller) {
                if (!this.isAvailable()) {
                    throw new IllegalStateException();
                }
                this.setAvailable(false);
                DaemonLoader.shutdown(true);
            }
        }

        public void fail() {
            this.fail(null, null);
        }

        public void fail(String message) {
            this.fail(message, null);
        }

        public void fail(Exception exception) {
            this.fail(null, exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fail(String message, Exception exception) {
            Controller controller = this;
            synchronized (controller) {
                this.setAvailable(false);
                String msg = message;
                if (exception != null) {
                    msg = msg != null ? msg + ": " + exception.toString() : exception.toString();
                }
                DaemonLoader.failed(msg);
            }
        }
    }
}

