/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.DynaBean;
import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.DynaClass;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.ConfigurationMap;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.ConversionException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils.ConfigurationDynaClass;

public class ConfigurationDynaBean
extends ConfigurationMap
implements DynaBean {
    private static final String PROPERTY_DELIMITER = ".";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean == null ? (class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean = ConfigurationDynaBean.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils.ConfigurationDynaBean")) : class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean));
    static /* synthetic */ Class class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean;

    public ConfigurationDynaBean(Configuration configuration) {
        super(configuration);
        if (log.isTraceEnabled()) {
            log.trace((Object)("ConfigurationDynaBean(" + configuration + ")"));
        }
    }

    public void set(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("set(" + name + "," + value + ")"));
        }
        if (value == null) {
            throw new NullPointerException("Error trying to set property to null.");
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.getConfiguration().addProperty(name, iterator.next());
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                this.getConfiguration().addProperty(name, Array.get(value, i));
            }
        } else {
            this.getConfiguration().setProperty(name, value);
        }
    }

    public Object get(String name) {
        SubsetConfiguration subset;
        Object result;
        if (log.isTraceEnabled()) {
            log.trace((Object)("get(" + name + ")"));
        }
        if ((result = this.getConfiguration().getProperty(name)) == null && !(subset = new SubsetConfiguration(this.getConfiguration(), name, PROPERTY_DELIMITER)).isEmpty()) {
            result = new ConfigurationDynaBean(subset);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(name + "=[" + result + "]"));
        }
        if (result == null) {
            throw new IllegalArgumentException("Property '" + name + "' does not exist.");
        }
        return result;
    }

    public boolean contains(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.containsKey(key);
    }

    public Object get(String name, int index) {
        try {
            List list = this.getConfiguration().getList(name);
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Indexed property '" + name + "' does not exist.");
            }
            return list.get(index);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
        }
    }

    public Object get(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.getProperty(key);
    }

    public DynaClass getDynaClass() {
        return new ConfigurationDynaClass(this.getConfiguration());
    }

    public void remove(String name, String key) {
        SubsetConfiguration subset = new SubsetConfiguration(this.getConfiguration(), name, PROPERTY_DELIMITER);
        subset.setProperty(key, null);
    }

    public void set(String name, int index, Object value) {
        block6: {
            try {
                Object property = this.getConfiguration().getProperty(name);
                if (property == null) {
                    throw new IllegalArgumentException("Property '" + name + "' does not exist.");
                }
                if (property instanceof List) {
                    List list = (List)property;
                    list.set(index, value);
                    this.getConfiguration().setProperty(name, list);
                    break block6;
                }
                if (property.getClass().isArray()) {
                    Array.set(property, index, value);
                    break block6;
                }
                if (index == 0) {
                    this.getConfiguration().setProperty(name, value);
                    break block6;
                }
                throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
            }
        }
    }

    public void set(String name, String key, Object value) {
        this.getConfiguration().setProperty(name + PROPERTY_DELIMITER + key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

