/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.RegionServerTableMetrics;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    public static final String RS_ENABLE_TABLE_METRICS_KEY = "hbase.regionserver.enable.table.latencies";
    public static final boolean RS_ENABLE_TABLE_METRICS_DEFAULT = true;
    private MetricsRegionServerSource serverSource;
    private MetricsRegionServerWrapper regionServerWrapper;
    private RegionServerTableMetrics tableMetrics;

    public MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, Configuration conf) {
        this(regionServerWrapper, CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createServer(regionServerWrapper), MetricsRegionServer.createTableMetrics(conf));
    }

    MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource, RegionServerTableMetrics tableMetrics) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
        this.tableMetrics = tableMetrics;
    }

    static RegionServerTableMetrics createTableMetrics(Configuration conf) {
        if (conf.getBoolean(RS_ENABLE_TABLE_METRICS_KEY, true)) {
            return new RegionServerTableMetrics();
        }
        return null;
    }

    @VisibleForTesting
    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePut(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updatePut(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePut(t);
    }

    public void updateDelete(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateDelete(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDelete(t);
    }

    public void updateGet(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateGet(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(t);
    }

    public void updateIncrement(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateIncrement(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(t);
    }

    public void updateAppend(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateAppend(tn, t);
        }
        if (t > 1000L) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(t);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
    }

    public void updateScanSize(TableName tn, long scanSize) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateScanSize(tn, scanSize);
        }
        this.serverSource.updateScanSize(scanSize);
    }

    public void updateScanTime(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateScanTime(tn, t);
        }
        this.serverSource.updateScanTime(t);
    }

    public void updateSplitTime(long t) {
        this.serverSource.updateSplitTime(t);
    }

    public void incrSplitRequest() {
        this.serverSource.incrSplitRequest();
    }

    public void incrSplitSuccess() {
        this.serverSource.incrSplitSuccess();
    }

    public void updateFlush(long t, long memstoreSize, long fileSize) {
        this.serverSource.updateFlushTime(t);
        this.serverSource.updateFlushMemstoreSize(memstoreSize);
        this.serverSource.updateFlushOutputSize(fileSize);
    }

    public void updateCompaction(boolean isMajor, long t, int inputFileCount, int outputFileCount, long inputBytes, long outputBytes) {
        this.serverSource.updateCompactionTime(isMajor, t);
        this.serverSource.updateCompactionInputFileCount(isMajor, inputFileCount);
        this.serverSource.updateCompactionOutputFileCount(isMajor, outputFileCount);
        this.serverSource.updateCompactionInputSize(isMajor, inputBytes);
        this.serverSource.updateCompactionOutputSize(isMajor, outputBytes);
    }
}

