/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ReplicationZKLockCleanerChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(ReplicationZKLockCleanerChore.class);
    private ZooKeeperWatcher zk;
    private ReplicationTracker tracker;
    private long ttl;
    private ReplicationQueuesZKImpl queues;
    private static final long DEFAULT_TTL = 600000L;
    @VisibleForTesting
    public static final String TTL_CONFIG_KEY = "hbase.replication.zk.deadrs.lock.ttl";

    public ReplicationZKLockCleanerChore(Stoppable stopper, Abortable abortable, int period, ZooKeeperWatcher zk, Configuration conf) throws Exception {
        super("ReplicationZKLockCleanerChore", stopper, period);
        this.zk = zk;
        this.ttl = conf.getLong(TTL_CONFIG_KEY, 600000L);
        this.tracker = ReplicationFactory.getReplicationTracker(zk, ReplicationFactory.getReplicationPeers(zk, conf, abortable), conf, abortable, stopper);
        this.queues = new ReplicationQueuesZKImpl(zk, conf, abortable);
    }

    @Override
    protected void chore() {
        try {
            List<String> regionServers = this.tracker.getListOfRegionServers();
            if (regionServers == null) {
                return;
            }
            HashSet<String> rsSet = new HashSet<String>(regionServers);
            List<String> replicators = this.queues.getListOfReplicators();
            if (replicators == null || replicators.isEmpty()) {
                return;
            }
            for (String replicator : replicators) {
                try {
                    String lockNode = this.queues.getLockZNode(replicator);
                    byte[] data = ZKUtil.getData(this.zk, lockNode);
                    if (data == null) continue;
                    String rsServerNameZnode = Bytes.toString(data);
                    String[] array = rsServerNameZnode.split("/");
                    String znode = array[array.length - 1];
                    if (!rsSet.contains(znode)) {
                        Stat s = this.zk.getRecoverableZooKeeper().exists(lockNode, false);
                        if (s == null || EnvironmentEdgeManager.currentTime() - s.getMtime() <= this.ttl) continue;
                        ZKUtil.deleteNode(this.zk, lockNode);
                        LOG.info((Object)("Remove lock acquired by dead RS: " + lockNode + " by " + znode));
                        continue;
                    }
                    LOG.info((Object)("Skip lock acquired by live RS: " + lockNode + " by " + znode));
                }
                catch (KeeperException.NoNodeException lockNode) {
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"zk operation interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"zk operation interrupted", (Throwable)e);
        }
        catch (ReplicationException e2) {
            LOG.warn((Object)"replication exception", (Throwable)e2);
        }
    }
}

