/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.AsyncCall;
import org.apache.hadoop.hbase.ipc.AsyncRpcChannel;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.hbase.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class AsyncServerResponseHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final AsyncRpcChannel channel;

    public AsyncServerResponseHandler(AsyncRpcChannel channel) {
        this.channel = channel;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf inBuffer) throws Exception {
        ByteBufInputStream in = new ByteBufInputStream(inBuffer);
        int totalSize = inBuffer.readableBytes();
        RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom(in);
        int id = responseHeader.getCallId();
        AsyncCall call = this.channel.removePendingCall(id);
        if (call == null) {
            int readSoFar = IPCUtil.getTotalSizeWhenWrittenDelimited(responseHeader);
            int whatIsLeftToRead = totalSize - readSoFar;
            inBuffer.skipBytes(whatIsLeftToRead);
            return;
        }
        if (responseHeader.hasException()) {
            RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
            RemoteException re = this.createRemoteException(exceptionResponse);
            if (exceptionResponse.getExceptionClassName().equals(FatalConnectionException.class.getName())) {
                this.channel.close(re);
            } else {
                call.setFailed(re);
            }
        } else {
            Message value = null;
            if (call.responseDefaultType != null) {
                Message.Builder builder = call.responseDefaultType.newBuilderForType();
                ProtobufUtil.mergeDelimitedFrom(builder, in);
                value = builder.build();
            }
            CellScanner cellBlockScanner = null;
            if (responseHeader.hasCellBlockMeta()) {
                int size = responseHeader.getCellBlockMeta().getLength();
                byte[] cellBlock = new byte[size];
                inBuffer.readBytes(cellBlock, 0, cellBlock.length);
                cellBlockScanner = this.channel.client.createCellScanner(cellBlock);
            }
            call.setSuccess(value, cellBlockScanner);
            call.callStats.setResponseSizeBytes(totalSize);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.channel.close(cause);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.channel.close(new IOException("connection closed"));
    }

    private RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
        String innerExceptionClassName = e.getExceptionClassName();
        boolean doNotRetry = e.getDoNotRetry();
        return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
    }
}

