/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class Reference {
    private byte[] splitkey;
    private Range region;

    public static Reference createTopReference(byte[] splitRow) {
        return new Reference(splitRow, Range.top);
    }

    public static Reference createBottomReference(byte[] splitRow) {
        return new Reference(splitRow, Range.bottom);
    }

    Reference(byte[] splitRow, Range fr) {
        this.splitkey = splitRow == null ? null : KeyValueUtil.createFirstOnRow(splitRow).getKey();
        this.region = fr;
    }

    @Deprecated
    public Reference() {
        this(null, Range.bottom);
    }

    public Range getFileRegion() {
        return this.region;
    }

    public byte[] getSplitKey() {
        return this.splitkey;
    }

    public String toString() {
        return "" + (Object)((Object)this.region);
    }

    public static boolean isTopFileRegion(Range r) {
        return r.equals((Object)Range.top);
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        boolean tmp = in.readBoolean();
        this.region = tmp ? Range.top : Range.bottom;
        this.splitkey = Bytes.readByteArray(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path write(FileSystem fs, Path p) throws IOException {
        try (FSDataOutputStream out = fs.create(p, false);){
            out.write(this.toByteArray());
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reference read(FileSystem fs, Path p) throws IOException {
        try (DataInputStream in = fs.open(p);){
            DataInputStream dis;
            in = ((InputStream)in).markSupported() ? in : new BufferedInputStream(in);
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ((InputStream)in).mark(pblen);
            byte[] pbuf = new byte[pblen];
            int read = ((InputStream)in).read(pbuf);
            if (read != pblen) {
                throw new IOException("read=" + read + ", wanted=" + pblen);
            }
            if (ProtobufUtil.isPBMagicPrefix(pbuf)) {
                Reference reference = Reference.convert(FSProtos.Reference.parseFrom(in));
                return reference;
            }
            ((InputStream)in).reset();
            Reference r = new Reference();
            in = dis = new DataInputStream(in);
            r.readFields(dis);
            Reference reference = r;
            return reference;
        }
    }

    public FSProtos.Reference convert() {
        FSProtos.Reference.Builder builder = FSProtos.Reference.newBuilder();
        builder.setRange(Reference.isTopFileRegion(this.getFileRegion()) ? FSProtos.Reference.Range.TOP : FSProtos.Reference.Range.BOTTOM);
        builder.setSplitkey(ByteStringer.wrap(this.getSplitKey()));
        return builder.build();
    }

    public static Reference convert(FSProtos.Reference r) {
        Reference result = new Reference();
        result.splitkey = r.getSplitkey().toByteArray();
        result.region = r.getRange() == FSProtos.Reference.Range.TOP ? Range.top : Range.bottom;
        return result;
    }

    byte[] toByteArray() throws IOException {
        return ProtobufUtil.prependPBMagic(this.convert().toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.splitkey) + this.region.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference r = (Reference)o;
        if (this.splitkey != null && r.splitkey == null) {
            return false;
        }
        if (this.splitkey == null && r.splitkey != null) {
            return false;
        }
        if (this.splitkey != null && !Arrays.equals(this.splitkey, r.splitkey)) {
            return false;
        }
        return this.region.equals((Object)r.region);
    }

    static enum Range {
        top,
        bottom;

    }
}

